/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateAttributeBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoService;
import org.kuali.rice.krms.impl.repository.language.SimpleNaturalLanguageTemplater;

public class NaturalLanguageTemplateBoServiceImpl
implements NaturalLanguageTemplateBoService {
    private DataObjectService dataObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;
    private NaturalLanguageTemplaterContract naturalLanguageTemplater = new SimpleNaturalLanguageTemplater();

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    public NaturalLanguageTemplaterContract getNaturalLanguageTemplater() {
        return this.naturalLanguageTemplater;
    }

    public void setNaturalLanguageTemplater(NaturalLanguageTemplaterContract naturalLanguageTemplater) {
        this.naturalLanguageTemplater = naturalLanguageTemplater;
    }

    @Override
    public NaturalLanguageTemplate createNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) {
        NaturalLanguageTemplate naturalLanguageTemplateUpdated;
        this.incomingParamCheck(naturalLanguageTemplate, "naturalLanguageTemplate");
        if (StringUtils.isNotBlank((String)naturalLanguageTemplate.getId())) {
            String naturalLanguageTemplateIdKey = naturalLanguageTemplate.getId();
            NaturalLanguageTemplate existing = this.getNaturalLanguageTemplate(naturalLanguageTemplateIdKey);
            if (existing != null) {
                throw new IllegalStateException("the NaturalLanguageTemplate to create already exists: " + String.valueOf(naturalLanguageTemplate));
            }
            NaturalLanguageTemplateBo bo = (NaturalLanguageTemplateBo)this.dataObjectService.save((Object)this.from(naturalLanguageTemplate), new PersistenceOption[]{PersistenceOption.FLUSH});
            naturalLanguageTemplateUpdated = NaturalLanguageTemplateBo.to(bo);
        } else {
            HashMap attributes = new HashMap(naturalLanguageTemplate.getAttributes());
            NaturalLanguageTemplateBo bo = (NaturalLanguageTemplateBo)this.dataObjectService.save((Object)this.from(naturalLanguageTemplate), new PersistenceOption[]{PersistenceOption.FLUSH});
            NaturalLanguageTemplate.Builder naturalLanguageTemplateBuilder = NaturalLanguageTemplate.Builder.create((String)bo.getLanguageCode(), (String)bo.getNaturalLanguageUsageId(), (String)bo.getTemplate(), (String)bo.getTypeId());
            naturalLanguageTemplateBuilder.setActive(bo.isActive());
            naturalLanguageTemplateBuilder.setId(bo.getId());
            naturalLanguageTemplateBuilder.setVersionNumber(bo.getVersionNumber());
            naturalLanguageTemplateBuilder.setAttributes(attributes);
            naturalLanguageTemplateUpdated = naturalLanguageTemplateBuilder.build();
            this.updateNaturalLanguageTemplate(naturalLanguageTemplateUpdated);
        }
        return naturalLanguageTemplateUpdated;
    }

    @Override
    public NaturalLanguageTemplate getNaturalLanguageTemplate(String naturalLanguageTemplateId) {
        this.incomingParamCheck(naturalLanguageTemplateId, "naturalLanguageTemplateId");
        NaturalLanguageTemplateBo bo = (NaturalLanguageTemplateBo)this.dataObjectService.find(NaturalLanguageTemplateBo.class, (Object)naturalLanguageTemplateId);
        return NaturalLanguageTemplateBo.to(bo);
    }

    @Override
    public NaturalLanguageTemplate updateNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) {
        NaturalLanguageTemplate toUpdate;
        this.incomingParamCheck(naturalLanguageTemplate, "naturalLanguageTemplate");
        NaturalLanguageTemplate existing = this.getNaturalLanguageTemplate(naturalLanguageTemplate.getId());
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageTemplate to update does not exists: " + String.valueOf(naturalLanguageTemplate));
        }
        if (!existing.getId().equals(naturalLanguageTemplate.getId())) {
            NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)naturalLanguageTemplate);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = naturalLanguageTemplate;
        }
        NaturalLanguageTemplateBo boToUpdate = this.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("naturalLanguageTemplateId", toUpdate.getId());
        BusinessObjectServiceMigrationUtils.deleteMatching(this.dataObjectService, NaturalLanguageTemplateAttributeBo.class, fields);
        NaturalLanguageTemplateBo updatedData = (NaturalLanguageTemplateBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        return this.to(updatedData);
    }

    @Override
    public void deleteNaturalLanguageTemplate(String naturalLanguageTemplateId) {
        this.incomingParamCheck(naturalLanguageTemplateId, "naturalLanguageTemplateId");
        NaturalLanguageTemplate existing = this.getNaturalLanguageTemplate(naturalLanguageTemplateId);
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageTemplate to delete does not exists: " + naturalLanguageTemplateId);
        }
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("naturalLanguageTemplateId", existing.getId());
        BusinessObjectServiceMigrationUtils.deleteMatching(this.dataObjectService, NaturalLanguageTemplateAttributeBo.class, fields);
        this.dataObjectService.delete((Object)this.from(existing));
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByAttributes(Map attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("attributes", attributes);
        List<NaturalLanguageTemplateBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByLanguageCode(String languageCode) {
        if (StringUtils.isBlank((String)languageCode)) {
            throw new IllegalArgumentException("languageCode is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("languageCode", languageCode);
        List<NaturalLanguageTemplateBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public NaturalLanguageTemplate findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(String languageCode, String typeId, String naturalLanguageUsageId) {
        if (StringUtils.isBlank((String)languageCode)) {
            throw new IllegalArgumentException("languageCode is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("languageCode", languageCode);
        map.put("naturalLanguageUsageId", naturalLanguageUsageId);
        map.put("typeId", typeId);
        List<NaturalLanguageTemplateBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageTemplateBo.class, map);
        if (bos.isEmpty()) {
            return null;
        }
        if (bos.size() > 1) {
            throw new RiceIllegalArgumentException(languageCode + typeId + naturalLanguageUsageId + " is supposed to be unique");
        }
        return this.convertBosToImmutables(bos).get(0);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByNaturalLanguageUsage(String naturalLanguageUsageId) {
        if (StringUtils.isBlank((String)naturalLanguageUsageId)) {
            throw new IllegalArgumentException("naturalLanguageUsageId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("naturalLanguageUsageId", naturalLanguageUsageId);
        List<NaturalLanguageTemplateBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByType(String typeId) {
        if (StringUtils.isBlank((String)typeId)) {
            throw new IllegalArgumentException("typeId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        List<NaturalLanguageTemplateBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByTemplate(String template) {
        if (StringUtils.isBlank((String)template)) {
            throw new IllegalArgumentException("template is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("template", template);
        List<NaturalLanguageTemplateBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    public List<NaturalLanguageTemplate> convertBosToImmutables(Collection<NaturalLanguageTemplateBo> naturalLanguageTemplateBos) {
        LinkedList<NaturalLanguageTemplate> immutables = new LinkedList<NaturalLanguageTemplate>();
        if (naturalLanguageTemplateBos != null) {
            NaturalLanguageTemplate immutable = null;
            for (NaturalLanguageTemplateBo bo : naturalLanguageTemplateBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableList(immutables);
    }

    @Override
    public NaturalLanguageTemplate to(NaturalLanguageTemplateBo naturalLanguageTemplateBo) {
        return NaturalLanguageTemplateBo.to(naturalLanguageTemplateBo);
    }

    @Override
    public NaturalLanguageTemplateBo from(NaturalLanguageTemplate naturalLanguageTemplate) {
        return NaturalLanguageTemplateBo.from(naturalLanguageTemplate);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new IllegalArgumentException(name + " was blank");
        }
    }
}

