/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class CryptoDiscoverer {
    private static String EOL = System.getProperty("line.separator", "\n");

    public static void main(String ... args) {
        String provider = ".*";
        String algorithm = ".*";
        if (args.length > 0) {
            List<String> argList;
            int argIdx;
            if (args[0].equals("--help")) {
                CryptoDiscoverer.usage();
                System.exit(0);
            }
            if ((argIdx = (argList = Arrays.asList(args)).indexOf("--provider")) > -1 && argList.size() > argIdx + 1) {
                provider = argList.get(argIdx + 1);
            }
            if ((argIdx = argList.indexOf("--algorithm")) > -1 && argList.size() > argIdx + 1) {
                algorithm = argList.get(argIdx + 1);
            }
        }
        Pattern providerPattern = Pattern.compile(provider);
        Pattern algorithmPattern = Pattern.compile(algorithm);
        System.out.println("Searching for Providers Matching: " + provider);
        System.out.println("Searching for Algorithms Matching: " + algorithm);
        System.out.println();
        for (Provider p : Security.getProviders()) {
            if (!providerPattern.matcher(p.getName()).matches()) continue;
            System.out.println("Provider: " + p.getName());
            for (Provider.Service service : p.getServices()) {
                if (!algorithmPattern.matcher(service.getAlgorithm()).matches()) continue;
                System.out.println("\tAlgorithm: " + service.getAlgorithm());
            }
        }
    }

    private static void usage() {
        System.out.println("CryptoDiscoverer - Discover or Query for available Crypto Providers and Algorithms");
        System.out.println(EOL + "\t--help\t\t\t\t\tShows this message" + EOL + "\t--provider <regex>\t\tSearch for particular Provider" + EOL + "\t--algorithm <regex>\t\tSearch for a particular Algorithm" + EOL + EOL);
    }
}

