/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.fundingproposal.BaseFieldsDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.CommentsDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.CostSharingDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.CustomDataDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.FandARatesDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.KeywordsDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.LeadUnitDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.ProjectPersonnelDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.SpecialReviewDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.SponsorDataFeedCommand;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardFundingProposalBean
implements Serializable {
    private static final long serialVersionUID = 7278945841002454778L;
    private static final String FUNDING_PROPOSAL_ERROR_KEY = "fundingProposalBean.newFundingProposal";
    private static final String FUNDING_PROPOSAL_NOT_FOUND_ERROR_KEY = "error.fundingproposal.not.found";
    private static final String PENDING_FUNDING_PROPOSAL_VERSION_EXISTS = "error.fundingproposal.pendingVersion";
    private static final String FUNDING_PROPOSAL_INADEQUATE_PERMISSIONS = "error.fundingproposal.noPermission";
    private static final String FUNDING_PROPOSAL_ALREADY_ADDED = "error.fundingProposal.alreadyAdded";
    private static final String FUNDING_PROPOSAL_INVALID_STATUS = "error.fundingProposal.invalidStatus";
    private static final String FUNDING_PROPOSAL_INVALID_DEVELOPMENTPROPOSAL_STATUS = "error.fundingProposal.developmentProposal.approvalPendingSubmitted";
    private AwardForm awardForm;
    private InstitutionalProposal newFundingProposal;
    private String mergeTypeCode;
    private List<Award> allAwardsForAwardNumber;
    private transient DataObjectService dataObjectService;
    private transient BusinessObjectService businessObjectService;
    private transient AwardService awardService;
    private transient InstitutionalProposalService institutionalProposalService;
    private transient PermissionService permissionService;

    public AwardFundingProposalBean(AwardForm awardForm) {
        this.awardForm = awardForm;
        this.createNewFundingProposal();
    }

    public AwardFundingProposalBean() {
        this.createNewFundingProposal();
    }

    public void addFundingProposal() {
        if (this.getNewFundingProposal() != null) {
            this.validateAndPerformFeed(this.awardForm.getFundingProposalBean().getAllAwardsForAwardNumber(this.awardForm.getAwardDocument().getAward()), this.getAward());
            this.createNewFundingProposal();
        }
    }

    public void validateAndPerformFeed(List<Award> awards, Award awardToAdd) {
        if (this.validateForAdd(awards)) {
            awardToAdd.add(this.newFundingProposal);
            this.performDataFeeds(awardToAdd, this.newFundingProposal);
        }
    }

    public void deleteAwardFundingProposal(int index) {
        if (CollectionUtils.validIndexForList(index, this.getAward().getAllFundingProposalsSortedBySequence())) {
            this.getAward().removeFundingProposal(index);
        }
    }

    public List<Award> getAllAwardsForAwardNumber(Award award) {
        if (this.allAwardsForAwardNumber == null) {
            this.allAwardsForAwardNumber = this.getAwardService().findAwardsForAwardNumber(award.getAwardNumber());
            if (award.isPersisted()) {
                this.replaceThisAwardInListOfFoundAwards(award);
            } else {
                this.addUnsavedAwardToListOfAwards(award);
            }
        }
        return this.allAwardsForAwardNumber;
    }

    public ScaleTwoDecimal getTotalCostOfFundingProposals() {
        return this.getAward().getAllFundingProposals().stream().filter(AwardFundingProposal::isActive).map(afp -> afp.getProposal().getTotalCost()).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
    }

    private void replaceThisAwardInListOfFoundAwards(Award thisAward) {
        int lastIndex = this.allAwardsForAwardNumber.size() - 1;
        if (lastIndex >= 0 && this.allAwardsForAwardNumber.get(lastIndex).getAwardId().equals(thisAward.getAwardId())) {
            this.allAwardsForAwardNumber.set(lastIndex, thisAward);
        }
    }

    public void setAllAwardsForAwardNumber(List<Award> allAwardsForAwardNumber) {
        this.allAwardsForAwardNumber = allAwardsForAwardNumber;
    }

    private void addUnsavedAwardToListOfAwards(Award thisAward) {
        if (thisAward.getAwardId() == null) {
            this.allAwardsForAwardNumber.add(thisAward);
        }
    }

    public int getAllAwardsForAwardNumberSize() {
        return this.getAllAwardsForAwardNumber(this.awardForm.getAwardDocument().getAward()).size();
    }

    public InstitutionalProposal getNewFundingProposal() {
        this.lazilyLoadFundingProposal();
        return this.newFundingProposal;
    }

    public void setNewFundingProposal(InstitutionalProposal newFundingProposal) {
        this.newFundingProposal = newFundingProposal;
    }

    public String getMergeTypeCode() {
        return this.mergeTypeCode;
    }

    public void setMergeTypeCode(String mergeTypeCode) {
        this.mergeTypeCode = mergeTypeCode;
    }

    public FundingProposalMergeType getMergeType() {
        return FundingProposalMergeType.getFundingProposalMergeType(this.getMergeTypeCode());
    }

    public void setMergeType(FundingProposalMergeType mergeType) {
        this.mergeTypeCode = mergeType.getKey();
    }

    private void createNewFundingProposal() {
        this.newFundingProposal = new InstitutionalProposal();
        this.newFundingProposal.setProposalNumber(null);
        this.mergeTypeCode = FundingProposalMergeType.NOCHANGE.getKey();
    }

    Award getAward() {
        return this.awardForm.getAwardDocument().getAward();
    }

    private void lazilyLoadFundingProposal() {
        Long proposalId = this.newFundingProposal.getProposalId();
        String proposalNumber = this.newFundingProposal.getProposalNumber();
        InstitutionalProposal foundProposal = null;
        if (proposalId != null) {
            foundProposal = this.findProposalById(proposalId);
        } else if (proposalNumber != null) {
            foundProposal = this.findProposalByProposalNumber(proposalNumber);
        }
        if (foundProposal != null) {
            this.newFundingProposal = foundProposal;
        }
    }

    private InstitutionalProposal findProposalById(Long proposalId) {
        HashMap<String, Long> identifiers = new HashMap<String, Long>();
        identifiers.put("proposalId", proposalId);
        return (InstitutionalProposal)this.getBusinessObjectService().findByPrimaryKey(InstitutionalProposal.class, identifiers);
    }

    private InstitutionalProposal findProposalByProposalNumber(String proposalNumber) {
        return this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(proposalNumber);
    }

    protected void performDataFeeds(Award award, InstitutionalProposal proposal) {
        FundingProposalMergeType mergeType = this.getMergeType();
        new BaseFieldsDataFeedCommand(award, proposal, mergeType).performDataFeed();
        new SponsorDataFeedCommand(award, proposal, mergeType).performDataFeed();
        new CommentsDataFeedCommand(award, proposal, mergeType).performDataFeed();
        new SpecialReviewDataFeedCommand(award, proposal, mergeType).performDataFeed();
        proposal.refreshReferenceObject("institutionalProposalCostShares");
        new CostSharingDataFeedCommand(award, proposal, mergeType).performDataFeed();
        proposal.refreshReferenceObject("institutionalProposalUnrecoveredFandAs");
        new FandARatesDataFeedCommand(award, proposal, mergeType).performDataFeed();
        new KeywordsDataFeedCommand(award, proposal, mergeType).performDataFeed();
        new LeadUnitDataFeedCommand(award, proposal, mergeType).performDataFeed();
        this.initializeAwardCustomDataIfNecessary(award);
        new CustomDataDataFeedCommand(award, proposal, mergeType).performDataFeed();
        new ProjectPersonnelDataFeedCommand(award, proposal, mergeType).performDataFeed();
    }

    private boolean validateForAdd(List<Award> awards) {
        InstitutionalProposal pendingVersion;
        boolean valid;
        boolean bl = valid = this.newFundingProposal.getProposalId() != null;
        if (!valid) {
            String msgArg = this.newFundingProposal.getProposalNumber();
            if (msgArg == null) {
                msgArg = "(empty)";
            }
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, FUNDING_PROPOSAL_NOT_FOUND_ERROR_KEY, new String[]{msgArg});
        }
        if ((pendingVersion = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(this.newFundingProposal.getProposalNumber())) != null) {
            valid = false;
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, PENDING_FUNDING_PROPOSAL_VERSION_EXISTS, new String[]{this.newFundingProposal.getProposalNumber(), pendingVersion.getInstitutionalProposalDocument().getDocumentNumber(), pendingVersion.getUpdateUser()});
        }
        if (!this.userCanCreateProposal()) {
            valid = false;
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, FUNDING_PROPOSAL_INADEQUATE_PERMISSIONS, new String[]{GlobalVariables.getUserSession().getPrincipalName(), "Create Institutional Proposal"});
        }
        if (!this.userCanSubmitProposal()) {
            valid = false;
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, FUNDING_PROPOSAL_INADEQUATE_PERMISSIONS, new String[]{GlobalVariables.getUserSession().getPrincipalName(), "Submit Institutional Proposal"});
        }
        if (this.proposalAlreadyAdded(awards)) {
            valid = false;
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, FUNDING_PROPOSAL_ALREADY_ADDED, new String[0]);
        }
        if (!this.validProposalStatus()) {
            valid = false;
            String proposalStatus = this.newFundingProposal.getProposalStatus().getDescription();
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, FUNDING_PROPOSAL_INVALID_STATUS, new String[]{proposalStatus});
        }
        if (this.isInvalidAssociatedDevelopmentProposal()) {
            valid = false;
            GlobalVariables.getMessageMap().putError(FUNDING_PROPOSAL_ERROR_KEY, FUNDING_PROPOSAL_INVALID_DEVELOPMENTPROPOSAL_STATUS, new String[0]);
        }
        return valid;
    }

    private boolean isInvalidAssociatedDevelopmentProposal() {
        boolean isApprovePending = false;
        Collection<DevelopmentProposal> devProposals = this.getDevelopmentProposals(this.getNewFundingProposal());
        for (DevelopmentProposal developmentProposal : devProposals) {
            if (!"5".equals(developmentProposal.getProposalStateTypeCode())) continue;
            isApprovePending = true;
            break;
        }
        return isApprovePending;
    }

    protected Collection<DevelopmentProposal> getDevelopmentProposals(InstitutionalProposal instProposal) {
        ArrayList<DevelopmentProposal> devProposals = new ArrayList<DevelopmentProposal>();
        List proposalAdminDetails = this.getBusinessObjectService().findMatchingOrderBy(ProposalAdminDetails.class, this.getFieldValues("instProposalId", instProposal.getProposalId()), "devProposalNumber", true);
        if (proposalAdminDetails.size() > 0) {
            String latestDevelopmentProposalDocNumber = ((ProposalAdminDetails)proposalAdminDetails.get(proposalAdminDetails.size() - 1)).getDevProposalNumber();
            DevelopmentProposal devProp = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)latestDevelopmentProposalDocNumber);
            devProposals.add(devProp);
        }
        return devProposals;
    }

    protected Map<String, Object> getFieldValues(String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return fieldValues;
    }

    private boolean validProposalStatus() {
        int proposalStatusCode = this.newFundingProposal.getProposalStatus().getProposalStatusCode();
        Collection<String> validCodes = this.getInstitutionalProposalService().getValidFundingProposalStatusCodes();
        for (String validCode : validCodes) {
            int code = Integer.parseInt(validCode);
            if (proposalStatusCode != code) continue;
            return true;
        }
        return false;
    }

    private boolean proposalAlreadyAdded(List<Award> awardVersions) {
        Long proposalId = this.newFundingProposal.getProposalId();
        for (Award currentAward : awardVersions) {
            List<AwardFundingProposal> fundingProposals = currentAward.getFundingProposals();
            for (AwardFundingProposal currentFundingProposal : fundingProposals) {
                Long id = currentFundingProposal.getProposalId();
                if (!id.equals(proposalId)) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeAwardCustomDataIfNecessary(Award award) {
        if (award.getAwardCustomDataList().isEmpty() && this.awardForm != null) {
            Map<String, CustomAttributeDocument> customAttributeDocuments = this.awardForm.getCustomDataHelper().getCustomAttributeDocuments();
            for (Map.Entry<String, CustomAttributeDocument> entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = entry.getValue();
                AwardCustomData awardCustomData = new AwardCustomData();
                awardCustomData.setCustomAttributeId(customAttributeDocument.getId());
                awardCustomData.setCustomAttribute(customAttributeDocument.getCustomAttribute());
                CustomDataUtils.resetValueToEmpty(awardCustomData);
                awardCustomData.setAward(award);
                award.getAwardCustomDataList().add(awardCustomData);
            }
        }
    }

    private boolean userCanCreateProposal() {
        return this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-IP", "Create Institutional Proposal");
    }

    private boolean userCanSubmitProposal() {
        return this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-IP", "Submit Institutional Proposal");
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

