/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.module.CoeusModule;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.award.home.ContactUsage;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.GlobalVariables;

public class ContactUsageMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private Long oldTypeId = null;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        this.setOldTypeId(document);
        ContactUsage contactUsage = (ContactUsage)document.getDocumentBusinessObject();
        return this.validate(contactUsage, document.getNewMaintainableObject().getMaintenanceAction());
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        this.setOldTypeId(document);
        ContactUsage contactUsage = (ContactUsage)document.getDocumentBusinessObject();
        return this.validate(contactUsage, document.getNewMaintainableObject().getMaintenanceAction());
    }

    private boolean validate(ContactUsage contactUsage, String maintenanceAction) {
        boolean valid = this.validateContactType(contactUsage);
        return valid &= this.validateModule(contactUsage) && this.checkContactTypeModuleExists(contactUsage, maintenanceAction);
    }

    private boolean validateContactType(ContactUsage contactUsage) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)contactUsage.getContactTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("contactTypeCode", contactUsage.getContactTypeCode());
            List contactTypes = this.boService.findMatching(ContactType.class, fieldValues);
            if (contactTypes.isEmpty()) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.contactTypeCode", "error.contact.type.not.exists", new String[]{contactUsage.getContactTypeCode()});
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateModule(ContactUsage contactUsage) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)contactUsage.getModuleCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("moduleCode", contactUsage.getModuleCode());
            List reviewTypes = this.boService.findMatching(CoeusModule.class, fieldValues);
            if (reviewTypes.isEmpty()) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.moduleCode", "error.module.not.exists", new String[]{contactUsage.getModuleCode()});
                valid = false;
            }
        }
        return valid;
    }

    private boolean checkContactTypeModuleExists(ContactUsage contactUsage, String maintenanceAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)contactUsage.getContactTypeCode()) && StringUtils.isNotBlank((CharSequence)contactUsage.getModuleCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("contactTypeCode", contactUsage.getContactTypeCode());
            fieldValues.put("moduleCode", contactUsage.getModuleCode());
            List contactUsages = this.boService.findMatching(ContactUsage.class, fieldValues);
            if (!contactUsages.isEmpty()) {
                ContactUsage existValidContactTypeModule = (ContactUsage)contactUsages.get(0);
                if ((this.oldTypeId == null || !this.isMaintenanceActionEdit(maintenanceAction) & !this.isMaintenanceActionDelete(maintenanceAction) && existValidContactTypeModule.getContactUsageId().equals(this.oldTypeId)) && contactUsage.getContactTypeCode().equals(existValidContactTypeModule.getContactTypeCode()) && contactUsage.getModuleCode().equals(existValidContactTypeModule.getModuleCode())) {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.contactTypeCode", "error.contacttypemodule.exists", new String[]{contactUsage.getContactTypeCode(), contactUsage.getModuleCode()});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean isMaintenanceActionEdit(String maintenanceAction) {
        return StringUtils.isNotBlank((CharSequence)maintenanceAction) && maintenanceAction.equals("Edit");
    }

    private boolean isMaintenanceActionDelete(String maintenanceAction) {
        return StringUtils.isNotBlank((CharSequence)maintenanceAction) && maintenanceAction.equals("Delete");
    }

    private void setOldTypeId(MaintenanceDocument document) {
        this.oldTypeId = ((ContactUsage)document.getOldMaintainableObject().getDataObject()).getContactUsageId();
    }
}

