/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.customdata;

import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.custom.CustomDataHelperBase;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.customdata.NegotiationCustomData;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.web.struts.form.NegotiationForm;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class CustomDataHelper
extends CustomDataHelperBase<NegotiationCustomData> {
    private static final long serialVersionUID = -716264183914346452L;
    private final NegotiationForm negotiationForm;
    private ParameterService parameterService;

    public CustomDataHelper(NegotiationForm negotiationForm) {
        this.negotiationForm = negotiationForm;
    }

    private Negotiation getNegotiation() {
        NegotiationDocument document = this.negotiationForm.getNegotiationDocument();
        if (document == null || document.getNegotiation() == null) {
            throw new IllegalArgumentException("invalid (null) NegotiationDocument in NegotiationForm");
        }
        return document.getNegotiation();
    }

    @Override
    public boolean canModifyCustomData() {
        return false;
    }

    @Override
    protected NegotiationCustomData getNewCustomData() {
        return new NegotiationCustomData();
    }

    @Override
    public List<NegotiationCustomData> getCustomDataList() {
        return this.getNegotiation().getNegotiationCustomDataList();
    }

    @Override
    public Map<String, CustomAttributeDocument> getCustomAttributeDocuments() {
        return this.negotiationForm.getNegotiationDocument().getCustomAttributeDocuments();
    }

    @Override
    public boolean shouldUpdateCustomDataDocuments() {
        return this.getParameterService().getParameterValueAsBoolean("KC-NEGOTIATION", "Document", "ALWAYS_UPDATE_NEGOTIATIONS_CUSTOM_DATA", Boolean.valueOf(true));
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

