/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.AbstractServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.SoapServiceConfiguration;

public class SoapServiceDefinition
extends AbstractServiceDefinition {
    private static final long serialVersionUID = 5892163789061959602L;
    private String serviceInterface;
    private boolean jaxWsService = false;

    @Override
    public String getType() {
        return "SOAP";
    }

    public boolean isJaxWsService() {
        return this.jaxWsService;
    }

    public void setJaxWsService(boolean jaxWsService) {
        this.jaxWsService = jaxWsService;
    }

    public SoapServiceDefinition() {
        this.setBusSecurity(true);
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getServiceInterface() == null) {
            Class<?> cur = this.getService().getClass();
            while (cur.getInterfaces().length == 0 && (cur.getSuperclass() != Object.class || cur.getSuperclass() != null)) {
                cur = cur.getSuperclass();
            }
            if (cur.getInterfaces().length == 0) {
                throw new ConfigurationException(this.getService().getClass().getName() + " Service needs to implement interface to be exported as SOAP service");
            }
            this.setServiceInterface(cur.getInterfaces()[0].getName());
        } else {
            try {
                if (!Class.forName(this.getServiceInterface()).isInterface()) {
                    throw new ConfigurationException("Service interface class '" + this.getServiceInterface() + "' must be a Java interface");
                }
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Service interface class '" + this.getServiceInterface() + "' could not be found in the classpath", (Throwable)e);
            }
        }
    }

    @Override
    protected ServiceConfiguration configure() {
        return SoapServiceConfiguration.fromServiceDefinition(this);
    }
}

