/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.io.AbstractChunk;
import com.terracottatech.frs.io.BufferSource;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class BufferListWrapper
extends AbstractChunk
implements Closeable {
    private final ByteBuffer[] converted;
    private final BufferSource source;

    public BufferListWrapper(List<ByteBuffer> base) {
        this.converted = base.toArray(new ByteBuffer[base.size()]);
        this.source = null;
    }

    public BufferListWrapper(List<ByteBuffer> base, BufferSource source) {
        this.converted = base.toArray(new ByteBuffer[base.size()]);
        this.source = source;
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return this.converted;
    }

    @Override
    public void close() throws IOException {
        if (this.source != null) {
            for (ByteBuffer bb : this.converted) {
                this.source.returnBuffer(bb);
            }
        }
    }
}

