/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.kra.bo.AbstractPerson;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractProjectPersonDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    protected abstract List<? extends AbstractPerson> getPersons(Map<String, String> var1);

    protected Set<String> getAllProjectPersonRoleCodes() {
        return this.dataObjectService.findAll(PropAwardPersonRole.class).getResults().stream().map(PropAwardPersonRole::getCode).collect(Collectors.toSet());
    }

    protected List<? extends AbstractPerson> filterListByRole(List<? extends AbstractPerson> persons, String roleName) {
        ArrayList<AbstractPerson> newPersons = new ArrayList<AbstractPerson>();
        if (this.getAllProjectPersonRoleCodes().contains(roleName)) {
            for (AbstractPerson abstractPerson : persons) {
                if (abstractPerson instanceof AbstractPersonRoleAware) {
                    if (!StringUtils.equals((CharSequence)((AbstractPersonRoleAware)abstractPerson).getRoleCode(), (CharSequence)roleName)) continue;
                    newPersons.add(abstractPerson);
                    continue;
                }
                newPersons.add(abstractPerson);
            }
        }
        return newPersons;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        List<? extends AbstractPerson> persons = this.getPersons(qualification);
        String subQualification = qualification.get("subQualifier");
        if (persons != null && !persons.isEmpty()) {
            if (!StringUtils.equals((CharSequence)roleName, (CharSequence)"All Personnel") && !StringUtils.equals((CharSequence)roleName, (CharSequence)"Principle Investigator")) {
                persons = this.filterListByRole(persons, roleName);
            }
            if (StringUtils.isNotBlank((CharSequence)subQualification)) {
                persons = this.filterListByRole(persons, subQualification);
            }
            for (AbstractPerson abstractPerson : persons) {
                if (abstractPerson.getPerson() == null) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)abstractPerson.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        List<RoleMembership> members = this.getRoleMembersFromDerivedRole(namespaceCode, roleName, qualification);
        for (RoleMembership member : members) {
            if (!StringUtils.equals((CharSequence)member.getMemberId(), (CharSequence)principalId)) continue;
            return true;
        }
        return false;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }
}

