/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.registry.RemoveAndPublishResult;
import org.kuali.rice.ksb.api.registry.ServiceDescriptor;
import org.kuali.rice.ksb.api.registry.ServiceEndpoint;
import org.kuali.rice.ksb.api.registry.ServiceEndpointStatus;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.impl.cxf.interceptors.ImmutableCollectionsInInterceptor;
import org.kuali.rice.ksb.security.soap.CXFWSS4JInInterceptor;
import org.kuali.rice.ksb.security.soap.CXFWSS4JOutInterceptor;

public class LazyRemoteServiceRegistryConnector
implements ServiceRegistry {
    private static final String SERVICE_REGISTRY_SECURITY_CONFIG = "rice.ksb.serviceRegistry.security";
    private final Object initLock = new Object();
    private volatile ServiceRegistry delegate;
    private Bus cxfBus;

    public void setCxfBus(Bus cxfBus) {
        this.cxfBus = cxfBus;
    }

    public List<ServiceInfo> getOnlineServicesByName(QName serviceName) throws RiceIllegalArgumentException {
        return this.getDelegate().getOnlineServicesByName(serviceName);
    }

    public List<ServiceInfo> getAllOnlineServices() {
        return this.getDelegate().getAllOnlineServices();
    }

    public List<ServiceInfo> getAllServices() {
        return this.getDelegate().getAllServices();
    }

    public List<ServiceInfo> getAllServicesForInstance(String instanceId) {
        return this.getDelegate().getAllServicesForInstance(instanceId);
    }

    public List<ServiceInfo> getAllServicesForApplication(String applicationId) {
        return this.getDelegate().getAllServicesForApplication(applicationId);
    }

    public ServiceDescriptor getServiceDescriptor(String serviceDescriptorId) throws RiceIllegalArgumentException {
        return this.getDelegate().getServiceDescriptor(serviceDescriptorId);
    }

    public List<ServiceDescriptor> getServiceDescriptors(List<String> serviceDescriptorIds) throws RiceIllegalArgumentException {
        return this.getDelegate().getServiceDescriptors(serviceDescriptorIds);
    }

    public ServiceEndpoint publishService(ServiceEndpoint serviceEndpoint) throws RiceIllegalArgumentException {
        return this.getDelegate().publishService(serviceEndpoint);
    }

    public List<ServiceEndpoint> publishServices(List<ServiceEndpoint> serviceEndpoints) throws RiceIllegalArgumentException {
        return this.getDelegate().publishServices(serviceEndpoints);
    }

    public ServiceEndpoint removeServiceEndpoint(String serviceId) throws RiceIllegalArgumentException {
        return this.getDelegate().removeServiceEndpoint(serviceId);
    }

    public List<ServiceEndpoint> removeServiceEndpoints(List<String> serviceIds) throws RiceIllegalArgumentException {
        return this.getDelegate().removeServiceEndpoints(serviceIds);
    }

    public RemoveAndPublishResult removeAndPublish(List<String> removeServiceIds, List<ServiceEndpoint> publishServiceEndpoints) {
        return this.getDelegate().removeAndPublish(removeServiceIds, publishServiceEndpoints);
    }

    public boolean updateStatus(String serviceId, ServiceEndpointStatus status) throws RiceIllegalArgumentException {
        return this.getDelegate().updateStatus(serviceId, status);
    }

    public List<String> updateStatuses(List<String> serviceIds, ServiceEndpointStatus status) throws RiceIllegalArgumentException {
        return this.getDelegate().updateStatuses(serviceIds, status);
    }

    public void takeInstanceOffline(String instanceId) throws RiceIllegalArgumentException {
        if (this.delegate != null) {
            this.getDelegate().takeInstanceOffline(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistry getDelegate() {
        ServiceRegistry internalDelegate = this.delegate;
        if (internalDelegate == null) {
            Object object = this.initLock;
            synchronized (object) {
                internalDelegate = this.delegate;
                if (internalDelegate == null) {
                    this.delegate = internalDelegate = this.initializeRemoteServiceRegistry();
                }
            }
        }
        return internalDelegate;
    }

    protected ServiceRegistry initializeRemoteServiceRegistry() {
        String registryBootstrapUrl = ConfigContext.getCurrentContextConfig().getProperty("rice.ksb.registry.serviceUrl");
        if (StringUtils.isBlank((String)registryBootstrapUrl)) {
            throw new RiceRuntimeException("Failed to load registry bootstrap service from url: " + registryBootstrapUrl);
        }
        JaxWsProxyFactoryBean clientFactory = new JaxWsProxyFactoryBean();
        clientFactory.setServiceClass(ServiceRegistry.class);
        clientFactory.setBus(this.cxfBus);
        clientFactory.setAddress(registryBootstrapUrl);
        boolean registrySecurity = ConfigContext.getCurrentContextConfig().getBooleanProperty(SERVICE_REGISTRY_SECURITY_CONFIG, true);
        clientFactory.getOutInterceptors().add(new CXFWSS4JOutInterceptor(registrySecurity));
        clientFactory.getInInterceptors().add(new CXFWSS4JInInterceptor(registrySecurity));
        clientFactory.getInInterceptors().add(new ImmutableCollectionsInInterceptor());
        Object service = clientFactory.create();
        if (!(service instanceof ServiceRegistry)) {
            throw new RiceRuntimeException("Endpoint to service registry at URL '" + registryBootstrapUrl + "' was not an instance of ServiceRegistry, instead was: " + String.valueOf(service));
        }
        return (ServiceRegistry)service;
    }
}

