/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.config.module;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.config.property.ConfigContext;

public class WebModuleConfiguration {
    private final String moduleName;
    private List<String> webSpringFiles;
    private List<String> additionalWebSpringFiles;

    public WebModuleConfiguration(String moduleName) {
        this.moduleName = moduleName;
        this.webSpringFiles = new ArrayList<String>();
        this.additionalWebSpringFiles = new ArrayList<String>();
    }

    public String getWebModuleBaseUrl() {
        return ConfigContext.getCurrentContextConfig().getProperty(this.getModuleName().toLowerCase() + ".url");
    }

    public String getWebModuleStrutsConfigurationFiles() {
        return ConfigContext.getCurrentContextConfig().getProperty("rice." + this.getModuleName().toLowerCase() + ".struts.config.files");
    }

    public String getWebModuleStrutsConfigName() {
        return "config/" + this.getModuleName().toLowerCase();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List<String> getWebSpringFiles() {
        return this.webSpringFiles;
    }

    public void setWebSpringFiles(List<String> webSpringFiles) {
        this.webSpringFiles = webSpringFiles;
    }

    public List<String> getAdditionalWebSpringFiles() {
        return this.additionalWebSpringFiles;
    }

    public void setAdditionalWebSpringFiles(List<String> additionalWebSpringFiles) {
        this.additionalWebSpringFiles = additionalWebSpringFiles;
    }
}

