/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jta;

import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.persistence.jta.Jta;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;

public class JtaConfigurer
implements InitializingBean,
DisposableBean {
    private TransactionManager transactionManager;
    private UserTransaction userTransaction;
    private JndiTemplate jndiTemplate;

    public void afterPropertiesSet() throws Exception {
        this.configureTransactionManager();
        this.configureUserTransaction();
        Jta.configure(this.transactionManager, this.userTransaction);
    }

    protected void configureTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = this.loadFromConfiguration(TransactionManager.class, "transactionManager", "transactionManager.jndi.location");
        }
    }

    protected void configureUserTransaction() {
        if (this.userTransaction == null) {
            this.userTransaction = this.loadFromConfiguration(UserTransaction.class, "userTransaction", "userTransaction.jndi.location");
        }
    }

    protected <T> T loadFromConfiguration(Class<T> objectClass, String objectKey, String jndiKey) {
        String jndiName;
        if (!ConfigContext.isInitialized()) {
            throw new IllegalStateException("Configuration system has not been initialized, so cannot load JTA configuration. Please ensure the Configuration system is initalized first.");
        }
        Object configured = ConfigContext.getCurrentContextConfig().getObject(objectKey);
        if (configured == null && StringUtils.isNotEmpty((String)(jndiName = ConfigContext.getCurrentContextConfig().getProperty(jndiKey)))) {
            if (this.jndiTemplate == null) {
                this.jndiTemplate = new JndiTemplate();
            }
            try {
                configured = this.jndiTemplate.lookup(jndiName, objectClass);
            }
            catch (NamingException e) {
                throw new ConfigurationException("Could not locate the " + objectClass.getSimpleName() + " at the given JNDI location: '" + jndiName + "'", (Throwable)e);
            }
        }
        return (T)configured;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public void destroy() throws Exception {
        Jta.reset();
    }
}

