/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.nio.ChannelOpener;
import com.terracottatech.frs.io.nio.PositionLostException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class WrappedFileChannel
extends FileChannel {
    private final ChannelOpener channelOpener;
    private final Set<WrappedFileLock> grantedLocks;
    private final ReentrantLock posLock;
    private final AtomicInteger threadsInChannelMethod;
    private volatile FileChannel channel;
    private volatile boolean positionLost;
    private int threadsInFileLock;

    public WrappedFileChannel(FileChannel channel, ChannelOpener channelOpener) {
        this.channelOpener = channelOpener;
        this.channel = channel;
        this.grantedLocks = Collections.newSetFromMap(new ConcurrentHashMap());
        this.threadsInFileLock = 0;
        this.posLock = new ReentrantLock();
        this.positionLost = false;
        this.threadsInChannelMethod = new AtomicInteger(0);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.retryOnInterruptWithBufPosAndFilePos(FileChannel::read, dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.retryOnInterruptWithBufPosAndFilePos((FileChannel c, ByteBuffer[] b) -> c.read((ByteBuffer[])b, offset, length), dsts);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.retryOnInterruptWithBufPosAndFilePos(FileChannel::write, src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.retryOnInterruptWithBufPosAndFilePos((FileChannel c, ByteBuffer[] b) -> c.write((ByteBuffer[])b, offset, length), srcs);
    }

    @Override
    public long position() throws IOException {
        return this.retryOnInterruptIfPosNotLost(FileChannel::position);
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.retryOnInterruptLockPosAndPosGain(c -> c.position(newPosition));
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.retryOnInterrupt(FileChannel::size);
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.retryOnInterruptLockPos(c -> c.truncate(size));
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.retryOnInterrupt(FileChannel::force, metaData);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.retryOnChannelSwitch(c -> c.transferTo(position, count, target), null, null);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.retryOnChannelSwitch(c -> c.transferFrom(src, position, count), null, null);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.retryOnInterruptWithBufPos((c, b) -> c.read((ByteBuffer)b, position), dst);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.retryOnInterruptWithBufPos((c, b) -> c.write((ByteBuffer)b, position), src);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.retryOnInterrupt(c -> c.map(mode, position, size));
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        boolean interrupted = Thread.interrupted();
        boolean exited = false;
        while (true) {
            exited = false;
            this.enterLock();
            try {
                FileLock l = this.channel.lock(position, size, shared);
                if (l != null) {
                    WrappedFileLock wl = new WrappedFileLock(this, l);
                    this.grantedLocks.add(wl);
                    WrappedFileLock wrappedFileLock = wl;
                    return wrappedFileLock;
                }
                FileLock fileLock = null;
                return fileLock;
            }
            catch (ClosedChannelException | FileLockInterruptionException cce) {
                exited = true;
                this.exitLock();
                interrupted |= this.reopen(cce);
                continue;
            }
            break;
        }
        finally {
            if (!exited) {
                this.exitLock();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        try {
            this.enterLock();
            FileLock l = this.retryOnChannelSwitch(c -> c.tryLock(position, size, shared), this::exitLock, this::enterLock);
            if (l != null) {
                WrappedFileLock wl = new WrappedFileLock(this, l);
                this.grantedLocks.add(wl);
                WrappedFileLock wrappedFileLock = wl;
                return wrappedFileLock;
            }
            FileLock fileLock = null;
            return fileLock;
        }
        finally {
            this.exitLock();
        }
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.channel.close();
    }

    private <R> R retryOnInterruptWithBufPosAndFilePos(ChannelBiFunction<R, ByteBuffer> actionToTake, ByteBuffer buf) throws IOException {
        return this.retryOnInterruptWithPos(true, actionToTake, buf, new ByteBuffer[]{buf});
    }

    private <R> R retryOnInterruptWithBufPosAndFilePos(ChannelBiFunction<R, ByteBuffer[]> actionToTake, ByteBuffer[] bufs) throws IOException {
        return this.retryOnInterruptWithPos(true, actionToTake, bufs, bufs);
    }

    private <R> R retryOnInterruptWithBufPos(ChannelBiFunction<R, ByteBuffer> actionToTake, ByteBuffer buf) throws IOException {
        return this.retryOnInterruptWithPos(false, actionToTake, buf, new ByteBuffer[]{buf});
    }

    private <R, U> R retryOnInterruptWithPos(boolean savePosition, ChannelBiFunction<R, U> actionToTake, U u, ByteBuffer[] bufs) throws IOException {
        if (this.channelOpener.isClosed()) {
            throw new ClosedChannelException();
        }
        boolean interrupted = Thread.interrupted();
        int[] bufPositions = new int[bufs.length];
        long pos = -1L;
        int i = 0;
        for (ByteBuffer buf : bufs) {
            bufPositions[i++] = buf.position();
        }
        this.threadsInChannelMethod.incrementAndGet();
        ReentrantLock lock = this.posLock;
        if (savePosition) {
            lock.lock();
        }
        block7: while (true) {
            R r;
            FileChannel currentChannel = this.channel;
            if (this.positionLost && savePosition) {
                throw new PositionLostException();
            }
            try {
                if (savePosition && pos < 0L) {
                    pos = currentChannel.position();
                }
                r = actionToTake.apply(currentChannel, u);
            }
            catch (ClosedChannelException cce) {
                interrupted |= this.reopen(cce, pos);
                i = 0;
                ByteBuffer[] byteBufferArray = bufs;
                int n = byteBufferArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block7;
                    ByteBuffer b = byteBufferArray[n2];
                    b.position(bufPositions[i++]);
                    ++n2;
                }
            }
            return r;
            break;
        }
        finally {
            if (savePosition) {
                lock.unlock();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.threadsInChannelMethod.decrementAndGet();
        }
    }

    private <R> void retryOnInterrupt(ChannelBiConsumer<R> actionToTake, R r) throws IOException {
        this.retryOnInterrupt(c -> {
            actionToTake.accept(this.channel, r);
            return null;
        });
    }

    private <R> R retryOnInterrupt(ChannelFunction<R> actionToTake) throws IOException {
        return this.retryOnInterrupt(actionToTake, false, false, false);
    }

    private <R> R retryOnInterruptIfPosNotLost(ChannelFunction<R> actionToTake) throws IOException {
        return this.retryOnInterrupt(actionToTake, false, false, true);
    }

    private <R> R retryOnInterruptLockPos(ChannelFunction<R> actionToTake) throws IOException {
        return this.retryOnInterrupt(actionToTake, true, false, false);
    }

    private <R> R retryOnInterruptLockPosAndPosGain(ChannelFunction<R> actionToTake) throws IOException {
        return this.retryOnInterrupt(actionToTake, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R retryOnInterrupt(ChannelFunction<R> actionToTake, boolean lockPosition, boolean posGained, boolean posImportant) throws IOException {
        this.threadsInChannelMethod.incrementAndGet();
        boolean success = false;
        ReentrantLock lock = this.posLock;
        FileChannel appliedChannel = this.channel;
        if (lockPosition) {
            lock.lock();
        }
        boolean interrupted = Thread.interrupted();
        while (true) {
            R r;
            if (posImportant && this.positionLost) {
                throw new PositionLostException();
            }
            try {
                appliedChannel = this.channel;
                R r2 = actionToTake.apply(appliedChannel);
                success = true;
                r = r2;
            }
            catch (ClosedChannelException | FileLockInterruptionException cce) {
                interrupted |= this.reopen(cce);
                continue;
            }
            return r;
        }
        finally {
            this.threadsInChannelMethod.decrementAndGet();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (lockPosition) {
                lock.unlock();
            }
            if (success && posGained && this.channel == appliedChannel && this.positionLost) {
                WrappedFileChannel wrappedFileChannel = this;
                synchronized (wrappedFileChannel) {
                    if (this.channel == appliedChannel) {
                        this.positionLost = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R retryOnChannelSwitch(ChannelFunction<R> actionToTake, Runnable before, Runnable after) throws IOException {
        FileChannel usedChannel = this.channel;
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                R r = actionToTake.apply(usedChannel);
                return r;
            }
            catch (ClosedChannelException cce) {
                if (this.channelOpener.isClosed()) {
                    throw cce;
                }
                interrupted |= Thread.interrupted();
                if (before != null) {
                    before.run();
                }
                try {
                    boolean channelSwitched = false;
                    while (!channelSwitched && this.threadsInChannelMethod.get() > 0) {
                        WrappedFileChannel wrappedFileChannel = this;
                        synchronized (wrappedFileChannel) {
                            if (usedChannel != this.channel) {
                                usedChannel = this.channel;
                                channelSwitched = true;
                            }
                        }
                        Thread.yield();
                        Thread.yield();
                    }
                    if (channelSwitched) continue;
                    throw cce;
                }
                finally {
                    if (after == null) continue;
                    after.run();
                    continue;
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private synchronized void releaseLock(WrappedFileLock releasedLock) throws IOException {
        releasedLock.actual.release();
        this.grantedLocks.remove(releasedLock);
    }

    private synchronized void enterLock() {
        ++this.threadsInFileLock;
    }

    private synchronized void exitLock() {
        --this.threadsInFileLock;
        if (this.threadsInFileLock == 0) {
            this.notifyAll();
        }
    }

    private boolean reopen(IOException ioe) throws IOException {
        return this.reopen(ioe, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reopen(IOException ioe, long pos) throws IOException {
        if (this.channelOpener.isClosed()) {
            throw ioe;
        }
        boolean interrupted = Thread.interrupted();
        FileChannel previous = this.channel;
        WrappedFileChannel wrappedFileChannel = this;
        synchronized (wrappedFileChannel) {
            if (previous == this.channel) {
                FileChannel tmpChannel;
                do {
                    try {
                        tmpChannel = this.channelOpener.reopen();
                        if (pos >= 0L) {
                            tmpChannel.position(pos);
                        }
                        interrupted |= this.reAcquireGrantedLocks(tmpChannel);
                    }
                    catch (ClosedChannelException cce) {
                        if (this.channelOpener.isClosed()) {
                            throw cce;
                        }
                        tmpChannel = null;
                        interrupted |= Thread.interrupted();
                    }
                } while (tmpChannel == null);
                this.positionLost = pos < 0L;
                this.channel = tmpChannel;
            }
        }
        return interrupted;
    }

    private boolean reAcquireGrantedLocks(FileChannel tmpChannel) throws IOException {
        boolean interrupted = Thread.interrupted();
        while (this.threadsInFileLock > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted |= Thread.interrupted();
            }
        }
        interrupted |= Thread.interrupted();
        if (this.grantedLocks.isEmpty()) {
            return interrupted;
        }
        for (WrappedFileLock wl : this.grantedLocks) {
            try {
                wl.actual.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileLock l = tmpChannel.tryLock(wl.position(), wl.size(), wl.isShared());
            if (l == null) {
                throw new IOException("Unable to relock on the new channel");
            }
            wl.updateLock(l);
        }
        return interrupted | Thread.interrupted();
    }

    private static final class WrappedFileLock
    extends FileLock {
        private volatile FileLock actual;
        private final WrappedFileChannel lockedChannel;

        WrappedFileLock(WrappedFileChannel lockedChannel, FileLock actual) {
            super(lockedChannel, actual.position(), actual.size(), actual.isShared());
            this.actual = actual;
            this.lockedChannel = lockedChannel;
        }

        @Override
        public boolean isValid() {
            return this.actual.isValid();
        }

        @Override
        public void release() throws IOException {
            boolean interrupted = Thread.interrupted();
            while (true) {
                try {
                    this.lockedChannel.releaseLock(this);
                    return;
                }
                catch (ClosedChannelException e) {
                    interrupted |= this.lockedChannel.reopen(e);
                    continue;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void updateLock(FileLock newLock) {
            this.actual = newLock;
        }
    }

    @FunctionalInterface
    private static interface ChannelBiFunction<R, U> {
        public R apply(FileChannel var1, U var2) throws IOException;
    }

    @FunctionalInterface
    private static interface ChannelBiConsumer<R> {
        public void accept(FileChannel var1, R var2) throws IOException;
    }

    @FunctionalInterface
    private static interface ChannelFunction<R> {
        public R apply(FileChannel var1) throws IOException;
    }
}

