/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.award.api.AwardApiService;
import org.kuali.coeus.award.dto.AwardCfdaDto;
import org.kuali.coeus.award.dto.AwardCloseoutDto;
import org.kuali.coeus.award.dto.AwardCommentDto;
import org.kuali.coeus.award.dto.AwardCostShareDto;
import org.kuali.coeus.award.dto.AwardCustomDataDto;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.award.dto.AwardFandARateDto;
import org.kuali.coeus.award.dto.AwardPersonCreditSplitDto;
import org.kuali.coeus.award.dto.AwardPersonDto;
import org.kuali.coeus.award.dto.AwardPersonUnitCreditSplitDto;
import org.kuali.coeus.award.dto.AwardPersonUnitDto;
import org.kuali.coeus.award.dto.AwardReportTermDto;
import org.kuali.coeus.award.dto.AwardSponsorTermDto;
import org.kuali.coeus.award.finance.AwardCentralAdminContactDto;
import org.kuali.coeus.award.finance.AwardUnitContactDto;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTerm;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardCentralAdminContact;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.contacts.AwardProjectPersonnelBean;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AwardControllerBase
extends RestController {
    @Autowired
    @Qualifier(value="commonApiService")
    protected CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="awardApiService")
    private AwardApiService awardApiService;
    @Autowired
    @Qualifier(value="businessObjectService")
    protected BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    protected GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    protected void translateCollections(AwardDto awardDto, AwardDocument awardDocument) {
        Award award = awardDocument.getAward();
        award.setProjectPersons(new ArrayList<AwardPerson>());
        List<AwardPersonDto> projectPersons = awardDto.getProjectPersons();
        this.addPersons(projectPersons, awardDocument);
        this.addSponsorTerms(award, awardDto);
        this.addReportTerms(award, awardDto);
        this.addCustomData(awardDocument, award, awardDto);
        this.addCostShare(award, awardDto);
        this.addComments(award, awardDto);
        this.addAwardFandaRate(award, awardDto);
        this.translateSponsorContacts(awardDto, award);
        this.translateAwardCfdas(awardDto, award);
        this.translateCentralAdminContacts(awardDto, award);
        this.translateAwardCloseoutItems(awardDto, award);
        this.translateAwardUnitContactItems(awardDto, award);
        if (!this.globalVariableService.getMessageMap().getErrorMessages().isEmpty()) {
            String errors = this.commonApiService.getValidationErrors();
            throw new UnprocessableEntityException(errors);
        }
    }

    protected void addPersons(List<AwardPersonDto> awardPersonsDto, AwardDocument awardDocument) {
        Award award = awardDocument.getAward();
        if (awardPersonsDto != null) {
            List<AwardPerson> awardPersons = awardPersonsDto.stream().map(awardPersonDto -> {
                AwardPerson awardPerson = this.commonApiService.convertObject(awardPersonDto, AwardPerson.class);
                this.setAwardPersonDefaults(awardPerson);
                this.validatePerson(awardPerson);
                awardPerson.setUnits(this.translatePersonUnits(awardPersonDto.getUnits(), awardPerson));
                awardPerson.setCreditSplits(this.translatePersonCreditSplits(awardPersonDto.getCreditSplits(), awardPerson));
                AwardProjectPersonnelBean awardProjectPersonnelBean = new AwardProjectPersonnelBean(awardDocument);
                awardProjectPersonnelBean.addPersonUnits(awardPerson);
                awardPerson.setAward(award);
                return awardPerson;
            }).collect(Collectors.toList());
            award.setProjectPersons(awardPersons);
            awardDocument.setAward(award);
        }
    }

    private void setAwardPersonDefaults(AwardPerson awardPerson) {
        if (awardPerson.getCreditSplits() == null) {
            awardPerson.setCreditSplits(new ArrayList<AwardPersonCreditSplit>());
        }
        if (awardPerson.getUnits() == null) {
            awardPerson.setUnits(new ArrayList<AwardPersonUnit>());
        }
    }

    private List<AwardPersonUnit> translatePersonUnits(List<AwardPersonUnitDto> unitDtos, AwardPerson awardPerson) {
        if (unitDtos != null) {
            return unitDtos.stream().map(awardPersonUnitDto -> {
                AwardPersonUnit awardPersonUnit = this.commonApiService.convertObject(awardPersonUnitDto, AwardPersonUnit.class);
                if (awardPersonUnit.getUnit() != null) {
                    awardPersonUnit.setUnitNumber(awardPersonUnit.getUnit().getUnitNumber());
                }
                awardPersonUnit.setAwardPerson(awardPerson);
                awardPersonUnit.setCreditSplits(this.translatePersonUnitCreditSplits(awardPersonUnitDto.getCreditSplits(), awardPersonUnit));
                return awardPersonUnit;
            }).collect(Collectors.toList());
        }
        return new ArrayList<AwardPersonUnit>();
    }

    private List<AwardPersonUnitCreditSplit> translatePersonUnitCreditSplits(List<AwardPersonUnitCreditSplitDto> creditSplitDtos, AwardPersonUnit awardPersonUnit) {
        if (creditSplitDtos != null) {
            return creditSplitDtos.stream().map(awardPersonUnitCreditSplitDto -> {
                AwardPersonUnitCreditSplit awardPersonUnitCreditSplit = this.commonApiService.convertObject(awardPersonUnitCreditSplitDto, AwardPersonUnitCreditSplit.class);
                awardPersonUnitCreditSplit.setInvestigatorCreditType(awardPersonUnitCreditSplit.getInvestigatorCreditType());
                awardPersonUnitCreditSplit.setAwardPersonUnit(awardPersonUnit);
                return awardPersonUnitCreditSplit;
            }).collect(Collectors.toList());
        }
        return new ArrayList<AwardPersonUnitCreditSplit>();
    }

    private List<AwardPersonCreditSplit> translatePersonCreditSplits(List<AwardPersonCreditSplitDto> creditSplitDtos, AwardPerson awardPerson) {
        if (creditSplitDtos != null) {
            return creditSplitDtos.stream().map(awardPersonCreditSplitDto -> {
                AwardPersonCreditSplit awardPersonCreditSplit = this.commonApiService.convertObject(awardPersonCreditSplitDto, AwardPersonCreditSplit.class);
                awardPersonCreditSplit.setInvestigatorCreditType(awardPersonCreditSplit.getInvestigatorCreditType());
                awardPersonCreditSplit.setAwardPerson(awardPerson);
                return awardPersonCreditSplit;
            }).collect(Collectors.toList());
        }
        return new ArrayList<AwardPersonCreditSplit>();
    }

    public void validatePerson(AwardPerson person) {
        Entity personEntity = null;
        RolodexContract rolodex = null;
        if (person.getPersonId() != null) {
            personEntity = this.identityService.getEntityByPrincipalId(person.getPersonId());
        } else {
            rolodex = this.rolodexService.getRolodex(person.getRolodexId());
            if (rolodex != null) {
                person.setRolodexId(rolodex.getRolodexId());
                person.setPersonId(null);
            }
        }
        if (rolodex == null && personEntity == null) {
            throw new UnprocessableEntityException("Invalid person or rolodex for person " + this.getId(person));
        }
    }

    public void addCustomData(AwardDocument awardDocument, Award award, AwardDto awardDto) {
        List<AwardCustomDataDto> awardCustomDataList = awardDto.getAwardCustomDataList();
        award.setAwardCustomDataList(new ArrayList<AwardCustomData>());
        if (awardDto.getAwardCustomDataList() != null) {
            awardCustomDataList.forEach(customDataDto -> {
                String customAttributeId = customDataDto.getCustomAttributeId().toString();
                String customDataValue = customDataDto.getValue();
                Map<String, CustomAttributeDocument> customAttributeDocuments = awardDocument.getCustomAttributeDocuments();
                List customDataList = customAttributeDocuments.entrySet().stream().filter(entry -> {
                    CustomAttributeDocument customAttributeDoc = (CustomAttributeDocument)entry.getValue();
                    return customAttributeId.equalsIgnoreCase(customAttributeDoc.getCustomAttribute().getId().toString());
                }).map(entry -> {
                    CustomAttributeDocument customAttributeDoc = (CustomAttributeDocument)entry.getValue();
                    AwardCustomData customData = new AwardCustomData();
                    customData.setCustomAttributeId(customAttributeDoc.getId());
                    customData.setCustomAttribute(customAttributeDoc.getCustomAttribute());
                    customData.setValue(customDataValue);
                    customData.setAward(award);
                    return customData;
                }).collect(Collectors.toList());
                award.getAwardCustomDataList().addAll(customDataList);
            });
        }
    }

    protected void addSponsorTerms(Award award, AwardDto awardDto) {
        List<AwardSponsorTermDto> sponsorTermsDtos = awardDto.getAwardSponsorTerms();
        award.setAwardSponsorTerms(new ArrayList<AwardSponsorTerm>());
        if (sponsorTermsDtos != null) {
            List sponsorTerms = sponsorTermsDtos.stream().map(awardSponsorTermDto -> this.getAwardSponsorTerm(awardSponsorTermDto.getSponsorTermId(), award)).collect(Collectors.toList());
            award.getAwardSponsorTerms().addAll(sponsorTerms);
        }
    }

    protected AwardSponsorTerm getAwardSponsorTerm(Long sponsorTermId, Award award) {
        SponsorTerm sponsorTerm = this.getSponsorTerm(sponsorTermId);
        if (sponsorTerm == null) {
            throw new UnprocessableEntityException("Sponsor term " + sponsorTermId + " cannot be found.");
        }
        AwardSponsorTerm newAwardSponsorTerm = new AwardSponsorTerm(sponsorTermId, sponsorTerm);
        newAwardSponsorTerm.setAward(award);
        return newAwardSponsorTerm;
    }

    protected void addReportTerms(Award award, AwardDto awardDto) {
        List<AwardReportTermDto> awardReportTermDtos = awardDto.getAwardReportTerms();
        award.setAwardReportTermItems(new ArrayList<AwardReportTerm>());
        if (awardReportTermDtos != null) {
            List awardReportTerms = awardReportTermDtos.stream().map(awardReportTermDto -> {
                AwardReportTerm awardReportTerm = this.commonApiService.convertObject(awardReportTermDto, AwardReportTerm.class);
                awardReportTerm.setAward(award);
                return awardReportTerm;
            }).collect(Collectors.toList());
            award.getAwardReportTermItems().addAll(awardReportTerms);
        }
    }

    protected void addCostShare(Award award, AwardDto awardDto) {
        List<AwardCostShareDto> awardCostShareDtos = awardDto.getAwardCostShares();
        award.setAwardCostShares(new ArrayList<AwardCostShare>());
        if (awardCostShareDtos != null) {
            List awardCostShares = awardCostShareDtos.stream().map(awardCostShareDto -> {
                AwardCostShare awardCostShare = this.commonApiService.convertObject(awardCostShareDto, AwardCostShare.class);
                awardCostShare.setAward(award);
                return awardCostShare;
            }).collect(Collectors.toList());
            award.getAwardCostShares().addAll(awardCostShares);
        }
    }

    protected void addComments(Award award, AwardDto awardDto) {
        List<AwardCommentDto> awardCommentDtos = awardDto.getAwardComments();
        award.setAwardComments(new ArrayList<AwardComment>());
        if (awardCommentDtos != null) {
            List awardComments = awardCommentDtos.stream().map(awardCommentDto -> {
                AwardComment awardComment = this.commonApiService.convertObject(awardCommentDto, AwardComment.class);
                awardComment.setAward(award);
                return awardComment;
            }).collect(Collectors.toList());
            award.getAwardComments().addAll(awardComments);
        }
    }

    protected void addAwardFandaRate(Award award, AwardDto awardDto) {
        List<AwardFandARateDto> awardFandARateDtos = awardDto.getAwardFandaRate();
        award.setAwardFandaRate(new ArrayList<AwardFandaRate>());
        if (awardFandARateDtos != null) {
            List awardFandaRates = awardFandARateDtos.stream().map(awardFandARateDto -> {
                AwardFandaRate awardFandaRate = this.commonApiService.convertObject(awardFandARateDto, AwardFandaRate.class);
                awardFandaRate.setAward(award);
                return awardFandaRate;
            }).collect(Collectors.toList());
            award.getAwardFandaRate().addAll(awardFandaRates);
        }
    }

    protected SponsorTerm getSponsorTerm(Long sponsorTermId) {
        return (SponsorTerm)this.businessObjectService.findBySinglePrimaryKey(SponsorTerm.class, (Object)sponsorTermId.toString());
    }

    public void translateSponsorContacts(AwardDto awardDto, Award award) {
        if (CollectionUtils.isNotEmpty(awardDto.getAwardSponsorContacts())) {
            award.setSponsorContacts(awardDto.getAwardSponsorContacts().stream().map(awardSponsorContactDto -> {
                AwardSponsorContact awardSponsorContact = this.commonApiService.convertObject(awardSponsorContactDto, AwardSponsorContact.class);
                awardSponsorContact.setAwardNumber(award.getAwardNumber());
                awardSponsorContact.setSequenceNumber(award.getSequenceNumber());
                return awardSponsorContact;
            }).collect(Collectors.toList()));
        }
    }

    public void translateAwardCfdas(AwardDto awardDto, Award award) {
        List<AwardCfdaDto> dtos = awardDto.getAwardCfdas();
        if (CollectionUtils.isNotEmpty(dtos)) {
            award.setAwardCfdas(dtos.stream().map(awardCfdaDto -> this.commonApiService.convertObject(awardCfdaDto, AwardCfda.class)).collect(Collectors.toList()));
        }
    }

    public void translateCentralAdminContacts(AwardDto awardDto, Award award) {
        List<AwardCentralAdminContactDto> dtos = awardDto.getAwardCentralAdminContacts();
        if (CollectionUtils.isNotEmpty(dtos)) {
            award.setAwardCentralAdminContacts(dtos.stream().map(contactDto -> {
                AwardCentralAdminContact contact = this.commonApiService.convertObject(contactDto, AwardCentralAdminContact.class);
                contact.setPerson(this.commonApiService.convertObject(contactDto.getPerson(), KcPerson.class));
                return contact;
            }).collect(Collectors.toList()));
        }
    }

    public void translateAwardCloseoutItems(AwardDto awardDto, Award award) {
        List<AwardCloseoutDto> dtos = awardDto.getAwardCloseoutItems();
        if (CollectionUtils.isNotEmpty(dtos)) {
            award.setAwardCloseoutItems(dtos.stream().map(dto -> this.commonApiService.convertObject(dto, AwardCloseout.class)).collect(Collectors.toList()));
        }
    }

    private void translateAwardUnitContactItems(AwardDto awardDto, Award award) {
        List<AwardUnitContactDto> dtos = awardDto.getAwardUnitContacts();
        if (CollectionUtils.isNotEmpty(dtos)) {
            award.setAwardUnitContacts(dtos.stream().map(dto -> {
                AwardUnitContact contact = this.commonApiService.convertObject(dto, AwardUnitContact.class);
                contact.setPerson(this.commonApiService.convertObject(dto.getPerson(), KcPerson.class));
                return contact;
            }).collect(Collectors.toList()));
        }
    }

    protected String getId(AwardPerson person) {
        return person.getPersonId() != null ? person.getPersonId() : person.getRolodexId().toString();
    }

    protected void changeDates(Award award, AwardDto awardDto) {
        award.getAwardAmountInfo().setCurrentFundEffectiveDate(awardDto.getObligationStartDate());
        award.getAwardAmountInfo().setObligationExpirationDate(awardDto.getObligationEndDate());
        award.getAwardAmountInfo().setFinalExpirationDate(awardDto.getProjectEndDate());
        award.setAwardEffectiveDate(awardDto.getAwardEffectiveDate());
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasBudgetReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", AwardBudgetExt.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasAwardPersonReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", AwardPerson.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasAwardPersonWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", AwardPerson.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", Award.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", Award.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public AwardApiService getAwardApiService() {
        return this.awardApiService;
    }

    public void setAwardApiService(AwardApiService awardApiService) {
        this.awardApiService = awardApiService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

