/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.type;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krms.api.engine.EngineResourceUnavailableException;
import org.kuali.rice.krms.api.repository.RepositoryDataException;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.framework.type.AgendaTypeService;
import org.kuali.rice.krms.framework.type.FunctionTypeService;
import org.kuali.rice.krms.framework.type.PropositionTypeService;
import org.kuali.rice.krms.framework.type.RuleTypeService;
import org.kuali.rice.krms.framework.type.TermResolverTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeResolver;
import org.kuali.rice.krms.impl.type.RuleTypeServiceBase;

public class KrmsTypeResolverImpl
implements KrmsTypeResolver {
    private KrmsTypeRepositoryService typeRepositoryService;
    private PropositionTypeService defaultCompoundPropositionTypeService;
    private PropositionTypeService defaultSimplePropositionTypeService;

    @Override
    public PropositionTypeService getPropositionTypeService(PropositionDefinition propositionDefinition) {
        if (propositionDefinition == null) {
            throw new IllegalArgumentException("propositionDefinition was null");
        }
        if (propositionDefinition.getTypeId() == null) {
            PropositionType propositionType = PropositionType.fromCode((String)propositionDefinition.getPropositionTypeCode());
            if (PropositionType.COMPOUND == propositionType) {
                return this.defaultCompoundPropositionTypeService;
            }
            if (PropositionType.SIMPLE == propositionType) {
                return this.defaultSimplePropositionTypeService;
            }
            throw new RepositoryDataException("Proposition does not have a typeId defined and does not define a valid proposition type code.  Proposition id is: " + propositionDefinition.getId());
        }
        KrmsTypeDefinition typeDefinition = this.getTypeDefinition(propositionDefinition.getTypeId());
        return this.resolveTypeService(typeDefinition, PropositionTypeService.class);
    }

    @Override
    public ActionTypeService getActionTypeService(ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            throw new IllegalArgumentException("actionDefinition was null");
        }
        KrmsTypeDefinition typeDefinition = this.getTypeDefinition(actionDefinition.getTypeId());
        return this.resolveTypeService(typeDefinition, ActionTypeService.class);
    }

    @Override
    public AgendaTypeService getAgendaTypeService(AgendaDefinition agendaDefinition) {
        if (agendaDefinition == null) {
            throw new IllegalArgumentException("agendaDefinition was null");
        }
        KrmsTypeDefinition typeDefinition = this.getTypeDefinition(agendaDefinition.getTypeId());
        return this.resolveTypeService(typeDefinition, AgendaTypeService.class);
    }

    @Override
    public RuleTypeService getRuleTypeService(RuleDefinition ruleDefinition) {
        if (ruleDefinition == null) {
            throw new IllegalArgumentException("ruleDefinition was null");
        }
        KrmsTypeDefinition typeDefinition = this.getTypeDefinition(ruleDefinition.getTypeId());
        if (typeDefinition == null) {
            return RuleTypeServiceBase.defaultRuleTypeService;
        }
        return this.resolveTypeService(typeDefinition, RuleTypeService.class);
    }

    @Override
    public TermResolverTypeService getTermResolverTypeService(TermResolverDefinition termResolverDefinition) {
        if (termResolverDefinition == null) {
            throw new IllegalArgumentException("termResolverDefinition was null");
        }
        KrmsTypeDefinition typeDefinition = this.getTypeDefinition(termResolverDefinition.getTypeId());
        return this.resolveTypeService(typeDefinition, TermResolverTypeService.class);
    }

    @Override
    public FunctionTypeService getFunctionTypeService(FunctionDefinition functionDefinition) {
        if (functionDefinition == null) {
            throw new IllegalArgumentException("functionDefinition was null");
        }
        KrmsTypeDefinition typeDefinition = this.getTypeDefinition(functionDefinition.getTypeId());
        return this.resolveTypeService(typeDefinition, FunctionTypeService.class);
    }

    protected KrmsTypeDefinition getTypeDefinition(String typeId) {
        if (StringUtils.isBlank((String)typeId)) {
            return null;
        }
        KrmsTypeDefinition typeDefinition = this.typeRepositoryService.getTypeById(typeId);
        if (typeDefinition == null) {
            throw new RepositoryDataException("Failed to locate a type definition for typeId: " + typeId);
        }
        return typeDefinition;
    }

    protected <T> T resolveTypeService(KrmsTypeDefinition typeDefinition, Class<T> typeServiceClass) {
        QName serviceName = QName.valueOf(typeDefinition.getServiceName());
        Object service = GlobalResourceLoader.getService((QName)serviceName);
        if (service == null) {
            throw new EngineResourceUnavailableException("Failed to locate the " + typeServiceClass.getSimpleName() + " with name: " + String.valueOf(serviceName));
        }
        if (!typeServiceClass.isAssignableFrom(service.getClass())) {
            throw new EngineResourceUnavailableException("The service with name '" + String.valueOf(serviceName) + "' defined on typeId '" + typeDefinition.getId() + "' was not of type " + typeServiceClass.getSimpleName() + ": " + String.valueOf(service));
        }
        return typeServiceClass.cast(service);
    }

    public void setTypeRepositoryService(KrmsTypeRepositoryService typeRepositoryService) {
        this.typeRepositoryService = typeRepositoryService;
    }

    public void setDefaultCompoundPropositionTypeService(PropositionTypeService defaultCompoundPropositionTypeService) {
        this.defaultCompoundPropositionTypeService = defaultCompoundPropositionTypeService;
    }

    public void setDefaultSimplePropositionTypeService(PropositionTypeService defaultSimplePropositionTypeService) {
        this.defaultSimplePropositionTypeService = defaultSimplePropositionTypeService;
    }
}

