/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.xmlrouting;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.attribute.XMLAttributeUtils;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.WorkflowAttributeXmlValidator;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.WorkflowFunctionResolver;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandardGenericXMLRuleAttribute
implements GenericXMLRuleAttribute,
WorkflowAttributeXmlValidator {
    private static final Logger LOG = LogManager.getLogger(StandardGenericXMLRuleAttribute.class);
    private static final String FIELD_DEF_E = "fieldDef";
    private boolean evaluateForMissingExtensions = false;
    private ExtensionDefinition extensionDefinition;
    private Map paramMap = new HashMap();
    private List ruleRows = new ArrayList();
    private List routingDataRows = new ArrayList();
    private boolean required;

    private NodeList getFields(XPath xpath, Element root, String[] types) throws XPathExpressionException {
        String OR = " or ";
        StringBuffer findField = new StringBuffer("//routingConfig/fieldDef");
        if (types != null && types.length > 0) {
            findField.append("[");
            for (String type : types) {
                findField.append("@workflowType='" + type + "' or ");
                if (!"ALL".equals(type)) continue;
                findField.append("not(@workflowType) or ");
            }
            if (types.length > 0) {
                findField.setLength(findField.length() - " or ".length());
            }
            findField.append("]");
        }
        try {
            return (NodeList)xpath.evaluate(findField.toString(), root, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            LOG.error("Error evaluating expression: '" + String.valueOf(findField) + "'");
            throw e;
        }
    }

    private List<Row> getRows(Element root, String[] types) {
        NodeList fieldNodeList;
        ArrayList<Row> rows = new ArrayList<Row>();
        XPath xpath = XPathHelper.newXPath();
        try {
            fieldNodeList = this.getFields(xpath, root, types);
        }
        catch (XPathExpressionException e) {
            LOG.error("Error evaluating fields expression", (Throwable)e);
            return rows;
        }
        if (fieldNodeList != null) {
            for (int i = 0; i < fieldNodeList.getLength(); ++i) {
                Node field = fieldNodeList.item(i);
                NamedNodeMap fieldAttributes = field.getAttributes();
                ArrayList<Field> fields = new ArrayList<Field>();
                Field myField = new Field(fieldAttributes.getNamedItem("title").getNodeValue(), "", "", false, fieldAttributes.getNamedItem("name").getNodeValue(), "", false, false, null, "");
                Object quickfinderService = null;
                for (int j = 0; j < field.getChildNodes().getLength(); ++j) {
                    Node childNode = field.getChildNodes().item(j);
                    if ("value".equals(childNode.getNodeName())) {
                        myField.setPropertyValue(childNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    if ("display".equals(childNode.getNodeName())) {
                        ArrayList<ConcreteKeyValue> options = new ArrayList<ConcreteKeyValue>();
                        ArrayList<String> selectedOptions = new ArrayList<String>();
                        for (int k = 0; k < childNode.getChildNodes().getLength(); ++k) {
                            Node displayChildNode = childNode.getChildNodes().item(k);
                            if ("type".equals(displayChildNode.getNodeName())) {
                                myField.setFieldType(StandardGenericXMLRuleAttribute.convertTypeToFieldType(displayChildNode.getFirstChild().getNodeValue()));
                                continue;
                            }
                            if ("meta".equals(displayChildNode.getNodeName()) || !"values".equals(displayChildNode.getNodeName())) continue;
                            NamedNodeMap valuesAttributes = displayChildNode.getAttributes();
                            String optionValue = "";
                            Node firstChild = displayChildNode.getFirstChild();
                            if (firstChild != null) {
                                optionValue = firstChild.getNodeValue();
                            }
                            if (valuesAttributes.getNamedItem("selected") != null) {
                                selectedOptions.add(optionValue);
                            }
                            String title = "";
                            Node titleAttribute = valuesAttributes.getNamedItem("title");
                            if (titleAttribute != null) {
                                title = titleAttribute.getNodeValue();
                            }
                            options.add(new ConcreteKeyValue(optionValue, title));
                        }
                        if (options.isEmpty()) continue;
                        myField.setFieldValidValues(options);
                        if (selectedOptions.isEmpty()) continue;
                        myField.setPropertyValue((String)selectedOptions.get(0));
                        continue;
                    }
                    if (!"lookup".equals(childNode.getNodeName())) continue;
                    XMLAttributeUtils.establishFieldLookup(myField, childNode);
                }
                fields.add(myField);
                rows.add(new Row(fields));
            }
        }
        return rows;
    }

    private static String convertTypeToFieldType(String type) {
        if ("text".equals(type)) {
            return "text";
        }
        if ("select".equals(type)) {
            return "dropdown";
        }
        if ("radio".equals(type)) {
            return "radio";
        }
        if ("quickfinder".equals(type)) {
            return "quickFinder";
        }
        return null;
    }

    @Override
    public void setExtensionDefinition(ExtensionDefinition extensionDefinition) {
        this.extensionDefinition = extensionDefinition;
    }

    @Override
    public boolean isMatch(DocumentContent docContent, List<RuleExtension> ruleExtensions) {
        XPath xpath = null;
        String xPathCacheKey = null;
        RouteNodeInstance rni = docContent.getRouteContext().getNodeInstance();
        if (rni != null) {
            xPathCacheKey = "xPath" + rni.getRouteNodeInstanceId() + "-" + rni.getName();
            if (docContent.getRouteContext().getParameters().containsKey(xPathCacheKey)) {
                xpath = (XPath)docContent.getRouteContext().getParameters().get(xPathCacheKey);
            } else {
                xpath = XPathHelper.newXPath(docContent.getDocument());
                docContent.getRouteContext().getParameters().put(xPathCacheKey, xpath);
            }
        } else {
            xpath = XPathHelper.newXPath(docContent.getDocument());
            docContent.getRouteContext().getParameters().put(xPathCacheKey, xpath);
        }
        WorkflowFunctionResolver resolver = XPathHelper.extractFunctionResolver(xpath);
        resolver.setRuleExtensions(ruleExtensions);
        List<String> xPathExpressionsToEvaluate = this.extractExpressionsToEvaluate(xpath, docContent, ruleExtensions);
        for (String xPathExpressionToEvaluate : xPathExpressionsToEvaluate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluating xPath expression: " + xPathExpressionToEvaluate);
            }
            try {
                Boolean match = (Boolean)xpath.evaluate(xPathExpressionToEvaluate, docContent.getDocument(), XPathConstants.BOOLEAN);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Expression match result: " + match);
                }
                if (match == null || match.booleanValue()) continue;
                return false;
            }
            catch (XPathExpressionException e) {
                LOG.error("Error in isMatch ", (Throwable)e);
                throw new RuntimeException("Error trying to evaluate xml content with xpath expression: " + xPathExpressionToEvaluate, e);
            }
        }
        return true;
    }

    protected List<String> extractExpressionsToEvaluate(XPath xpath, DocumentContent docContent, List<RuleExtension> ruleExtensions) {
        ArrayList<String> expressionsToEvaluate = new ArrayList<String>(ruleExtensions.size() + 1);
        Element configXml = this.getConfigXML();
        String findFieldExpressions = "//routingConfig/fieldDef/fieldEvaluation/xpathexpression";
        try {
            NodeList xPathExpressions = (NodeList)xpath.evaluate(findFieldExpressions, configXml, XPathConstants.NODESET);
            for (int index = 0; index < xPathExpressions.getLength(); ++index) {
                Element expressionElement = (Element)xPathExpressions.item(index);
                String expression = expressionElement.getTextContent();
                if (!this.isEvaluateForMissingExtensions()) {
                    Node parentNode = expressionElement.getParentNode().getParentNode();
                    Node fieldAttribute = parentNode.getAttributes().getNamedItem("name");
                    if (fieldAttribute == null || StringUtils.isEmpty((String)fieldAttribute.getNodeValue())) {
                        throw new WorkflowRuntimeException("Could not determine field name defined on fieldDef for xpath expression: " + expression);
                    }
                    String fieldName = fieldAttribute.getNodeValue();
                    boolean foundExtension = false;
                    block5: for (RuleExtension ruleExtension : ruleExtensions) {
                        if (!ruleExtension.getRuleTemplateAttribute().getRuleAttribute().getName().equals(this.extensionDefinition.getName())) continue;
                        for (String ruleExtensionValueKey : ruleExtension.getExtensionValuesMap().keySet()) {
                            if (!fieldName.equals(ruleExtensionValueKey)) continue;
                            foundExtension = true;
                            break block5;
                        }
                    }
                    if (!foundExtension) continue;
                }
                if (StringUtils.isEmpty((String)expression)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding routingConfig XPath expression: " + expression);
                }
                expressionsToEvaluate.add(expression);
            }
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException("Failed to evaluate XPath expression for fieldDefs: " + findFieldExpressions, (Throwable)e);
        }
        String findGlobalExpressions = "//routingConfig/globalEvaluations/xpathexpression";
        try {
            NodeList xPathExpressions = (NodeList)xpath.evaluate(findGlobalExpressions, configXml, XPathConstants.NODESET);
            for (int index = 0; index < xPathExpressions.getLength(); ++index) {
                Element expressionElement = (Element)xPathExpressions.item(index);
                String expression = expressionElement.getTextContent();
                if (StringUtils.isEmpty((String)expression)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding global XPath expression: " + expression);
                }
                expressionsToEvaluate.add(expression);
            }
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException("Failed to evaluate global XPath expression: " + findGlobalExpressions, (Throwable)e);
        }
        return expressionsToEvaluate;
    }

    public List getRuleRows() {
        if (this.ruleRows.isEmpty()) {
            this.ruleRows = this.getRows(this.getConfigXML(), new String[]{"ALL", "RULE"});
        }
        return this.ruleRows;
    }

    private String getValidationErrorMessage(XPath xpath, Element root, String fieldName) throws XPathExpressionException {
        String findErrorMessage = "//routingConfig/fieldDef[@name='" + fieldName + "']/validation/message";
        return (String)xpath.evaluate(findErrorMessage, root, XPathConstants.STRING);
    }

    private <T> List<T> validate(Element root, String[] types, Map map, ErrorGenerator<T> errorGenerator) throws XPathExpressionException {
        ArrayList<T> errors = new ArrayList<T>();
        XPath xpath = XPathHelper.newXPath();
        NodeList nodes = this.getFields(xpath, root, types);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node field = nodes.item(i);
            NamedNodeMap fieldAttributes = field.getAttributes();
            String fieldName = fieldAttributes.getNamedItem("name").getNodeValue();
            LOG.debug("evaluating field: " + fieldName);
            String findValidation = "//routingConfig/fieldDef[@name='" + fieldName + "']/validation";
            Node validationNode = (Node)xpath.evaluate(findValidation, root, XPathConstants.NODE);
            boolean fieldIsRequired = false;
            if (validationNode != null) {
                NamedNodeMap validationAttributes = validationNode.getAttributes();
                Node reqAttribNode = validationAttributes.getNamedItem("required");
                fieldIsRequired = reqAttribNode != null && "true".equalsIgnoreCase(reqAttribNode.getNodeValue());
            }
            String findRegex = "//routingConfig/fieldDef[@name='" + fieldName + "']/validation/regex";
            String regex = null;
            Node regexNode = (Node)xpath.evaluate(findRegex, root, XPathConstants.NODE);
            if (regexNode != null && regexNode.getFirstChild() != null && (regex = regexNode.getFirstChild().getNodeValue()) == null) {
                throw new RuntimeException("Null regex text node");
            }
            LOG.debug("regex for field '" + fieldName + "': '" + regex + "'");
            String fieldValue = null;
            if (map != null) {
                fieldValue = (String)map.get(fieldName);
            }
            LOG.debug("field value: " + fieldValue);
            if (fieldValue == null) {
                fieldValue = "";
            }
            if (regex == null) {
                if (!fieldIsRequired || fieldValue.length() != 0) continue;
                errors.add(errorGenerator.generateMissingFieldError(field, fieldName, this.getValidationErrorMessage(xpath, root, fieldName)));
                continue;
            }
            if (Pattern.compile(regex).matcher(fieldValue).matches()) continue;
            LOG.debug("field value does not match validation regex");
            errors.add(errorGenerator.generateInvalidFieldError(field, fieldName, this.getValidationErrorMessage(xpath, root, fieldName)));
        }
        return errors;
    }

    public List getRoutingDataRows() {
        if (this.routingDataRows.isEmpty()) {
            this.routingDataRows = this.getRows(this.getConfigXML(), new String[]{"ALL", "REPORT"});
        }
        return this.routingDataRows;
    }

    @Override
    public String getDocContent() {
        XPath xpath = XPathHelper.newXPath();
        String findDocContent = "//routingConfig/xmlDocumentContent";
        try {
            Node xmlDocumentContent = (Node)xpath.evaluate("//routingConfig/xmlDocumentContent", this.getConfigXML(), XPathConstants.NODE);
            NodeList nodes = this.getFields(xpath, this.getConfigXML(), new String[]{"ALL", "REPORT", "RULE"});
            if (xmlDocumentContent != null && xmlDocumentContent.hasChildNodes()) {
                int i;
                Object documentContent = "";
                NodeList customNodes = xmlDocumentContent.getChildNodes();
                for (i = 0; i < customNodes.getLength(); ++i) {
                    Node childNode = customNodes.item(i);
                    documentContent = (String)documentContent + XmlJotter.jotNode((Node)childNode);
                }
                for (i = 0; i < nodes.getLength(); ++i) {
                    Node field = nodes.item(i);
                    NamedNodeMap fieldAttributes = field.getAttributes();
                    String fieldName = fieldAttributes.getNamedItem("name").getNodeValue();
                    LOG.debug("Replacing field '" + fieldName + "'");
                    Map map = this.getParamMap();
                    String fieldValue = (String)map.get(fieldName);
                    if (map != null && !StringUtils.isEmpty((String)fieldValue)) {
                        LOG.debug("Replacing %" + fieldName + "% with field value: '" + fieldValue + "'");
                        documentContent = ((String)documentContent).replaceAll("%" + fieldName + "%", fieldValue);
                        continue;
                    }
                    LOG.debug("Field map is null or fieldValue is empty");
                }
                return documentContent;
            }
            StringBuffer documentContent = new StringBuffer("<xmlRouting>");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node field = nodes.item(i);
                NamedNodeMap fieldAttributes = field.getAttributes();
                String fieldName = fieldAttributes.getNamedItem("name").getNodeValue();
                Map map = this.getParamMap();
                if (map == null || StringUtils.isEmpty((String)((String)map.get(fieldName)))) continue;
                documentContent.append("<field name=\"");
                documentContent.append(fieldName);
                documentContent.append("\"><value>");
                documentContent.append((String)map.get(fieldName));
                documentContent.append("</value></field>");
            }
            documentContent.append("</xmlRouting>");
            return documentContent.toString();
        }
        catch (XPathExpressionException e) {
            LOG.error("error in getDocContent ", (Throwable)e);
            throw new RuntimeException("Error trying to find xml content with xpath expression", e);
        }
        catch (Exception e) {
            LOG.error("error in getDocContent attempting to find xml doc content", (Throwable)e);
            throw new RuntimeException("Error trying to get xml doc content.", e);
        }
    }

    public List getRuleExtensionValues() {
        ArrayList<RuleExtensionValue> extensionValues = new ArrayList<RuleExtensionValue>();
        XPath xpath = XPathHelper.newXPath();
        try {
            NodeList nodes = this.getFields(xpath, this.getConfigXML(), new String[]{"ALL", "RULE"});
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node field = nodes.item(i);
                NamedNodeMap fieldAttributes = field.getAttributes();
                String fieldName = fieldAttributes.getNamedItem("name").getNodeValue();
                Map map = this.getParamMap();
                if (map == null || StringUtils.isEmpty((String)((String)map.get(fieldName)))) continue;
                RuleExtensionValue value = new RuleExtensionValue();
                value.setKey(fieldName);
                value.setValue((String)map.get(fieldName));
                extensionValues.add(value);
            }
        }
        catch (XPathExpressionException e) {
            LOG.error("error in getRuleExtensionValues ", (Throwable)e);
            throw new RuntimeException("Error trying to find xml content with xpath expression", e);
        }
        return extensionValues;
    }

    public List<RemotableAttributeError> validateRoutingData(Map paramMap) {
        this.paramMap = paramMap;
        try {
            return this.validate(this.getConfigXML(), new String[]{"ALL", "REPORT"}, paramMap, new ErrorGenerator<RemotableAttributeError>(this){

                @Override
                public RemotableAttributeError generateInvalidFieldError(Node field, String fieldName, String message) {
                    return RemotableAttributeError.Builder.create((String)"routetemplate.xmlattribute.error", (String[])new String[]{message}).build();
                }

                @Override
                public RemotableAttributeError generateMissingFieldError(Node field, String fieldName, String message) {
                    return RemotableAttributeError.Builder.create((String)"routetemplate.xmlattribute.required.error", (String[])new String[]{field.getAttributes().getNamedItem("title").getNodeValue()}).build();
                }
            });
        }
        catch (XPathExpressionException e) {
            LOG.error("error in validateRoutingData ", (Throwable)e);
            throw new RuntimeException("Error trying to find xml content with xpath expression", e);
        }
    }

    public List<RemotableAttributeError> validateRuleData(Map paramMap) {
        this.paramMap = paramMap;
        try {
            return this.validate(this.getConfigXML(), new String[]{"ALL", "RULE"}, paramMap, new ErrorGenerator<RemotableAttributeError>(this){

                @Override
                public RemotableAttributeError generateInvalidFieldError(Node field, String fieldName, String message) {
                    return RemotableAttributeError.Builder.create((String)"routetemplate.xmlattribute.error", (String[])new String[]{message}).build();
                }

                @Override
                public RemotableAttributeError generateMissingFieldError(Node field, String fieldName, String message) {
                    return RemotableAttributeError.Builder.create((String)"routetemplate.xmlattribute.required.error", (String[])new String[]{field.getAttributes().getNamedItem("title").getNodeValue()}).build();
                }
            });
        }
        catch (XPathExpressionException e) {
            LOG.error("error in validateRoutingData ", (Throwable)e);
            throw new RuntimeException("Error trying to find xml content with xpath expression", e);
        }
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public Element getConfigXML() {
        try {
            return SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new BufferedReader(new StringReader((String)this.extensionDefinition.getConfiguration().get("xmlConfigData"))))).getDocumentElement();
        }
        catch (Exception e) {
            String str = this.extensionDefinition == null ? "null" : this.extensionDefinition.getName();
            LOG.error("error parsing xml data from rule attribute: " + str, (Throwable)e);
            throw new RuntimeException("error parsing xml data from rule attribute: " + str, e);
        }
    }

    public List<RemotableAttributeError> validateClientRoutingData() {
        LOG.debug("validating client routing data");
        try {
            return this.validate(this.getConfigXML(), new String[]{"ALL", "RULE"}, this.getParamMap(), new ErrorGenerator<RemotableAttributeError>(this){

                @Override
                public RemotableAttributeError generateInvalidFieldError(Node field, String fieldName, String message) {
                    if (StringUtils.isEmpty((String)message)) {
                        message = "invalid field value";
                    } else {
                        LOG.info("Message: '" + message + "'");
                    }
                    return RemotableAttributeError.Builder.create((String)fieldName, (String[])new String[]{message}).build();
                }

                @Override
                public RemotableAttributeError generateMissingFieldError(Node field, String fieldName, String message) {
                    return RemotableAttributeError.Builder.create((String)fieldName, (String[])new String[]{"Attribute is required; " + message}).build();
                }
            });
        }
        catch (XPathExpressionException e) {
            LOG.error("error in validateClientRoutingData ", (Throwable)e);
            throw new RuntimeException("Error trying to find xml content with xpath expression", e);
        }
    }

    @Override
    public Map getParamMap() {
        return this.paramMap;
    }

    @Override
    public void setParamMap(Map paramMap) {
        this.paramMap = paramMap;
    }

    public boolean isEvaluateForMissingExtensions() {
        return this.evaluateForMissingExtensions;
    }

    public void setEvaluateForMissingExtensions(boolean evaluateForMissingExtensions) {
        this.evaluateForMissingExtensions = evaluateForMissingExtensions;
    }

    private static interface ErrorGenerator<T> {
        public T generateInvalidFieldError(Node var1, String var2, String var3);

        public T generateMissingFieldError(Node var1, String var2, String var3);
    }
}

