/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.lookup.LookupResultsSupportStrategyService;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.service.DataDictionaryService;

@Deprecated
public class DataDictionaryLookupResultsSupportStrategy
implements LookupResultsSupportStrategyService {
    private DataDictionaryService dataDictionaryService;

    @Override
    public String getLookupIdForBusinessObject(BusinessObject businessObject) {
        List<String> pkFieldNames = this.getPrimaryKeyFieldsForBusinessObject(businessObject.getClass());
        return this.convertPKFieldMapToLookupId(pkFieldNames, businessObject);
    }

    @Override
    public boolean qualifiesForStrategy(Class<? extends BusinessObject> boClass) {
        if (this.getLookupableForBusinessObject(boClass) == null) {
            return false;
        }
        List<String> pkFields = this.getPrimaryKeyFieldsForBusinessObject(boClass);
        return pkFields != null && pkFields.size() > 0;
    }

    @Override
    public <T extends BusinessObject> Collection<T> retrieveSelectedResultBOs(Class<T> boClass, Set<String> lookupIds) throws Exception {
        ArrayList<BusinessObject> retrievedBusinessObjects = new ArrayList<BusinessObject>();
        Lookupable lookupable = this.getLookupableForBusinessObject(boClass);
        for (String lookupId : lookupIds) {
            Map<String, String> lookupKeys = this.convertLookupIdToPKFieldMap(lookupId, boClass);
            List bos = lookupable.getSearchResults(lookupKeys);
            for (BusinessObject bo : bos) {
                retrievedBusinessObjects.add(bo);
            }
        }
        return retrievedBusinessObjects;
    }

    protected Lookupable getLookupableForBusinessObject(Class<? extends BusinessObject> businessObjectClass) {
        BusinessObjectEntry boEntry = this.getBusinessObjectEntry(businessObjectClass);
        if (boEntry == null) {
            return null;
        }
        String lookupableId = boEntry.getLookupDefinition().getLookupableID();
        if (StringUtils.isBlank((String)lookupableId)) {
            return null;
        }
        return KNSServiceLocator.getLookupable((String)lookupableId);
    }

    protected List<String> getPrimaryKeyFieldsForBusinessObject(Class<? extends BusinessObject> businessObjectClass) {
        BusinessObjectEntry boEntry = this.getBusinessObjectEntry(businessObjectClass);
        if (boEntry == null) {
            return null;
        }
        return boEntry.getPrimaryKeys();
    }

    protected Map<String, String> convertLookupIdToPKFieldMap(String lookupId, Class<? extends BusinessObject> businessObjectClass) {
        HashMap<String, String> pkFields = new HashMap<String, String>();
        if (!StringUtils.isBlank((String)lookupId)) {
            String[] pkValues;
            for (String pkValue : pkValues = lookupId.split("\\|")) {
                String[] pkPieces;
                if (StringUtils.isBlank((String)pkValue) || StringUtils.isBlank((String)(pkPieces = pkValue.split("-"))[0]) || StringUtils.isBlank((String)pkPieces[1])) continue;
                pkFields.put(pkPieces[0], pkPieces[1]);
            }
        }
        return pkFields;
    }

    protected String convertPKFieldMapToLookupId(List<String> pkFieldNames, BusinessObject businessObject) {
        StringBuilder lookupId = new StringBuilder();
        for (String pkFieldName : pkFieldNames) {
            try {
                Object value = PropertyUtils.getProperty((Object)businessObject, (String)pkFieldName);
                if (value != null) {
                    lookupId.append(pkFieldName);
                    lookupId.append("-");
                    Formatter formatter = this.retrieveBestFormatter(pkFieldName, businessObject.getClass());
                    String formattedValue = formatter != null ? formatter.format(value).toString() : value.toString();
                    lookupId.append(formattedValue);
                }
                lookupId.append(SearchOperator.OR.op());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Could not retrieve pk field value " + pkFieldName + " from business object " + businessObject.getClass().getName(), iae);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException("Could not retrieve pk field value " + pkFieldName + " from business object " + businessObject.getClass().getName(), ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("Could not retrieve pk field value " + pkFieldName + " from business object " + businessObject.getClass().getName(), nsme);
            }
        }
        return lookupId.substring(0, lookupId.length() - 1);
    }

    protected Formatter retrieveBestFormatter(String propertyName, Class<? extends BusinessObject> boClass) {
        Formatter formatter = null;
        try {
            Field propertyField;
            AttributeDefinition attributeDefinition;
            Class<?> formatterClass = null;
            BusinessObjectEntry boEntry = this.getBusinessObjectEntry(boClass);
            if (boEntry != null && (attributeDefinition = boEntry.getAttributeDefinition(propertyName)) != null && attributeDefinition.hasFormatterClass()) {
                formatterClass = Class.forName(attributeDefinition.getFormatterClass());
            }
            if (formatterClass == null && (propertyField = boClass.getDeclaredField(propertyName)) != null) {
                formatterClass = Formatter.findFormatter(propertyField.getType());
            }
            if (formatterClass != null) {
                formatter = (Formatter)formatterClass.newInstance();
            }
        }
        catch (SecurityException se) {
            throw new RuntimeException("Could not retrieve good formatter", se);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not retrieve good formatter", cnfe);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException("Could not retrieve good formatter", nsfe);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not retrieve good formatter", iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Could not retrieve good formatter", ie);
        }
        return formatter;
    }

    protected BusinessObjectEntry getBusinessObjectEntry(Class<? extends BusinessObject> boClass) {
        return (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(boClass.getName());
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

