/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.search;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.search.Range;
import org.kuali.rice.core.api.search.SearchOperator;

public class SearchExpressionUtils {
    static final Collection<SearchOperator> BINARY_RANGE_OPERATORS = Collections.unmodifiableCollection(Arrays.asList(SearchOperator.BETWEEN, SearchOperator.BETWEEN_EXCLUSIVE_LOWER, SearchOperator.BETWEEN_EXCLUSIVE_UPPER, SearchOperator.BETWEEN_EXCLUSIVE_UPPER2, SearchOperator.BETWEEN_EXCLUSIVE));
    public static final Collection<SearchOperator> CLAUSE_OPERATORS = Collections.unmodifiableCollection(Arrays.asList(SearchOperator.AND, SearchOperator.OR));
    private static final Pattern CLAUSE_OPERATORS_PATTERN = SearchExpressionUtils.generateSplitPattern(CLAUSE_OPERATORS);
    private final Collection<SearchOperator> PREFIX_UNARY_OPERATORS = Collections.unmodifiableCollection(Arrays.asList(SearchOperator.GREATER_THAN, SearchOperator.LESS_THAN, SearchOperator.GREATER_THAN_EQUAL, SearchOperator.LESS_THAN_EQUAL, SearchOperator.NOT));
    private final Collection<SearchOperator> POSTFIX_UNARY_OPERATORS = Collections.unmodifiableCollection(Arrays.asList(SearchOperator.LIKE_ONE, SearchOperator.LIKE_MANY, SearchOperator.LIKE_MANY_P));

    private SearchExpressionUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String parsePrefixUnaryOperatorValue(SearchOperator operator, String expression) {
        return StringUtils.removeStart((String)expression.trim(), (String)operator.op()).trim();
    }

    public static String parsePostfixUnaryOperatorValue(SearchOperator operator, String expression) {
        return StringUtils.removeEnd((String)expression.trim(), (String)operator.op()).trim();
    }

    public static String[] parseBinaryOperatorValues(SearchOperator operator, String expression) {
        return StringUtils.splitByWholeSeparator((String)expression.trim(), (String)operator.op(), (int)2);
    }

    private static Pattern generateSplitPattern(Collection<SearchOperator> operators) {
        return Pattern.compile(Joiner.on((String)"|").join(Iterables.transform(operators, (Function)new Function<SearchOperator, String>(){

            public String apply(SearchOperator op) {
                return "(?:\\s*" + Pattern.quote(op.op()) + "\\s*)";
            }
        })));
    }

    public static String[] splitOnClauses(String expression) {
        return CLAUSE_OPERATORS_PATTERN.split(expression);
    }

    public static String stripClauseOperators(String expression) {
        return CLAUSE_OPERATORS_PATTERN.matcher(expression).replaceAll("");
    }

    public static String[] splitOnOperators(String expression, Collection<SearchOperator> operators) {
        return SearchExpressionUtils.generateSplitPattern(operators).split(expression);
    }

    public static String[] splitOnOperators(String expression, SearchOperator ... operators) {
        return SearchExpressionUtils.generateSplitPattern(Arrays.asList(operators)).split(expression);
    }

    public static String stripOperators(String expression, Collection<SearchOperator> operators) {
        return SearchExpressionUtils.generateSplitPattern(operators).matcher(expression).replaceAll("");
    }

    public static String stripOperators(String expression, SearchOperator ... operators) {
        return SearchExpressionUtils.generateSplitPattern(Arrays.asList(operators)).matcher(expression).replaceAll("");
    }

    public static Range parseRange(String rangeString) {
        if (StringUtils.isBlank((String)rangeString)) {
            throw new IllegalArgumentException("rangeString was null or blank");
        }
        Range range = new Range();
        if ((rangeString = rangeString.trim()).startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            rangeString = SearchExpressionUtils.parsePrefixUnaryOperatorValue(SearchOperator.LESS_THAN_EQUAL, rangeString);
            range.setUpperBoundValue(rangeString);
            range.setUpperBoundInclusive(true);
        } else if (rangeString.startsWith(SearchOperator.LESS_THAN.op())) {
            rangeString = SearchExpressionUtils.parsePrefixUnaryOperatorValue(SearchOperator.LESS_THAN, rangeString);
            range.setUpperBoundValue(rangeString);
            range.setUpperBoundInclusive(false);
        } else if (rangeString.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
            rangeString = SearchExpressionUtils.parsePrefixUnaryOperatorValue(SearchOperator.GREATER_THAN_EQUAL, rangeString);
            range.setLowerBoundValue(rangeString);
            range.setLowerBoundInclusive(true);
        } else if (rangeString.startsWith(SearchOperator.GREATER_THAN.op())) {
            rangeString = SearchExpressionUtils.parsePrefixUnaryOperatorValue(SearchOperator.GREATER_THAN, rangeString);
            range.setLowerBoundValue(rangeString);
            range.setLowerBoundInclusive(false);
        } else if (rangeString.contains(SearchOperator.BETWEEN_EXCLUSIVE.op())) {
            String[] rangeBounds = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN_EXCLUSIVE, rangeString);
            range.setLowerBoundValue(rangeBounds[0]);
            range.setLowerBoundInclusive(false);
            range.setUpperBoundValue(rangeBounds[1]);
            range.setUpperBoundInclusive(false);
        } else if (rangeString.contains(SearchOperator.BETWEEN_EXCLUSIVE_UPPER.op())) {
            String[] rangeBounds = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN_EXCLUSIVE_UPPER, rangeString);
            range.setLowerBoundValue(rangeBounds[0]);
            range.setLowerBoundInclusive(true);
            range.setUpperBoundValue(rangeBounds[1]);
            range.setUpperBoundInclusive(false);
        } else if (rangeString.contains(SearchOperator.BETWEEN_EXCLUSIVE_UPPER2.op())) {
            String[] rangeBounds = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN_EXCLUSIVE_UPPER2, rangeString);
            range.setLowerBoundValue(rangeBounds[0]);
            range.setLowerBoundInclusive(true);
            range.setUpperBoundValue(rangeBounds[1]);
            range.setUpperBoundInclusive(false);
        } else if (rangeString.contains(SearchOperator.BETWEEN_EXCLUSIVE_LOWER.op())) {
            String[] rangeBounds = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN_EXCLUSIVE_LOWER, rangeString);
            range.setLowerBoundValue(rangeBounds[0]);
            range.setLowerBoundInclusive(false);
            range.setUpperBoundValue(rangeBounds[1]);
            range.setUpperBoundInclusive(true);
        } else if (rangeString.contains(SearchOperator.BETWEEN.op())) {
            String[] rangeBounds = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN, rangeString);
            range.setLowerBoundValue(rangeBounds[0]);
            range.setLowerBoundInclusive(true);
            range.setUpperBoundValue(rangeBounds[1]);
            range.setUpperBoundInclusive(true);
        } else {
            return null;
        }
        return range;
    }

    public static Predicate parsePredicates(String expression, String property) {
        HashSet<Predicate> ored_predicates = new HashSet<Predicate>();
        for (String or_clause : SearchExpressionUtils.splitOnOperators(expression, SearchOperator.OR)) {
            HashSet<Predicate> anded_predicates = new HashSet<Predicate>();
            for (String and_clause : SearchExpressionUtils.splitOnOperators(or_clause, SearchOperator.AND)) {
                anded_predicates.add(SearchExpressionUtils.parseSimplePredicate(property, and_clause));
            }
            ored_predicates.add(PredicateFactory.and(anded_predicates.toArray(new Predicate[0])));
        }
        return PredicateFactory.or(ored_predicates.toArray(new Predicate[0]));
    }

    public static Predicate parseSimplePredicate(String property, String value) {
        if (value.contains(SearchOperator.NULL.op())) {
            if (SearchExpressionUtils.isNot(value)) {
                return PredicateFactory.isNotNull(property);
            }
            return PredicateFactory.isNull(property);
        }
        if (value.contains(SearchOperator.BETWEEN_EXCLUSIVE_UPPER.op())) {
            String[] betweenVals = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN_EXCLUSIVE_UPPER, value);
            return PredicateFactory.and(PredicateFactory.greaterThanOrEqual(property, betweenVals[0]), PredicateFactory.lessThan(property, betweenVals[1]));
        }
        if (value.contains(SearchOperator.BETWEEN.op())) {
            String[] betweenVals = SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN, value);
            return PredicateFactory.and(PredicateFactory.greaterThanOrEqual(property, betweenVals[0]), PredicateFactory.lessThanOrEqual(property, betweenVals[1]));
        }
        if (value.contains(SearchOperator.GREATER_THAN_EQUAL.op())) {
            return PredicateFactory.greaterThanOrEqual(property, SearchExpressionUtils.stripOperators(value, SearchOperator.GREATER_THAN_EQUAL));
        }
        if (value.contains(SearchOperator.LESS_THAN_EQUAL.op())) {
            return PredicateFactory.lessThanOrEqual(property, SearchExpressionUtils.stripOperators(value, SearchOperator.LESS_THAN_EQUAL));
        }
        if (value.contains(SearchOperator.GREATER_THAN.op())) {
            return PredicateFactory.greaterThan(property, SearchExpressionUtils.stripOperators(value, SearchOperator.GREATER_THAN));
        }
        if (value.contains(SearchOperator.LESS_THAN.op())) {
            return PredicateFactory.lessThan(property, SearchExpressionUtils.stripOperators(value, SearchOperator.LESS_THAN));
        }
        if (value.contains(SearchOperator.NOT.op())) {
            String[] notValues = SearchExpressionUtils.splitOnOperators(value, SearchOperator.NOT);
            ArrayList<Predicate> notPreds = new ArrayList<Predicate>(notValues.length);
            for (String notValue : notValues) {
                notPreds.add(PredicateFactory.notEqual(property, SearchExpressionUtils.stripOperators(notValue, SearchOperator.NOT)));
            }
            return PredicateFactory.and(notPreds.toArray(new Predicate[notPreds.size()]));
        }
        if (value.contains(SearchOperator.LIKE_MANY.op()) || value.contains(SearchOperator.LIKE_ONE.op())) {
            if (SearchExpressionUtils.isNot(value)) {
                return PredicateFactory.notLike(property, value);
            }
            return PredicateFactory.like(property, value);
        }
        if (SearchExpressionUtils.isNot(value)) {
            return PredicateFactory.notEqual(property, value);
        }
        return PredicateFactory.equal(property, value);
    }

    private static boolean isNot(String value) {
        if (value == null) {
            return false;
        }
        return value.contains(SearchOperator.NOT.op());
    }

    private static List<String> getSearchableValues(String valueEntered) {
        ArrayList<String> lRet = new ArrayList<String>();
        SearchExpressionUtils.getSearchableValueRecursive(valueEntered, lRet);
        return lRet;
    }

    private static void getSearchableValueRecursive(String valueEntered, List lRet) {
        if (valueEntered == null) {
            return;
        }
        valueEntered = valueEntered.trim();
        if (lRet == null) {
            throw new NullPointerException("The list passed in is by reference and should never be null.");
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.BETWEEN.op())) {
            List<String> l = Arrays.asList(SearchExpressionUtils.parseBinaryOperatorValues(SearchOperator.BETWEEN, valueEntered));
            for (String value : l) {
                SearchExpressionUtils.getSearchableValueRecursive(value, lRet);
            }
            return;
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.OR.op())) {
            List<String> l = Arrays.asList(StringUtils.split((String)valueEntered, (String)SearchOperator.OR.op()));
            for (String value : l) {
                SearchExpressionUtils.getSearchableValueRecursive(value, lRet);
            }
            return;
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.AND.op())) {
            List<String> l = Arrays.asList(StringUtils.split((String)valueEntered, (String)SearchOperator.AND.op()));
            for (String value : l) {
                SearchExpressionUtils.getSearchableValueRecursive(value, lRet);
            }
            return;
        }
        lRet.add(valueEntered);
    }
}

