/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.api.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.ken.api.notification.NotificationChannelContract;
import org.kuali.rice.ken.api.notification.NotificationChannelReviewer;
import org.kuali.rice.ken.api.notification.NotificationChannelReviewerContract;
import org.kuali.rice.ken.api.notification.NotificationListRecipient;
import org.kuali.rice.ken.api.notification.NotificationListRecipientContract;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.NotificationProducerContract;
import org.kuali.rice.ken.api.notification.UserChannelSubscription;
import org.kuali.rice.ken.api.notification.UserChannelSubscriptionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="notificationChannel")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="NotificationChannelType", propOrder={"name", "description", "subscribable", "recipientLists", "producers", "reviewers", "subscriptions", "id", "versionNumber", "objectId", "_futureElements"})
public final class NotificationChannel
extends AbstractDataTransferObject
implements NotificationChannelContract {
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="subscribable", required=false)
    private final boolean subscribable;
    @XmlElementWrapper(name="recipientLists", required=false)
    @XmlElement(name="recipientList", required=false)
    private final List<NotificationListRecipient> recipientLists;
    @XmlElementWrapper(name="producers", required=false)
    @XmlElement(name="producer", required=false)
    private final List<NotificationProducer> producers;
    @XmlElementWrapper(name="reviewers", required=false)
    @XmlElement(name="reviewer", required=false)
    private final List<NotificationChannelReviewer> reviewers;
    @XmlElementWrapper(name="subscriptions", required=false)
    @XmlElement(name="subscription", required=false)
    private final List<UserChannelSubscription> subscriptions;
    @XmlElement(name="id", required=false)
    private final Long id;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private NotificationChannel() {
        this.name = null;
        this.description = null;
        this.subscribable = false;
        this.recipientLists = null;
        this.producers = null;
        this.reviewers = null;
        this.subscriptions = null;
        this.id = null;
        this.versionNumber = null;
        this.objectId = null;
    }

    private NotificationChannel(Builder builder) {
        this.name = builder.getName();
        this.description = builder.getDescription();
        this.subscribable = builder.isSubscribable();
        this.recipientLists = new ArrayList<NotificationListRecipient>();
        if (CollectionUtils.isNotEmpty(builder.getRecipientLists())) {
            for (NotificationListRecipient.Builder listRecipient : builder.getRecipientLists()) {
                this.recipientLists.add(listRecipient.build());
            }
        }
        this.producers = new ArrayList<NotificationProducer>();
        if (CollectionUtils.isNotEmpty(builder.getProducers())) {
            for (NotificationProducer.Builder producer : builder.getProducers()) {
                this.producers.add(producer.build());
            }
        }
        this.reviewers = new ArrayList<NotificationChannelReviewer>();
        if (CollectionUtils.isNotEmpty(builder.getReviewers())) {
            for (NotificationChannelReviewer.Builder reviewer : builder.getReviewers()) {
                this.reviewers.add(reviewer.build());
            }
        }
        this.subscriptions = new ArrayList<UserChannelSubscription>();
        if (CollectionUtils.isNotEmpty(builder.getSubscriptions())) {
            for (UserChannelSubscription.Builder subscription : builder.getSubscriptions()) {
                this.subscriptions.add(subscription.build());
            }
        }
        this.id = builder.getId();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isSubscribable() {
        return this.subscribable;
    }

    public List<NotificationListRecipient> getRecipientLists() {
        return this.recipientLists;
    }

    public List<NotificationProducer> getProducers() {
        return this.producers;
    }

    public List<NotificationChannelReviewer> getReviewers() {
        return this.reviewers;
    }

    public List<UserChannelSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    static class Elements {
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String SUBSCRIBABLE = "subscribable";
        static final String RECIPIENT_LISTS = "recipientLists";
        static final String RECIPIENT_LIST = "recipientList";
        static final String PRODUCERS = "producers";
        static final String PRODUCER = "producer";
        static final String REVIEWERS = "reviewers";
        static final String REVIEWER = "reviewer";
        static final String SUBSCRIPTIONS = "subscriptions";
        static final String SUBSCRIPTION = "subscription";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "notificationChannel";
        static final String TYPE_NAME = "NotificationChannelType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    NotificationChannelContract {
        private String name;
        private String description;
        private boolean subscribable;
        private List<NotificationListRecipient.Builder> recipientLists;
        private List<NotificationProducer.Builder> producers;
        private List<NotificationChannelReviewer.Builder> reviewers;
        private List<UserChannelSubscription.Builder> subscriptions;
        private Long id;
        private Long versionNumber;
        private String objectId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(NotificationChannelContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setName(contract.getName());
            builder.setDescription(contract.getDescription());
            builder.setSubscribable(contract.isSubscribable());
            if (contract.getRecipientLists() != null) {
                ArrayList<NotificationListRecipient.Builder> tempListRecipient = new ArrayList<NotificationListRecipient.Builder>();
                for (NotificationListRecipientContract notificationListRecipientContract : contract.getRecipientLists()) {
                    tempListRecipient.add(NotificationListRecipient.Builder.create(notificationListRecipientContract));
                }
                builder.setRecipientLists(tempListRecipient);
            }
            if (contract.getProducers() != null) {
                ArrayList<NotificationProducer.Builder> tempProducers = new ArrayList<NotificationProducer.Builder>();
                for (NotificationProducerContract notificationProducerContract : contract.getProducers()) {
                    tempProducers.add(NotificationProducer.Builder.create(notificationProducerContract));
                }
                builder.setProducers(tempProducers);
            }
            if (contract.getReviewers() != null) {
                ArrayList<NotificationChannelReviewer.Builder> tempReviewers = new ArrayList<NotificationChannelReviewer.Builder>();
                for (NotificationChannelReviewerContract notificationChannelReviewerContract : contract.getReviewers()) {
                    tempReviewers.add(NotificationChannelReviewer.Builder.create(notificationChannelReviewerContract));
                }
                builder.setReviewers(tempReviewers);
            }
            if (contract.getSubscriptions() != null) {
                ArrayList<UserChannelSubscription.Builder> tempSubscriptions = new ArrayList<UserChannelSubscription.Builder>();
                for (UserChannelSubscriptionContract userChannelSubscriptionContract : contract.getSubscriptions()) {
                    tempSubscriptions.add(UserChannelSubscription.Builder.create(userChannelSubscriptionContract));
                }
                builder.setSubscriptions(tempSubscriptions);
            }
            builder.setId(contract.getId());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public NotificationChannel build() {
            return new NotificationChannel(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isSubscribable() {
            return this.subscribable;
        }

        public List<NotificationListRecipient.Builder> getRecipientLists() {
            return this.recipientLists;
        }

        public List<NotificationProducer.Builder> getProducers() {
            return this.producers;
        }

        public List<NotificationChannelReviewer.Builder> getReviewers() {
            return this.reviewers;
        }

        public List<UserChannelSubscription.Builder> getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setSubscribable(boolean subscribable) {
            this.subscribable = subscribable;
        }

        public void setRecipientLists(List<NotificationListRecipient.Builder> recipientLists) {
            this.recipientLists = recipientLists;
        }

        public void setProducers(List<NotificationProducer.Builder> producers) {
            this.producers = producers;
        }

        public void setReviewers(List<NotificationChannelReviewer.Builder> reviewers) {
            this.reviewers = reviewers;
        }

        public void setSubscriptions(List<UserChannelSubscription.Builder> subscriptions) {
            this.subscriptions = subscriptions;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }
}

