/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.web.HtmlInjectorResponseStream;
import net.bull.javamelody.internal.web.HtmlInjectorServletResponseWrapper;

public final class RumInjector
implements HtmlInjectorResponseStream.HtmlToInject {
    private static final String BOOMERANG_FILENAME = "boomerang.min.js";
    private final long start = System.currentTimeMillis();
    private final HttpServletRequest httpRequest;
    private final String requestName;

    private RumInjector(HttpServletRequest httpRequest, String requestName) {
        this.httpRequest = httpRequest;
        this.requestName = requestName;
    }

    public static HttpServletResponse createRumResponseWrapper(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String requestName) {
        if (HtmlInjectorServletResponseWrapper.acceptsRequest(httpRequest)) {
            RumInjector htmlToInject = new RumInjector(httpRequest, requestName);
            return new HtmlInjectorServletResponseWrapper(httpRequest, httpResponse, htmlToInject);
        }
        return httpResponse;
    }

    private static String getRumUrlForBrowser(String requestName) {
        int lastIndexOfSpace = requestName.lastIndexOf(32);
        assert (lastIndexOfSpace != -1);
        String tmp = requestName.substring(0, lastIndexOfSpace);
        while (tmp.indexOf("//") != -1) {
            tmp = tmp.replaceAll("//", "/");
        }
        if ((tmp = tmp.replaceAll("/[^/]*", "/..")).startsWith("/..")) {
            tmp = tmp.substring(3);
        }
        String tmp2 = tmp + Parameters.getMonitoringPath();
        while (tmp2.length() > 0 && tmp2.charAt(0) == '/') {
            tmp2 = tmp2.substring(1);
        }
        return tmp2;
    }

    @Override
    public String getContent() {
        String httpRequestName = this.getHttpRequestName();
        String rumUrl = RumInjector.getRumUrlForBrowser(httpRequestName);
        long serverTime = System.currentTimeMillis() - this.start;
        return "\n<script src='" + rumUrl + "?resource=" + BOOMERANG_FILENAME + "'></script>\n<script>BOOMR.init({beacon_url: '" + rumUrl + "?part=rum', log: null});\nBOOMR.addVar('requestName', \"" + httpRequestName + "\");\nBOOMR.addVar('serverTime', " + serverTime + ");\n</script>\n";
    }

    private String getHttpRequestName() {
        return CounterRequestContext.getHttpRequestName(this.httpRequest, this.requestName);
    }

    @Override
    public String getBeforeTag() {
        return "</body>";
    }

    public static boolean isRumResource(String resourceName) {
        return BOOMERANG_FILENAME.equals(resourceName);
    }

    public static void addRumHit(HttpServletRequest httpRequest, Counter httpCounter) {
        String requestName = httpRequest.getParameter("requestName");
        if (requestName == null) {
            return;
        }
        try {
            long serverTime = Long.parseLong(httpRequest.getParameter("serverTime"));
            long timeToFirstByte = Long.parseLong(httpRequest.getParameter("timeToFirstByte"));
            long domProcessing = Long.parseLong(httpRequest.getParameter("domProcessing"));
            long pageRendering = Long.parseLong(httpRequest.getParameter("pageRendering"));
            long networkTime = Math.max(timeToFirstByte - serverTime, 0L);
            httpCounter.addRumHit(requestName, networkTime, domProcessing, pageRendering);
        }
        catch (NumberFormatException e) {
            return;
        }
    }
}

