/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceproxies;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.core.api.util.reflect.BaseInvocationHandler;
import org.kuali.rice.core.api.util.reflect.TargetedInvocationHandler;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.quartz.MessageServiceExecutorJob;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class DelayedAsynchronousServiceCallProxy
extends BaseInvocationHandler
implements TargetedInvocationHandler {
    private static final Logger LOG = LogManager.getLogger(DelayedAsynchronousServiceCallProxy.class);
    List<Endpoint> endpoints;
    private Serializable context;
    private String value1;
    private String value2;
    private long delayMilliseconds;

    protected DelayedAsynchronousServiceCallProxy(List<Endpoint> endpoints, Serializable context, String value1, String value2, long delayMilliseconds) {
        this.endpoints = endpoints;
        this.context = context;
        this.value1 = value1;
        this.value2 = value2;
        this.delayMilliseconds = delayMilliseconds;
    }

    public static Object createInstance(List<Endpoint> endpoints, Serializable context, String value1, String value2, long delayMilliseconds) {
        if (endpoints == null || endpoints.isEmpty()) {
            throw new RuntimeException("Cannot create service proxy, no service(s) passed in.");
        }
        try {
            return Proxy.newProxyInstance(ClassLoaderUtils.getDefaultClassLoader(), ContextClassLoaderProxy.getInterfacesToProxy((Object)endpoints.get(0).getService()), (InvocationHandler)((Object)new DelayedAsynchronousServiceCallProxy(endpoints, context, value1, value2, delayMilliseconds)));
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInternal(Object proxy, Method method, Object[] arguments) throws Throwable {
        AsynchronousCall methodCall = null;
        PersistedMessageBO message = null;
        DelayedAsynchronousServiceCallProxy delayedAsynchronousServiceCallProxy = this;
        synchronized (delayedAsynchronousServiceCallProxy) {
            for (Endpoint endpoint : this.endpoints) {
                ServiceConfiguration serviceConfiguration = endpoint.getServiceConfiguration();
                methodCall = new AsynchronousCall((Class[])method.getParameterTypes(), arguments, serviceConfiguration, method.getName(), null, this.context);
                message = PersistedMessageBO.buildMessage(serviceConfiguration, methodCall);
                message.setValue1(this.value1);
                message.setValue2(this.value2);
                Calendar now = Calendar.getInstance();
                now.add(14, (int)this.delayMilliseconds);
                message.setQueueDate(new Timestamp(now.getTimeInMillis()));
                this.scheduleMessage(message);
                if (!serviceConfiguration.isQueue()) continue;
                break;
            }
        }
        return null;
    }

    protected void scheduleMessage(PersistedMessageBO message) throws SchedulerException {
        LOG.debug("Scheduling execution of a delayed asynchronous message.");
        Scheduler scheduler = KSBServiceLocator.getScheduler();
        JobDataMap jobData = new JobDataMap();
        jobData.put("message", (Object)message);
        JobDetailImpl jobDetail = new JobDetailImpl("Delayed_Asynchronous_Call-" + Math.random(), "Delayed_Asynchronous_Call", MessageServiceExecutorJob.class);
        jobDetail.setJobDataMap(jobData);
        SimpleTriggerImpl trigger = new SimpleTriggerImpl("Delayed_Asynchronous_Call_Trigger-" + Math.random(), "Delayed_Asynchronous_Call", (Date)message.getQueueDate());
        trigger.setJobDataMap(jobData);
        scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
    }

    public Object getTarget() {
        return this.endpoints;
    }
}

