/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;

public abstract class RrdBackend {
    private static boolean instanceCreated = false;
    private String path;

    protected RrdBackend(String path) {
        this.path = path;
        instanceCreated = true;
    }

    public String getPath() {
        return this.path;
    }

    protected abstract void write(long var1, byte[] var3) throws IOException;

    protected abstract void read(long var1, byte[] var3) throws IOException;

    public abstract long getLength() throws IOException;

    protected abstract void setLength(long var1) throws IOException;

    public void close() throws IOException {
    }

    protected boolean isCachingAllowed() {
        return true;
    }

    public final byte[] readAll() throws IOException {
        byte[] b = new byte[(int)this.getLength()];
        this.read(0L, b);
        return b;
    }

    final void writeInt(long offset, int value) throws IOException {
        this.write(offset, RrdBackend.getIntBytes(value));
    }

    final void writeLong(long offset, long value) throws IOException {
        this.write(offset, RrdBackend.getLongBytes(value));
    }

    final void writeDouble(long offset, double value) throws IOException {
        this.write(offset, RrdBackend.getDoubleBytes(value));
    }

    final void writeDouble(long offset, double value, int count) throws IOException {
        byte[] b = RrdBackend.getDoubleBytes(value);
        byte[] image = new byte[8 * count];
        int i = 0;
        int k = 0;
        while (i < count) {
            image[k++] = b[0];
            image[k++] = b[1];
            image[k++] = b[2];
            image[k++] = b[3];
            image[k++] = b[4];
            image[k++] = b[5];
            image[k++] = b[6];
            image[k++] = b[7];
            ++i;
        }
        this.write(offset, image);
    }

    final void writeDouble(long offset, double[] values) throws IOException {
        int count = values.length;
        byte[] image = new byte[8 * count];
        int i = 0;
        int k = 0;
        while (i < count) {
            byte[] b = RrdBackend.getDoubleBytes(values[i]);
            image[k++] = b[0];
            image[k++] = b[1];
            image[k++] = b[2];
            image[k++] = b[3];
            image[k++] = b[4];
            image[k++] = b[5];
            image[k++] = b[6];
            image[k++] = b[7];
            ++i;
        }
        this.write(offset, image);
    }

    final void writeString(long offset, String value) throws IOException {
        value = value.trim();
        byte[] b = new byte[40];
        int i = 0;
        int k = 0;
        while (i < 20) {
            char c = i < value.length() ? (char)value.charAt(i) : (char)' ';
            byte[] cb = RrdBackend.getCharBytes(c);
            b[k++] = cb[0];
            b[k++] = cb[1];
            ++i;
        }
        this.write(offset, b);
    }

    final int readInt(long offset) throws IOException {
        byte[] b = new byte[4];
        this.read(offset, b);
        return RrdBackend.getInt(b);
    }

    final long readLong(long offset) throws IOException {
        byte[] b = new byte[8];
        this.read(offset, b);
        return RrdBackend.getLong(b);
    }

    final double readDouble(long offset) throws IOException {
        byte[] b = new byte[8];
        this.read(offset, b);
        return RrdBackend.getDouble(b);
    }

    final double[] readDouble(long offset, int count) throws IOException {
        int byteCount = 8 * count;
        byte[] image = new byte[byteCount];
        this.read(offset, image);
        double[] values = new double[count];
        int i = 0;
        int k = -1;
        while (i < count) {
            byte[] b = new byte[]{image[++k], image[++k], image[++k], image[++k], image[++k], image[++k], image[++k], image[++k]};
            values[i] = RrdBackend.getDouble(b);
            ++i;
        }
        return values;
    }

    final String readString(long offset) throws IOException {
        byte[] b = new byte[40];
        char[] c = new char[20];
        this.read(offset, b);
        int i = 0;
        int k = -1;
        while (i < 20) {
            byte[] cb = new byte[]{b[++k], b[++k]};
            c[i] = RrdBackend.getChar(cb);
            ++i;
        }
        return new String(c).trim();
    }

    private static byte[] getIntBytes(int value) {
        byte[] b = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return b;
    }

    private static byte[] getLongBytes(long value) {
        byte[] b = new byte[]{(byte)((int)(value >>> 56) & 0xFF), (byte)((int)(value >>> 48) & 0xFF), (byte)((int)(value >>> 40) & 0xFF), (byte)((int)(value >>> 32) & 0xFF), (byte)((int)(value >>> 24) & 0xFF), (byte)((int)(value >>> 16) & 0xFF), (byte)((int)(value >>> 8) & 0xFF), (byte)((int)value & 0xFF)};
        return b;
    }

    private static byte[] getCharBytes(char value) {
        byte[] b = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return b;
    }

    private static byte[] getDoubleBytes(double value) {
        return RrdBackend.getLongBytes(Double.doubleToLongBits(value));
    }

    private static int getInt(byte[] b) {
        assert (b.length == 4) : "Invalid number of bytes for integer conversion";
        return (b[0] << 24 & 0xFF000000) + (b[1] << 16 & 0xFF0000) + (b[2] << 8 & 0xFF00) + (b[3] & 0xFF);
    }

    private static long getLong(byte[] b) {
        assert (b.length == 8) : "Invalid number of bytes for long conversion";
        int high = RrdBackend.getInt(new byte[]{b[0], b[1], b[2], b[3]});
        int low = RrdBackend.getInt(new byte[]{b[4], b[5], b[6], b[7]});
        return ((long)high << 32) + ((long)low & 0xFFFFFFFFL);
    }

    private static char getChar(byte[] b) {
        assert (b.length == 2) : "Invalid number of bytes for char conversion";
        return (char)((b[0] << 8 & 0xFF00) + (b[1] & 0xFF));
    }

    private static double getDouble(byte[] b) {
        assert (b.length == 8) : "Invalid number of bytes for double conversion";
        return Double.longBitsToDouble(RrdBackend.getLong(b));
    }

    static boolean isInstanceCreated() {
        return instanceCreated;
    }
}

