/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieProject
implements KieProject {
    private static final Logger log = LoggerFactory.getLogger(KieProject.class);
    protected final Map<String, KieBaseModel> kBaseModels = new HashMap<String, KieBaseModel>();
    private KieBaseModel defaultKieBase = null;
    private KieSessionModel defaultKieSession = null;
    private KieSessionModel defaultStatelessKieSession = null;
    private Map<KieBaseModel, Set<String>> includesInKieBase = new HashMap<KieBaseModel, Set<String>>();
    private final Map<String, KieSessionModel> kSessionModels = new HashMap<String, KieSessionModel>();

    @Override
    public ResultsImpl verify() {
        ResultsImpl messages = new ResultsImpl();
        this.verify(messages);
        return messages;
    }

    @Override
    public ResultsImpl verify(String ... kBaseNames) {
        ResultsImpl messages = new ResultsImpl();
        this.verify(kBaseNames, messages);
        return messages;
    }

    @Override
    public void verify(ResultsImpl messages) {
        for (KieBaseModel model : this.kBaseModels.values()) {
            this.buildKnowledgePackages((KieBaseModelImpl)model, messages);
        }
    }

    public void verify(String[] kBaseNames, ResultsImpl messages) {
        for (String modelName : kBaseNames) {
            KieBaseModelImpl kieBaseModel = (KieBaseModelImpl)this.kBaseModels.get(modelName);
            if (kieBaseModel == null) {
                throw new RuntimeException("Unknown KieBase. Cannot find a KieBase named: " + modelName);
            }
            this.buildKnowledgePackages(kieBaseModel, messages);
        }
    }

    @Override
    public KieBaseModel getDefaultKieBaseModel() {
        return this.defaultKieBase;
    }

    @Override
    public KieSessionModel getDefaultKieSession() {
        return this.defaultKieSession;
    }

    @Override
    public KieSessionModel getDefaultStatelessKieSession() {
        return this.defaultStatelessKieSession;
    }

    @Override
    public KieBaseModel getKieBaseModel(String kBaseName) {
        return kBaseName == null ? this.getDefaultKieBaseModel() : this.kBaseModels.get(kBaseName);
    }

    @Override
    public Collection<String> getKieBaseNames() {
        return this.kBaseModels.keySet();
    }

    @Override
    public KieSessionModel getKieSessionModel(String kSessionName) {
        return kSessionName == null ? this.getDefaultKieSession() : this.kSessionModels.get(kSessionName);
    }

    void indexParts(InternalKieModule mainKieModule, Collection<InternalKieModule> depKieModules, Map<String, InternalKieModule> kJarFromKBaseName) {
        for (InternalKieModule kJar : depKieModules) {
            this.indexKieModule(kJarFromKBaseName, kJar, false);
        }
        if (mainKieModule != null) {
            this.indexKieModule(kJarFromKBaseName, mainKieModule, true);
        }
    }

    private void indexKieModule(Map<String, InternalKieModule> kJarFromKBaseName, InternalKieModule kJar, boolean isMainModule) {
        boolean defaultKieBaseFromMain = false;
        boolean defaultKieSessionFromMain = false;
        boolean defaultStatelessKieSessionFromMain = false;
        KieModuleModel kieProject = kJar.getKieModuleModel();
        for (KieBaseModel kieBaseModel : kieProject.getKieBaseModels().values()) {
            if (kieBaseModel.isDefault()) {
                if (this.defaultKieBase == null || isMainModule && !defaultKieBaseFromMain) {
                    this.defaultKieBase = kieBaseModel;
                    defaultKieBaseFromMain = isMainModule;
                } else {
                    this.defaultKieBase = null;
                    log.warn("Found more than one default KieBase: disabling all. KieBases will be accessible only by name");
                }
            }
            this.kBaseModels.put(kieBaseModel.getName(), kieBaseModel);
            ((KieBaseModelImpl)kieBaseModel).setKModule(kieProject);
            kJarFromKBaseName.put(kieBaseModel.getName(), kJar);
            for (KieSessionModel kieSessionModel : kieBaseModel.getKieSessionModels().values()) {
                if (kieSessionModel.isDefault()) {
                    if (kieSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
                        if (this.defaultKieSession == null || isMainModule && !defaultKieSessionFromMain) {
                            this.defaultKieSession = kieSessionModel;
                            defaultKieSessionFromMain = isMainModule;
                        } else {
                            this.defaultKieSession = null;
                            log.warn("Found more than one default KieSession: disabling all. KieSessions will be accessible only by name");
                        }
                    } else if (this.defaultStatelessKieSession == null || isMainModule && !defaultStatelessKieSessionFromMain) {
                        this.defaultStatelessKieSession = kieSessionModel;
                        defaultStatelessKieSessionFromMain = isMainModule;
                    } else {
                        this.defaultStatelessKieSession = null;
                        log.warn("Found more than one default StatelessKieSession: disabling all. StatelessKieSessions will be accessible only by name");
                    }
                }
                ((KieSessionModelImpl)kieSessionModel).setKBase(kieBaseModel);
                this.kSessionModels.put(kieSessionModel.getName(), kieSessionModel);
            }
        }
    }

    void cleanIndex() {
        this.kBaseModels.clear();
        this.kSessionModels.clear();
        this.includesInKieBase.clear();
        this.defaultKieBase = null;
        this.defaultKieSession = null;
        this.defaultStatelessKieSession = null;
    }

    @Override
    public Set<String> getTransitiveIncludes(String kBaseName) {
        return this.getTransitiveIncludes(this.getKieBaseModel(kBaseName));
    }

    @Override
    public Set<String> getTransitiveIncludes(KieBaseModel kBaseModel) {
        Set<String> includes = this.includesInKieBase.get(kBaseModel);
        if (includes == null) {
            includes = new HashSet<String>();
            this.getTransitiveIncludes(kBaseModel, includes);
            this.includesInKieBase.put(kBaseModel, includes);
        }
        return includes;
    }

    private void getTransitiveIncludes(KieBaseModel kBaseModel, Set<String> includes) {
        if (kBaseModel == null) {
            return;
        }
        Set<String> incs = ((KieBaseModelImpl)kBaseModel).getIncludes();
        if (incs != null && !incs.isEmpty()) {
            for (String inc : incs) {
                if (includes.contains(inc)) continue;
                includes.add(inc);
                this.getTransitiveIncludes(this.getKieBaseModel(inc), includes);
            }
        }
    }

    @Override
    public KnowledgeBuilder buildKnowledgePackages(KieBaseModelImpl kBaseModel, ResultsImpl messages) {
        InternalKieModule kModule = this.getKieModuleForKBase(kBaseModel.getName());
        KnowledgeBuilder kbuilder = this.createKnowledgeBuilder(kBaseModel, kModule);
        if (kbuilder == null) {
            return null;
        }
        HashSet<Asset> assets = new HashSet<Asset>();
        boolean allIncludesAreValid = true;
        for (String include : this.getTransitiveIncludes(kBaseModel)) {
            if (StringUtils.isEmpty((CharSequence)include)) continue;
            InternalKieModule includeModule = this.getKieModuleForKBase(include);
            if (includeModule == null) {
                String text = "Unable to build KieBase, could not find include: " + include;
                log.error(text);
                messages.addMessage(Message.Level.ERROR, "src/main/resources/META-INF/kmodule.xml", text).setKieBaseName(kBaseModel.getName());
                allIncludesAreValid = false;
                continue;
            }
            if (!this.compileIncludedKieBases()) continue;
            AbstractKieProject.addFiles(assets, this.getKieBaseModel(include), includeModule);
        }
        if (!allIncludesAreValid) {
            return null;
        }
        AbstractKieProject.addFiles(assets, kBaseModel, kModule);
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        if (assets.isEmpty()) {
            if (kModule instanceof FileKieModule) {
                log.warn("No files found for KieBase " + kBaseModel.getName() + ", searching folder " + kModule.getFile());
            } else {
                log.warn("No files found for KieBase " + kBaseModel.getName());
            }
        } else {
            for (Asset asset : assets) {
                asset.kmodule.addResourceToCompiler(ckbuilder, kBaseModel, asset.name);
            }
        }
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                messages.addMessage((KnowledgeBuilderResult)error).setKieBaseName(kBaseModel.getName());
            }
            log.error("Unable to build KieBaseModel:" + kBaseModel.getName() + "\n" + kbuilder.getErrors().toString());
        }
        if (kbuilder.hasResults(new ResultSeverity[]{ResultSeverity.WARNING})) {
            for (KnowledgeBuilderResult warn : kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING})) {
                messages.addMessage(warn).setKieBaseName(kBaseModel.getName());
            }
            log.warn("Warning : " + kBaseModel.getName() + "\n" + kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING}).toString());
        }
        kModule.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), kbuilder);
        kModule.cacheResultsForKieBase(kBaseModel.getName(), messages);
        return kbuilder;
    }

    protected boolean compileIncludedKieBases() {
        return true;
    }

    protected KnowledgeBuilder createKnowledgeBuilder(KieBaseModelImpl kBaseModel, InternalKieModule kModule) {
        return KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.getBuilderConfiguration(kBaseModel, kModule));
    }

    private static void addFiles(Set<Asset> assets, KieBaseModel kieBaseModel, InternalKieModule kieModule) {
        for (String fileName : kieModule.getFileNames()) {
            if (fileName.startsWith(".") || fileName.endsWith(".properties") || !KieBuilderImpl.filterFileInKBase(kieModule, kieBaseModel, fileName)) continue;
            assets.add(new Asset(kieModule, fileName));
        }
    }

    protected KnowledgeBuilderConfigurationImpl getBuilderConfiguration(KieBaseModelImpl kBaseModel, InternalKieModule kModule) {
        KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(this.getClassLoader());
        pconf.setCompilationCache(kModule.getCompilationCache(kBaseModel.getName()));
        AbstractKieModule.setModelPropsOnConf(kBaseModel, pconf);
        return pconf;
    }

    private static class Asset {
        private final InternalKieModule kmodule;
        private final String name;

        private Asset(InternalKieModule kmodule, String name) {
            this.kmodule = kmodule;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Asset asset = (Asset)o;
            return this.kmodule.equals(asset.kmodule) && this.name.equals(asset.name);
        }

        public int hashCode() {
            int result = this.kmodule.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

