/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.nonpersonnel;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.calculator.ValidCalcType;
import org.kuali.coeus.common.budget.framework.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ValidCalcTypeMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private final BusinessObjectService boService;

    public ValidCalcTypeMaintenanceDocumentRule() {
        this(KcServiceLocator.getService(BusinessObjectService.class));
    }

    ValidCalcTypeMaintenanceDocumentRule(BusinessObjectService boService) {
        this.boService = boService;
    }

    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    private boolean checkExistence(MaintenanceDocument maintenanceDocument) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass());
        }
        ValidCalcType validCalcType = (ValidCalcType)maintenanceDocument.getNewMaintainableObject().getDataObject();
        boolean valid = this.validateRateTypeCode(validCalcType.getRateClassCode(), validCalcType.getRateTypeCode());
        valid &= this.validateRateClassType(validCalcType.getRateClassType());
        return valid &= this.validateDependantRateClassType(validCalcType.getDependentRateClassType());
    }

    private boolean validateRateClassType(String rateClassType) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", rateClassType);
        return this.checkExistenceFromTable(RateClassType.class, pkMap, "code", "Rate Class Type");
    }

    private boolean validateDependantRateClassType(String dependantRateClassType) {
        if (StringUtils.isNotBlank((CharSequence)dependantRateClassType)) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("code", dependantRateClassType);
            return this.checkExistenceFromTable(RateClassType.class, pkMap, "dependentRateClassType", "Dependent Rate Class Type");
        }
        return true;
    }

    private boolean validateRateTypeCode(String rateClassCode, String rateTypeCode) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)rateClassCode) && StringUtils.isNotBlank((CharSequence)rateTypeCode)) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("rateClassCode", rateClassCode);
            pkMap.put("rateTypeCode", rateTypeCode);
            RateType rateType = (RateType)this.boService.findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{rateClassCode, rateTypeCode});
                valid = false;
            }
        }
        return valid;
    }
}

