/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import java.sql.Date;
import org.kuali.coeus.common.committee.impl.rule.event.CommitteeScheduleFilterEvent;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;

public class CommitteeScheduleFilterDatesRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<CommitteeScheduleFilterEvent> {
    public static final String SCHEDULEDATE_FILTERSTARTDATE = "committeeHelper.scheduleData.filterStartDate";
    public static final String SCHEDULEDATE_FILTERENDDATE = "committeeHelper.scheduleData.filerEndDate";
    public static final String[] MSG = new String[]{"Start date", "End date"};

    @Override
    public boolean processRules(CommitteeScheduleFilterEvent filterCommitteeScheduleEvent) {
        boolean rulePassed = true;
        Date startDate = filterCommitteeScheduleEvent.getScheduleData().getFilterStartDate();
        Date endDate = filterCommitteeScheduleEvent.getScheduleData().getFilerEndDate();
        if (null == startDate) {
            this.reportError(SCHEDULEDATE_FILTERSTARTDATE, "error.committeeSchedule.filter.date", MSG[0]);
            rulePassed = false;
        }
        if (null == endDate) {
            this.reportError(SCHEDULEDATE_FILTERENDDATE, "error.committeeSchedule.filter.date", MSG[1]);
            rulePassed = false;
        }
        if (rulePassed && startDate.toString().equals(endDate.toString())) {
            this.reportError(SCHEDULEDATE_FILTERENDDATE, "error.committeeSchedule.start.and.endDate.equal", new String[0]);
            rulePassed = false;
        }
        if (rulePassed && startDate.after(endDate)) {
            this.reportError(SCHEDULEDATE_FILTERENDDATE, "error.committeeSchedule.start.and.endDate", new String[0]);
            rulePassed = false;
        }
        return rulePassed;
    }
}

