/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.costshare;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.costshare.CostShareService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="costShareService")
public class CostShareServiceImpl
implements CostShareService {
    private static final String PARAM_LABEL_NAME = "CostShareProjectPeriodNameLabel";
    private static final String STANDARD_COST_SHARE_LABEL_FISCAL_YEAR = "Fiscal Year";
    private static final String STANDARD_COST_SHARE_LABEL_PROJECT_PERIOD = "Project Period";
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public String getCostShareLabel() {
        return this.getParameterService().getParameterValueAsString("KC-GEN", "All", PARAM_LABEL_NAME);
    }

    @Override
    public boolean validateProjectPeriodAsFiscalYear() {
        boolean retVal = StringUtils.equalsIgnoreCase((CharSequence)STANDARD_COST_SHARE_LABEL_FISCAL_YEAR, (CharSequence)this.getCostShareLabel());
        return retVal;
    }

    @Override
    public boolean validateProjectPeriodAsProjectPeriod() {
        boolean retVal = StringUtils.equalsIgnoreCase((CharSequence)STANDARD_COST_SHARE_LABEL_PROJECT_PERIOD, (CharSequence)this.getCostShareLabel());
        return retVal;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

