/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.shortUrl;

import java.util.Properties;
import org.kuali.coeus.common.framework.shortUrl.ResourceNotFoundException;
import org.kuali.coeus.common.framework.shortUrl.ShortUrlDao;
import org.kuali.coeus.common.framework.shortUrl.ShortUrlService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="shortUrlService")
public class ShortUrlServiceImpl
implements ShortUrlService {
    public static final String DOC_ID = "docId";
    public static final String COMMAND = "command";
    public static final String DISPLAY_DOC_SEARCH_VIEW = "displayDocSearchView";
    public static final String VIEW_DOCUMENT = "viewDocument";
    public static final String TRUE = "true";
    public static final String VIEW_ID = "viewId";
    public static final String HREF = "href";
    public static final String RETURN_LOCATION = "returnLocation";
    public static final String METHOD_TO_CALL = "methodToCall";
    public static final String START = "start";
    public static final String KC_KRAD_LANDING_PAGE = "/kc-krad/landingPage";
    public static final String KC_HEADER_IFRAME_VIEW = "Kc-Header-IframeView";
    public static final String KC_LANDING_PAGE_REDIRECT_VIEW = "Kc-LandingPage-RedirectView";
    public static final String TOP = "_TOP";
    public static final String DOC_SEARCH_TARGET = "DOC_SEARCH_TARGET";
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="shortUrlDao")
    private ShortUrlDao shortUrlDao;

    @Override
    public String constructUrl(String docId) throws ResourceNotFoundException {
        try {
            DocumentType documentType = this.getRouteHeaderService().getRouteHeader(docId).getDocumentType();
            if (TOP.equalsIgnoreCase(documentType.getDocSearchTarget().getPolicyStringValue())) {
                return this.constructUrl(documentType.getResolvedDocumentHandlerUrl(), docId);
            }
            return this.constructIframeUrl(documentType.getResolvedDocumentHandlerUrl(), docId);
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @Override
    public String constructUrl(String id, String table, String column) throws ResourceNotFoundException {
        return this.constructUrl(this.getShortUrlDao().getDocId(id, table, column));
    }

    @Override
    public String constructUrlByVersionStatus(String id, String table, String column) throws ResourceNotFoundException {
        return this.constructUrl(this.getShortUrlDao().getDocIdByVersionStatus(id, table, column));
    }

    @Override
    public String constructUrlByVersionHistory(String id, String table, String column) throws ResourceNotFoundException {
        return this.constructUrl(this.getShortUrlDao().getDocIdByVersionHistory(id, table, column));
    }

    @Override
    public String constructUrlByMaxSequenceNumber(String id, String table, String column) throws ResourceNotFoundException {
        return this.constructUrl(this.getShortUrlDao().getDocIdByMaxSequenceNumber(id, table, column));
    }

    private String constructUrl(String baseUrl, String id) {
        Properties parameters = new Properties();
        parameters.put(DOC_ID, id);
        parameters.put(COMMAND, DISPLAY_DOC_SEARCH_VIEW);
        parameters.put(VIEW_DOCUMENT, TRUE);
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }

    public String constructIframeUrl(String baseUrl, String id) {
        Properties parameters = new Properties();
        parameters.put(HREF, this.constructUrl(baseUrl, id));
        parameters.put(RETURN_LOCATION, this.getRedirectViewUrl());
        parameters.put(METHOD_TO_CALL, START);
        return UrlFactory.parameterizeUrl((String)this.getIframeViewUrl(), (Properties)parameters);
    }

    protected String getLandingPageUrl() {
        return this.getConfigurationService().getPropertyValueAsString("application.url") + KC_KRAD_LANDING_PAGE;
    }

    protected String getIframeViewUrl() {
        Properties parameters = new Properties();
        parameters.put(VIEW_ID, KC_HEADER_IFRAME_VIEW);
        return UrlFactory.parameterizeUrl((String)this.getLandingPageUrl(), (Properties)parameters);
    }

    protected String getRedirectViewUrl() {
        Properties parameters = new Properties();
        parameters.put(VIEW_ID, KC_LANDING_PAGE_REDIRECT_VIEW);
        return UrlFactory.parameterizeUrl((String)this.getLandingPageUrl(), (Properties)parameters);
    }

    public RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ShortUrlDao getShortUrlDao() {
        return this.shortUrlDao;
    }

    public void setShortUrlDao(ShortUrlDao shortUrlDao) {
        this.shortUrlDao = shortUrlDao;
    }
}

