/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.krms;

import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.AppointmentType;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.person.attr.PersonAppointment;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.impl.krms.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.krms.PropDevJavaFunctionKrmsTermService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="propDevJavaFunctionKrmsTermService")
public class PropDevJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements PropDevJavaFunctionKrmsTermService {
    private static final int INT_U_S_CITIZEN_OR_NONCITIZEN_NATIONAL = 1;
    private static final int INT_PERMANENT_RESIDENT_OF_U_S = 2;
    private static final int INT_NON_U_S_CITIZEN_WITH_TEMPORARY_VISA = 3;
    private static final int INT_PERMANENT_RESIDENT_OF_U_S_PENDING = 4;
    private static final Logger LOG = LogManager.getLogger(PropDevJavaFunctionKrmsTermServiceImpl.class);
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="proposalTypeService")
    private ProposalTypeService proposalTypeService;

    @Override
    public Boolean specifiedGGForm(DevelopmentProposal developmentProposal, String formNames) {
        for (String formName : this.buildArrayFromCommaList(formNames)) {
            for (S2sOppForms s2sOppForm : developmentProposal.getS2sOppForms()) {
                if (s2sOppForm.getInclude() == null || !s2sOppForm.getInclude().booleanValue() || !s2sOppForm.getFormName().equals(formName.trim())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public String multiplePI(DevelopmentProposal developmentProposal) {
        List<ProposalPerson> people = developmentProposal.getProposalPersons();
        for (ProposalPerson person : people) {
            if (!person.isMultiplePi()) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String s2sHumanSubjectExists(DevelopmentProposal developmentProposal) {
        return developmentProposal.hasS2sOpportunity() && developmentProposal.getPropSpecialReviews().stream().map(SpecialReview::getSpecialReviewTypeCode).anyMatch("1"::equals) ? "true" : "false";
    }

    @Override
    public String s2sBudgetRule(DevelopmentProposal developmentProposal, String formNames) {
        int li_count_s2s;
        String[] formNamesArray = this.buildArrayFromCommaList(formNames);
        int li_count_bud = 0;
        for (String formName : formNamesArray) {
            for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)formName, (CharSequence)form.getFormName()) || !form.getInclude().booleanValue()) continue;
                ++li_count_bud;
            }
        }
        int n = li_count_s2s = developmentProposal.hasS2sOpportunity() ? 1 : 0;
        if (li_count_bud != 0 && li_count_s2s <= 0) {
            return "true";
        }
        return "false";
    }

    @Override
    public String monitoredSponsorRule(DevelopmentProposal developmentProposal, String monitoredSponsorHierarchies) {
        String[] sponsoredHierarchyArray = this.buildArrayFromCommaList(monitoredSponsorHierarchies);
        ArrayList hierarchies = new ArrayList();
        for (String hierarchyName : sponsoredHierarchyArray) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("hierarchyName", hierarchyName);
            hierarchies.addAll(this.getBusinessObjectService().findMatching(SponsorHierarchy.class, fieldValues));
        }
        for (SponsorHierarchy sh : hierarchies) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)sh.getSponsorCode(), (CharSequence)developmentProposal.getSponsor().getSponsorCode()) && (developmentProposal.getPrimeSponsor() == null || !StringUtils.equalsIgnoreCase((CharSequence)sh.getSponsorCode(), (CharSequence)developmentProposal.getPrimeSponsor().getSponsorCode()))) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String s2sResplanRule(DevelopmentProposal developmentProposal, String narativeTypes, String maxNumber) {
        String[] narrativeTypesArray = this.buildArrayFromCommaList(narativeTypes);
        int[] narrativeCounts = new int[narrativeTypesArray.length];
        int maxNumberInt = Integer.parseInt(maxNumber);
        for (Narrative narrative : developmentProposal.getNarratives()) {
            int narrativePosition = 0;
            for (String narrativeType : narrativeTypesArray) {
                if (StringUtils.equalsIgnoreCase((CharSequence)narrativeType, (CharSequence)narrative.getNarrativeType().getDescription())) {
                    int n = narrativePosition;
                    narrativeCounts[n] = narrativeCounts[n] + 1;
                    if (narrativeCounts[narrativePosition] > maxNumberInt) {
                        return "true";
                    }
                }
                ++narrativePosition;
            }
        }
        return "false";
    }

    @Override
    public String grantsFormRule(DevelopmentProposal developmentProposal, String formName) {
        for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)formName, (CharSequence)form.getFormName())) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String biosketchFileNameRule(DevelopmentProposal developmentProposal) {
        for (ProposalPersonBiography ppb : developmentProposal.getPropPersonBios()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ppb.getPropPerDocType().getDescription(), (CharSequence)"Biosketch") || !StringUtils.equals((CharSequence)"false", (CharSequence)this.specialCharacterRule(ppb.getName()))) continue;
            return "false";
        }
        return "true";
    }

    @Override
    public String ospAdminPropPersonRule(DevelopmentProposal developmentProposal) {
        List<UnitAdministrator> ospAdmins = developmentProposal.getUnit().getUnitAdministrators();
        if (ospAdmins != null && ospAdmins.size() > 0) {
            for (ProposalPerson person : developmentProposal.getProposalPersons()) {
                for (UnitAdministrator admin : ospAdmins) {
                    if (!StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)admin.getPersonId())) continue;
                    return "true";
                }
            }
        }
        return "false";
    }

    @Override
    public String costElementVersionLimit(DevelopmentProposal developmentProposal, String versionNumber, String costElementName, String limit) {
        Long versionNumberLong = Long.parseLong(versionNumber);
        float limitLong = Float.parseFloat(limit);
        for (Budget budget : developmentProposal.getBudgets()) {
            if (!budget.getVersionNumber().equals(versionNumberLong)) continue;
            try {
                if (!budget.getVersionNumber().equals(versionNumberLong)) continue;
                for (BudgetPeriod period : budget.getBudgetPeriods()) {
                    float costElementTotal = 0.0f;
                    for (BudgetLineItem item : period.getBudgetLineItems()) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)costElementName, (CharSequence)item.getCostElementName())) continue;
                        costElementTotal += item.getLineItemCost().floatValue();
                    }
                    if (!(costElementTotal > limitLong)) continue;
                    return "true";
                }
            }
            catch (Exception exception) {
            }
        }
        return "false";
    }

    @Override
    public String divisionCodeRule(DevelopmentProposal developmentProposal) {
        return StringUtils.isEmpty((CharSequence)developmentProposal.getAgencyDivisionCode()) ? "true" : "false";
    }

    @Override
    public String divisionCodeIsFellowship(DevelopmentProposal developmentProposal, String fellowshipCodes) {
        String[] fellowShipCodeArray;
        for (String code : fellowShipCodeArray = this.buildArrayFromCommaList(fellowshipCodes)) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)developmentProposal.getActivityTypeCode())) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String budgetSubawardOrganizationnameRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getFinalBudget() != null) {
            for (BudgetSubAwards bsa : developmentProposal.getFinalBudget().getBudgetSubAwards()) {
                if (!StringUtils.equals((CharSequence)"false", (CharSequence)this.specialCharacterRule(bsa.getOrganizationName()))) continue;
                return "false";
            }
        }
        return "true";
    }

    @Override
    public String checkProposalPerson(DevelopmentProposal developmentProposal, String personId) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            if (!StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)personId)) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String agencyProgramCodeNullRule(DevelopmentProposal developmentProposal) {
        return StringUtils.isEmpty((CharSequence)developmentProposal.getAgencyProgramCode()) ? "true" : "false";
    }

    @Override
    public String allProposalsRule(DevelopmentProposal developmentProposal) {
        return "true";
    }

    @Override
    public String proposalLeadUnitInHierarchy(DevelopmentProposal developmentProposal, String unitNumberToCheck) {
        if (StringUtils.equals((CharSequence)developmentProposal.getUnitNumber(), (CharSequence)unitNumberToCheck)) {
            return "true";
        }
        List<Unit> units = this.getUnitService().getAllSubUnits(unitNumberToCheck);
        if (units != null && units.size() > 0) {
            for (Unit unit : units) {
                if (!StringUtils.equals((CharSequence)developmentProposal.getUnitNumber(), (CharSequence)unit.getUnitNumber())) continue;
                return "true";
            }
        }
        return "false";
    }

    @Override
    public String s2sSubawardRule(DevelopmentProposal developmentProposal, String rrFormNames, String phsFromNames) {
        boolean foundRRforms = false;
        boolean foundPHSforms = false;
        String[] rrFormNamesArray = this.buildArrayFromCommaList(rrFormNames);
        String[] phsFromNamesArray = this.buildArrayFromCommaList(phsFromNames);
        for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
            if (!form.getInclude().booleanValue()) continue;
            for (String formName : rrFormNamesArray) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)formName, (CharSequence)form.getFormName())) continue;
                foundRRforms = true;
            }
            for (String formName : phsFromNamesArray) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)formName, (CharSequence)form.getFormName())) continue;
                foundPHSforms = true;
            }
        }
        return foundRRforms && foundPHSforms ? "true" : "false";
    }

    @Override
    public String proposalGrantsRule(DevelopmentProposal developmentProposal) {
        return developmentProposal.getS2sOpportunity() != null ? "true" : "false";
    }

    @Override
    public String narrativeTypeRule(DevelopmentProposal developmentProposal, String narrativeTypeCode) {
        ArrayList<Narrative> attachments = new ArrayList<Narrative>();
        attachments.addAll(developmentProposal.getNarratives());
        attachments.addAll(developmentProposal.getInstituteAttachments());
        for (Narrative narrative : attachments) {
            if (!narrative.getNarrativeTypeCode().equals(narrativeTypeCode)) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String activityTypeRule(DevelopmentProposal developmentProposal, String activityTypeCode) {
        if (StringUtils.equals((CharSequence)developmentProposal.getActivityTypeCode(), (CharSequence)activityTypeCode)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String attachmentFileNameRule(DevelopmentProposal developmentProposal) {
        for (Narrative narr : developmentProposal.getNarratives()) {
            for (String character : restrictedElements) {
                if (!StringUtils.containsIgnoreCase((CharSequence)narr.getName(), (CharSequence)character)) continue;
                return "false";
            }
        }
        return "true";
    }

    @Override
    public String checkProposalCoiRule(DevelopmentProposal developmentProposal, String principalId) {
        for (ProposalPerson person : developmentProposal.getInvestigators()) {
            if (!person.isInvestigator() || !person.isPrincipalInvestigator() || !StringUtils.equals((CharSequence)principalId, (CharSequence)person.getPersonId())) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String checkProposalPiRule(DevelopmentProposal developmentProposal, String principalId) {
        for (ProposalPerson person : developmentProposal.getInvestigators()) {
            if (!person.isInvestigator() || !person.isPrincipalInvestigator() || !StringUtils.equals((CharSequence)principalId, (CharSequence)person.getPersonId())) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String costElement(DevelopmentProposal developmentProposal, String costElement) {
        for (Budget budget : developmentProposal.getBudgets()) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("costElement", costElement);
            values.put("budgetId", budget.getBudgetId());
            List matchingLineItems = (List)this.getBusinessObjectService().findMatching(BudgetLineItem.class, values);
            if (matchingLineItems == null || matchingLineItems.isEmpty()) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String leadUnitBelowRule(DevelopmentProposal developmentProposal, String unitNumber) {
        if (StringUtils.equals((CharSequence)developmentProposal.getUnitNumber(), (CharSequence)unitNumber)) {
            return "true";
        }
        for (Unit unit : this.getUnitService().getAllSubUnits(unitNumber)) {
            if (!StringUtils.equals((CharSequence)unit.getUnitNumber(), (CharSequence)developmentProposal.getUnitNumber())) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String leadUnitRule(DevelopmentProposal developmentProposal, String unitNumber) {
        if (StringUtils.equals((CharSequence)developmentProposal.getUnitNumber(), (CharSequence)unitNumber)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String mtdcDeviation(DevelopmentProposal developmentProposal) {
        if (this.mtdcDeviationInBudget(developmentProposal.getFinalBudget())) {
            return "true";
        }
        return "false";
    }

    @Override
    public String mtdcDeviationInVersion(DevelopmentProposal developmentProposal, String versionNumber) {
        if (this.mtdcDeviationInBudget(this.getBudgetVersion(developmentProposal, versionNumber))) {
            return "true";
        }
        return "false";
    }

    protected Budget getBudgetVersion(DevelopmentProposal developmentProposal, String versionNumber) {
        Integer versionNumberLong = Integer.valueOf(versionNumber);
        for (Budget budget : developmentProposal.getBudgets()) {
            if (!budget.getBudgetVersionNumber().equals(versionNumberLong)) continue;
            return budget;
        }
        return null;
    }

    protected boolean mtdcDeviationInBudget(Budget budget) {
        return budget != null && StringUtils.equals((CharSequence)budget.getOhRateClassCode(), (CharSequence)"1");
    }

    @Override
    public String nonFacultyPi(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getPrincipalInvestigator() != null && developmentProposal.getPrincipalInvestigator().getFacultyFlag().booleanValue()) {
            return "false";
        }
        return "true";
    }

    @Override
    public String proposalAwardTypeRule(DevelopmentProposal developmentProposal, Integer awardTypeCode) {
        if (awardTypeCode.equals(developmentProposal.getAnticipatedAwardTypeCode())) {
            return "true";
        }
        return "false";
    }

    @Override
    public String proposalTypeRule(DevelopmentProposal developmentProposal, String proposalTypeCode) {
        if (StringUtils.equals((CharSequence)developmentProposal.getProposalTypeCode(), (CharSequence)proposalTypeCode)) {
            return "true";
        }
        return "false";
    }

    @Override
    public Boolean proposalTypeInRule(DevelopmentProposal developmentProposal, String proposalTypeCodes) {
        if (proposalTypeCodes != null) {
            return Stream.of(proposalTypeCodes.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).anyMatch(code -> code.equalsIgnoreCase(developmentProposal.getProposalTypeCode()));
        }
        return Boolean.FALSE;
    }

    public Boolean costShareTypeInBudgetCostShareRule(DevelopmentProposal developmentProposal, String costShareTypeCodes) {
        ProposalDevelopmentBudgetExt budget = developmentProposal.getFinalBudget();
        if (budget == null || costShareTypeCodes == null) {
            return Boolean.FALSE;
        }
        Set costShareTypesInBudget = budget.getBudgetCostShares().stream().map(budgetCostShare -> budgetCostShare.getCostShareTypeCode() != null ? budgetCostShare.getCostShareTypeCode().toString() : "").collect(Collectors.toSet());
        return Stream.of(costShareTypeCodes.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).anyMatch(costShareTypesInBudget::contains);
    }

    @Override
    public Boolean costShareUnitRule(DevelopmentProposal developmentProposal, String costShareUnits) {
        ProposalDevelopmentBudgetExt budget = developmentProposal.getFinalBudget();
        if (budget == null || costShareUnits == null) {
            return Boolean.FALSE;
        }
        Set costShareUnitsInBudget = budget.getBudgetCostShares().stream().map(budgetCostShare -> budgetCostShare.getUnitNumber() != null ? budgetCostShare.getUnitNumber() : "").collect(Collectors.toSet());
        return Stream.of(costShareUnits.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).anyMatch(costShareUnitsInBudget::contains);
    }

    @Override
    public Boolean costShareSourceAccountRule(DevelopmentProposal developmentProposal, String costShareSourceAccounts) {
        ProposalDevelopmentBudgetExt budget = developmentProposal.getFinalBudget();
        if (budget == null || costShareSourceAccounts == null) {
            return Boolean.FALSE;
        }
        Set costShareSourceAccountsInBudget = budget.getBudgetCostShares().stream().map(budgetCostShare -> budgetCostShare.getSourceAccount() != null ? budgetCostShare.getSourceAccount() : "").collect(Collectors.toSet());
        return Stream.of(costShareSourceAccounts.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).anyMatch(costShareSourceAccountsInBudget::contains);
    }

    @Override
    public String proposalUnitRule(DevelopmentProposal developmentProposal, String unitNumber) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            for (ProposalPersonUnit unit : person.getUnits()) {
                if (!StringUtils.equals((CharSequence)unit.getUnitNumber(), (CharSequence)unitNumber)) continue;
                return "true";
            }
        }
        return "false";
    }

    @Override
    public String s2sAttachmentNarrativeRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.hasS2sOpportunity()) {
            for (Narrative narrative : developmentProposal.getNarratives()) {
                if (!StringUtils.equals((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)"61") || narrative.getModuleTitle() != null) continue;
                return "false";
            }
        }
        return "true";
    }

    @Override
    public String s2sExemptionRule(DevelopmentProposal developmentProposal) {
        boolean irbLinkingEnabled = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "irb.protocol.development.proposal.linking.enabled");
        if (!irbLinkingEnabled) {
            for (ProposalSpecialReview specialReview : developmentProposal.getPropSpecialReviews()) {
                if (!"4".equals(specialReview.getApprovalTypeCode()) || !"1".equals(specialReview.getSpecialReviewTypeCode()) || specialReview.getComments() != null && specialReview.getComments().matches("\\w*E[1-6](\\w*,\\w*E[1-6])*[\\w,]*")) continue;
                return "false";
            }
        }
        return "true";
    }

    @Override
    public String s2sFederalIdRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.hasS2sOpportunity()) {
            String renewalType = this.getProposalTypeService().getRenewProposalTypeCode();
            if (StringUtils.equals((CharSequence)developmentProposal.getProposalTypeCode(), (CharSequence)renewalType) && (StringUtils.isBlank((CharSequence)developmentProposal.getSponsorProposalNumber()) || !developmentProposal.getSponsorProposalNumber().matches("[a-zA-Z]{2}\\d{6}"))) {
                return "false";
            }
        }
        return "true";
    }

    @Override
    public String s2sLeadershipRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.hasS2sOpportunity()) {
            int piNumber = 0;
            for (ProposalPerson person : developmentProposal.getProposalPersons()) {
                if (!person.isMultiplePi()) continue;
                ++piNumber;
            }
            if (piNumber > 0) {
                int neededAttachmentCount = 0;
                for (Narrative narrative : developmentProposal.getNarratives()) {
                    if (!StringUtils.equals((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)"46") && !StringUtils.equals((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)"121")) continue;
                    ++neededAttachmentCount;
                }
                if (neededAttachmentCount < 1) {
                    return "false";
                }
            }
        }
        return "true";
    }

    @Override
    public String s2sModularBudgetRule(DevelopmentProposal developmentProposal) {
        List<String> allowedForms = Arrays.asList("PHS398 Modular Budget V1-1", "PHS398 Modular Budget V1-2");
        boolean s2sProp = developmentProposal.hasS2sOpportunity();
        ProposalDevelopmentBudgetExt finalBudgetVersion = developmentProposal.getFinalBudget();
        if (s2sProp && finalBudgetVersion != null && finalBudgetVersion.getModularBudgetFlag().booleanValue()) {
            int matchingForms = 0;
            for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
                if (!form.getInclude().booleanValue() || !allowedForms.contains(form.getFormName())) continue;
                ++matchingForms;
            }
            if (matchingForms == 0) {
                return "false";
            }
            return "true";
        }
        return "true";
    }

    @Override
    public String specialReviewRule(DevelopmentProposal developmentProposal, String specialReviewTypeCode) {
        for (ProposalSpecialReview review : developmentProposal.getPropSpecialReviews()) {
            if (!StringUtils.equals((CharSequence)review.getSpecialReviewTypeCode(), (CharSequence)specialReviewTypeCode)) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String sponsor(DevelopmentProposal developmentProposal, String sponsorCode) {
        if (StringUtils.equals((CharSequence)developmentProposal.getSponsorCode(), (CharSequence)sponsorCode)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String sponsorGroupRule(DevelopmentProposal developmentProposal, String sponsorGroup) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hierarchyName", "Routing");
        values.put("sponsorCode", developmentProposal.getSponsorCode());
        List hierarchies = (List)this.getBusinessObjectService().findMatching(SponsorHierarchy.class, values);
        if (hierarchies != null && !hierarchies.isEmpty() && StringUtils.equals((CharSequence)((SponsorHierarchy)hierarchies.get(0)).getLevel1(), (CharSequence)sponsorGroup)) {
            return "true";
        }
        values.put("sponsorCode", developmentProposal.getPrimeSponsorCode());
        hierarchies = (List)this.getBusinessObjectService().findMatching(SponsorHierarchy.class, values);
        if (hierarchies != null && !hierarchies.isEmpty() && StringUtils.equals((CharSequence)((SponsorHierarchy)hierarchies.get(0)).getLevel1(), (CharSequence)sponsorGroup)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String s2s398CoverRule(DevelopmentProposal developmentProposal, String PHSCoverLetters, String narrativeTypeCode) {
        if (developmentProposal.getS2sAppSubmission().size() > 0) {
            boolean foundNarrative = false;
            for (Narrative narrative : developmentProposal.getNarratives()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)narrativeTypeCode)) continue;
                foundNarrative = true;
            }
            if (foundNarrative) {
                String[] coverLetters = this.buildArrayFromCommaList(PHSCoverLetters);
                boolean foundForm = false;
                for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
                    for (String coverLetter : coverLetters) {
                        if (!StringUtils.equals((CharSequence)form.getFormName(), (CharSequence)coverLetter)) continue;
                        foundForm = true;
                    }
                }
                if (!foundForm) {
                    return "false";
                }
            }
        }
        return "true";
    }

    @Override
    public String narrativeFileName(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)narrative.getNarrativeType().getNarrativeTypeGroup(), (CharSequence)"P") && StringUtils.equals((CharSequence)"false", (CharSequence)this.specialCharacterRule(narrative.getName()))) {
                return "false";
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)"8") || !StringUtils.equals((CharSequence)"false", (CharSequence)this.specialCharacterRule(narrative.getModuleTitle()))) continue;
            return "false";
        }
        return "true";
    }

    @Override
    public String costElementInVersion(DevelopmentProposal developmentProposal, String versionNumber, String costElement) {
        Long versionNumberLong = Long.parseLong(versionNumber);
        for (Budget budget : developmentProposal.getBudgets()) {
            if (!budget.getVersionNumber().equals(versionNumberLong)) continue;
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                if (period.getBudgetLineItems().isEmpty()) continue;
                return "true";
            }
        }
        return "false";
    }

    @Override
    public String investigatorKeyPersonCertificationRule(DevelopmentProposal developmentProposal) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            ProposalPersonModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalPersonModuleQuestionnaireBean(developmentProposal, person);
            List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
            for (AnswerHeader ah : answerHeaders) {
                if (ah.isCompleted()) continue;
                return "false";
            }
        }
        return "true";
    }

    @Override
    public String sponsorTypeRule(DevelopmentProposal developmentProposal, String sponsorTypeCode) {
        if (StringUtils.equals((CharSequence)developmentProposal.getSponsor().getSponsorTypeCode(), (CharSequence)sponsorTypeCode)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String completeNarrativeRule(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (!StringUtils.equals((CharSequence)narrative.getModuleStatusCode(), (CharSequence)"I")) continue;
            return "false";
        }
        return "true";
    }

    @Override
    public String investigatorCitizenshipTypeRule(DevelopmentProposal developmentProposal, String citizenshipTypeToCheck) {
        String RETURN_VALUE = "false";
        ProposalPerson principalInvestigator = developmentProposal.getPrincipalInvestigator();
        int citizenType = citizenshipTypeToCheck != null ? (int)citizenshipTypeToCheck.charAt(0) : 48;
        Integer citizenshipTypeCode = principalInvestigator.getCitizenshipTypeCode();
        switch (citizenType) {
            case 65: {
                if (!citizenshipTypeCode.equals(3)) break;
                RETURN_VALUE = "true";
                break;
            }
            case 67: {
                if (!citizenshipTypeCode.equals(1)) break;
                RETURN_VALUE = "true";
                break;
            }
            case 78: {
                if (!citizenshipTypeCode.equals(2)) break;
                RETURN_VALUE = "true";
                break;
            }
            case 80: {
                if (!citizenshipTypeCode.equals(4)) break;
                RETURN_VALUE = "true";
                break;
            }
            default: {
                Collection citizenshipTypeParams = this.getParameterService().getParameterValuesAsString(ProposalDevelopmentDocument.class, "PROPOSAL_PI_CITIZENSHIP_TYPE");
                if (citizenshipTypeParams == null || !citizenshipTypeParams.contains(citizenshipTypeToCheck)) break;
                RETURN_VALUE = "true";
            }
        }
        return RETURN_VALUE;
    }

    @Override
    public String piAppointmentTypeRule(DevelopmentProposal developmentProposal) {
        List<ProposalPerson> people = developmentProposal.getProposalPersons();
        List appointmentTypes = (List)this.getBusinessObjectService().findAll(AppointmentType.class);
        for (ProposalPerson person : people) {
            if ((!person.isInvestigator() || !person.isPrincipalInvestigator()) && (!person.isMultiplePi() || person.getPerson() == null || person.getPerson().getExtendedAttributes() == null)) continue;
            List<PersonAppointment> appointments = person.getPerson().getExtendedAttributes().getPersonAppointments();
            for (PersonAppointment personAppointment : appointments) {
                if (!this.isAppointmentTypeEqualsJobTitle(appointmentTypes, personAppointment.getJobTitle())) continue;
                return "true";
            }
        }
        return "false";
    }

    private boolean isAppointmentTypeEqualsJobTitle(List<AppointmentType> appointmentTypes, String jobTitle) {
        for (AppointmentType appointmentType : appointmentTypes) {
            if (!appointmentType.getDescription().equalsIgnoreCase(jobTitle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String proposalCampusRule(DevelopmentProposal developmentProposal, String a2SCampusCode) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            for (ProposalPersonUnit unit : person.getUnits()) {
                if (!unit.isLeadUnit() || !StringUtils.equals((CharSequence)unit.getUnitNumber().substring(1, 3), (CharSequence)a2SCampusCode)) continue;
                return "true";
            }
        }
        return "false";
    }

    @Override
    public String routedToOSPRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getProposalDocument().getDocumentHeader().getWorkflowDocument().isApproved() || developmentProposal.getProposalDocument().getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            return "true";
        }
        return "false";
    }

    @Override
    public String isUserProposalPI(DevelopmentProposal developmentProposal) {
        Person loggedInUser = this.globalVariableService.getUserSession().getPerson();
        String principalId = loggedInUser.getPrincipalId();
        return this.checkProposalPiRule(developmentProposal, principalId);
    }

    @Override
    public String proposalUnitBelow(DevelopmentProposal developmentProposal, String unitNumberToCheck) {
        List<Unit> units = this.getUnitService().getAllSubUnits(unitNumberToCheck);
        if (units != null && units.size() > 0) {
            for (Unit unit : units) {
                for (ProposalPerson person : developmentProposal.getProposalPersons()) {
                    for (ProposalPersonUnit proposalUnit : person.getUnits()) {
                        if (!StringUtils.equals((CharSequence)proposalUnit.getUnitNumber(), (CharSequence)unit.getUnitNumber())) continue;
                        return "true";
                    }
                }
            }
        }
        return "false";
    }

    @Override
    public String usesRolodex(DevelopmentProposal developmentProposal, Integer rolodexId) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            if (person.getRolodexId() == null || !person.getRolodexId().equals(rolodexId)) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String competitionIdRule(DevelopmentProposal developmentProposal, String competitionId) {
        if (developmentProposal.getS2sOpportunity().getCompetitionId().equals(competitionId)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String specialReviewDateRule(DevelopmentProposal developmentProposal) {
        Date currentDate = this.getDateTimeService().getCurrentSqlDateMidnight();
        for (ProposalSpecialReview proposalSpecialReview : developmentProposal.getPropSpecialReviews()) {
            if (!proposalSpecialReview.getSpecialReviewTypeCode().equals("1") && !proposalSpecialReview.getSpecialReviewTypeCode().equals("2") || !proposalSpecialReview.getApplicationDate().after(currentDate)) continue;
            return "true";
        }
        return "false";
    }

    @Override
    public String deadlineDateRule(DevelopmentProposal developmentProposal, String deadlineDate) {
        try {
            Date checkDeadLineDate = this.getDateTimeService().convertToSqlDate(deadlineDate);
            if (developmentProposal.getDeadlineDate().before(checkDeadLineDate)) {
                return "true";
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return "false";
    }

    @Override
    public String routingSequenceRule(DevelopmentProposal developmentProposal) {
        List actionRequests = developmentProposal.getProposalDocument().getDocumentHeader().getWorkflowDocument().getDocumentDetail().getActionRequests();
        return actionRequests.stream().filter(actionRequest -> actionRequest.getActionTaken() != null).anyMatch(actionRequest -> actionRequest.getActionTaken().getActionTaken().equals((Object)ActionType.RETURN_TO_PREVIOUS)) ? "false" : "true";
    }

    @Override
    public String humanSubjectsSpecialReviewContainsPropertyValue(DevelopmentProposal developmentProposal, String propertyName, String propertyValue) {
        return developmentProposal.getPropSpecialReviews().stream().filter(specialReview -> "1".equals(specialReview.getSpecialReviewTypeCode())).anyMatch(specialReview -> {
            try {
                Object value = PropertyUtils.getProperty((Object)specialReview, (String)propertyName);
                if (NULL_VALUES.stream().anyMatch(nullValue -> nullValue.equalsIgnoreCase(propertyValue))) {
                    return value == null || StringUtils.isEmpty((CharSequence)String.valueOf(value));
                }
                return String.valueOf(value).equals(propertyValue);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error(String.format("Failed to access special review property '%s'", propertyName), (Throwable)e);
                return false;
            }
        }) ? "true" : "false";
    }

    @Override
    public Boolean performanceSiteLocationExists(DevelopmentProposal developmentProposal) {
        return !developmentProposal.getPerformanceSites().isEmpty();
    }

    @Override
    public Boolean otherOrganizationExists(DevelopmentProposal developmentProposal) {
        return !developmentProposal.getOtherOrganizations().isEmpty();
    }

    @Override
    public Boolean proposalPersonUnitBelowRule(DevelopmentProposal developmentProposal, String projectRole, String unitNumber) {
        List<ProposalPersonUnit> units = this.getProposalPersonUnit(developmentProposal, projectRole, unitNumber);
        if (CollectionUtils.isNotEmpty(units)) {
            boolean unitFound = this.isMatchingProposalPersonUnit(units, unitNumber);
            if (unitFound) {
                return true;
            }
            return this.getUnitService().getAllSubUnits(unitNumber).stream().filter(subUnit -> units.stream().anyMatch(personUnit -> personUnit.getUnitNumber().equals(subUnit.getUnitNumber()))).count() > 0L;
        }
        return false;
    }

    @Override
    public Boolean proposalPersonUnitRule(DevelopmentProposal developmentProposal, String projectRole, String unitNumber) {
        return this.isMatchingProposalPersonUnit(this.getProposalPersonUnit(developmentProposal, projectRole, unitNumber), unitNumber);
    }

    protected List<ProposalPersonUnit> getProposalPersonUnit(DevelopmentProposal developmentProposal, String projectRole, String unitNumber) {
        return developmentProposal.getProposalPersons().stream().filter(proposal -> projectRole.equals(proposal.getProposalPersonRoleId())).flatMap(person -> person.getUnits().stream()).collect(Collectors.toList());
    }

    protected boolean isMatchingProposalPersonUnit(List<ProposalPersonUnit> units, String unitNumber) {
        return units.stream().anyMatch(unit -> unitNumber.equals(unit.getUnitNumber()));
    }

    @Override
    public Boolean totalEffortExists(DevelopmentProposal developmentProposal) {
        return developmentProposal.getProposalPersons().stream().noneMatch(person -> person.getPercentageEffort() == null);
    }

    public Boolean abstractTypeRule(DevelopmentProposal developmentProposal, String abstractTypeCodes) {
        if (abstractTypeCodes == null) {
            return Boolean.FALSE;
        }
        Set abstractTypesInProposal = developmentProposal.getProposalAbstracts().stream().map(abstractType -> abstractType.getAbstractTypeCode() != null ? abstractType.getAbstractTypeCode() : "").collect(Collectors.toSet());
        return Stream.of(abstractTypeCodes.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).anyMatch(abstractTypesInProposal::contains);
    }

    @Override
    public Boolean specialReviewAndApprovalTypeRule(DevelopmentProposal developmentProposal, String specialReviewTypeCode, String approvalTypeCode) {
        List<ProposalSpecialReview> specialReviews = developmentProposal.getPropSpecialReviews();
        return this.specialReviewTypeCodeAndApprovalTypeCodeMatch(specialReviews, specialReviewTypeCode, approvalTypeCode);
    }

    @Override
    public Boolean personPIEligibleRule(DevelopmentProposal developmentProposal, String pIEligibleCode, String personRoleCode) {
        List<ProposalPerson> proposalPersons = developmentProposal.getProposalPersons();
        return proposalPersons.stream().filter(proposalPerson -> personRoleCode.equals(proposalPerson.getProposalPersonRoleId())).allMatch(person -> pIEligibleCode.equals(person.getPerson().getExtendedAttributes().getIdVerified()));
    }

    @Override
    public Boolean personCertificationQuestionMatchesValue(DevelopmentProposal developmentProposal, String questionId, String value) {
        return developmentProposal.getProposalPersons().stream().map(proposalPerson -> new ProposalPersonModuleQuestionnaireBean(developmentProposal, (ProposalPerson)proposalPerson)).flatMap(proposalPersonModuleQuestionnaireBean -> this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)proposalPersonModuleQuestionnaireBean).stream()).flatMap(answerHeader -> answerHeader.getAnswers().stream()).filter(answer -> String.valueOf(answer.getQuestion().getQuestionSeqId()).equals(questionId)).anyMatch(answer -> StringUtils.equals((CharSequence)answer.getAnswer(), (CharSequence)value));
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ProposalTypeService getProposalTypeService() {
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }
}

