/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.XfaForm;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewHumanSubjectsAttachmentService;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component(value="proposalSpecialReviewHumanSubjectsAttachmentService")
public class ProposalSpecialReviewHumanSubjectsAttachmentServiceImpl
implements ProposalSpecialReviewHumanSubjectsAttachmentService {
    private static final String EMPTY_NODES = "//*[not(node()) and local-name(.) != 'FileLocation' and local-name(.) != 'HashValue' and local-name(.) != 'FileName']";
    private static final String OTHER_PERS = "//*[local-name(.)='ProjectRole' and local-name(../../.)='OtherPersonnel' and count(../NumberOfPersonnel)=0]";
    private static final String MESSAGE = "The pdf form does not contain any data.";
    private static final String UPLOADED_FILE_IS_EMPTY = "Uploaded file is empty";
    private static final String XFA_NS = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static Logger LOG = LogManager.getLogger(ProposalSpecialReviewHumanSubjectsAttachmentServiceImpl.class);
    @Autowired
    @Qualifier(value="formUtilityService")
    private FormUtilityService formUtilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getSpecialReviewAttachmentXmlFileData(byte[] pdfFileContents) {
        HashMap<String, Object> fileData = new HashMap<String, Object>();
        try (PdfReader reader = null;){
            if (pdfFileContents == null || pdfFileContents.length == 0) {
                throw new S2SException("error.s2s.userattachedform.file.empty", UPLOADED_FILE_IS_EMPTY);
            }
            reader = new PdfReader(pdfFileContents);
            List<KcFile> attachments = this.formUtilityService.extractAttachments(reader);
            Collection<String> duplicates = CollectionUtils.findDuplicates(attachments, KcFile::getName);
            if (!duplicates.isEmpty()) {
                S2SException s2sException = new S2SException();
                s2sException.setErrorKey("error.s2s.form.dup.att");
                s2sException.setParams(new String[]{"PHS_HumanSubjectsAndClinicalTrialsInfo_V1.0", duplicates.stream().collect(Collectors.joining(", "))});
                throw s2sException;
            }
            fileData.put("files", attachments);
            XfaForm xfaForm = reader.getAcroFields().getXfa();
            Document domDocument = xfaForm.getDomDocument();
            if (domDocument == null) {
                throw new S2SException("error.s2s.userattachedform.not.filled", MESSAGE);
            }
            Element documentElement = domDocument.getDocumentElement();
            if (documentElement == null) {
                throw new S2SException("error.s2s.userattachedform.not.filled", MESSAGE);
            }
            Element datasetsElement = (Element)documentElement.getElementsByTagNameNS(XFA_NS, "datasets").item(0);
            if (datasetsElement == null) {
                throw new S2SException("error.s2s.userattachedform.not.filled", MESSAGE);
            }
            Element dataElement = (Element)datasetsElement.getElementsByTagNameNS(XFA_NS, "data").item(0);
            if (dataElement == null) {
                throw new S2SException("error.s2s.userattachedform.not.filled", MESSAGE);
            }
            Element grantApplicationElement = (Element)dataElement.getChildNodes().item(0);
            if (grantApplicationElement == null) {
                throw new S2SException("error.s2s.userattachedform.not.filled", MESSAGE);
            }
            byte[] serializedXML = XfaForm.serializeDoc((Node)grantApplicationElement);
            DocumentBuilderFactory domParserFactory = DocumentBuilderFactory.newInstance();
            domParserFactory.setNamespaceAware(true);
            DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
            domParserFactory.setIgnoringElementContentWhitespace(true);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serializedXML);
            Document document = domParser.parse(byteArrayInputStream);
            if (document != null) {
                Element form = document.getDocumentElement();
                String xml = this.processForm(form, attachments);
                fileData.put("content", xml);
            }
        }
        return fileData;
    }

    private String processForm(Element form, List<KcFile> attachments) throws TransformerException, XPathExpressionException {
        Document doc = this.formUtilityService.node2Dom(form);
        this.formUtilityService.correctAttachmentXml(doc, attachments);
        this.formUtilityService.removeAllEmptyNodes(doc, EMPTY_NODES, 0);
        this.formUtilityService.removeAllEmptyNodes(doc, OTHER_PERS, 1);
        this.formUtilityService.removeAllEmptyNodes(doc, EMPTY_NODES, 0);
        this.formUtilityService.reorderXmlElements(doc);
        String formXML = this.formUtilityService.docToString(doc);
        return formXML;
    }

    public FormUtilityService getFormUtilityService() {
        return this.formUtilityService;
    }

    public void setFormUtilityService(FormUtilityService formUtilityService) {
        this.formUtilityService = formUtilityService;
    }
}

