/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.dd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.dd.DataDictionaryFile;
import org.kuali.coeus.sys.framework.dd.DataDictionaryOverride;
import org.kuali.rice.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.util.InMemoryResource;

public class DataDictionaryFileLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private static final String ID = "id";
    private static final String DOWNLOAD = "download";
    private static final String VIEW = "View";
    private static final String DATA_DICTIONARY_FILE_DO = "../dataDictionaryFile.do";
    private static final String MODULE = "module";
    private static final String NAME = "name";
    private static final String PATH = "path";

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        String idSearch = fieldValues.get(ID);
        String moduleSearch = fieldValues.get(MODULE);
        String nameSearch = fieldValues.get(NAME);
        String pathSearch = fieldValues.get(PATH);
        return this.getDataDictionaryService().getDataDictionary().getModuleDictionaryFiles().entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(r -> {
            String name;
            Object id;
            String path;
            DataDictionaryFile file = new DataDictionaryFile();
            file.setModule((String)entry.getKey());
            if (r instanceof ClassPathResource) {
                ClassPathResource classPathResource = (ClassPathResource)r;
                path = "classpath:" + classPathResource.getPath();
                id = path;
                name = classPathResource.getFilename();
            } else if (r instanceof InMemoryResource) {
                InMemoryResource inMemoryResource = (InMemoryResource)r;
                DataDictionaryOverride override = (DataDictionaryOverride)this.getBusinessObjectService().findBySinglePrimaryKey(DataDictionaryOverride.class, (Object)inMemoryResource.getDescription());
                path = "<a href=\"inquiry.do?businessObjectClassName=" + DataDictionaryOverride.class.getName() + "&id=" + inMemoryResource.getDescription() + "&methodToCall=start\">" + DataDictionaryOverride.class.getName() + "</a>";
                id = inMemoryResource.getDescription();
                name = override.getFileName();
            } else {
                throw new RuntimeException("unknown resource type " + r.getClass().getName());
            }
            file.setId((String)id);
            file.setPath(path);
            file.setName(name);
            try {
                file.setContent(IOUtils.toByteArray((InputStream)r.getInputStream()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return file;
        }).collect(Collectors.toList())).flatMap(Collection::stream).filter(file -> StringUtils.isBlank((CharSequence)idSearch) || StringUtils.isNotBlank((CharSequence)idSearch) && file.getId().equals(idSearch)).filter(file -> StringUtils.isBlank((CharSequence)moduleSearch) || StringUtils.isNotBlank((CharSequence)moduleSearch) && this.matches(file.getModule(), moduleSearch)).filter(file -> StringUtils.isBlank((CharSequence)nameSearch) || StringUtils.isNotBlank((CharSequence)nameSearch) && this.matches(file.getName(), nameSearch)).filter(file -> StringUtils.isBlank((CharSequence)pathSearch) || StringUtils.isNotBlank((CharSequence)pathSearch) && this.matches(file.getPath(), pathSearch)).collect(Collectors.toList());
    }

    private boolean matches(String val, String search) {
        return val.matches(search.replace("*", ".*"));
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        this.addViewHtmlData(htmlDataList, businessObject);
        return htmlDataList;
    }

    protected void addViewHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
        htmlDataList.add((HtmlData)this.getViewLink((DataDictionaryFile)businessObject));
    }

    protected HtmlData.AnchorHtmlData getViewLink(DataDictionaryFile businessObject) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", DOWNLOAD);
        parameters.put(ID, businessObject.getId());
        String href = UrlFactory.parameterizeUrl((String)DATA_DICTIONARY_FILE_DO, (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, DOWNLOAD, VIEW);
    }
}

