/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministratorDerivedRoleTypeService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.kim.framework.role.RoleTypeService;

public class AwardAllUnitAdministratorDerivedRoleTypeServiceImpl
extends AbstractUnitAdministratorDerivedRoleTypeService
implements RoleTypeService {
    private UnitService unitService;
    private AwardService awardService;

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected UnitService getUnitService() {
        return this.unitService;
    }

    @Override
    public List<? extends AbstractUnitAdministrator> getUnitAdministrators(Map<String, String> qualifiers) {
        String awardIdStr = qualifiers.get("award");
        boolean ascendsHierarchy = this.shouldAscendHierarchy(qualifiers);
        ArrayList<UnitAdministrator> result = new ArrayList<UnitAdministrator>();
        if (StringUtils.isNotBlank((CharSequence)awardIdStr) && awardIdStr.matches("\\d+")) {
            Long awardId = Long.valueOf(awardIdStr);
            Award award = this.getAwardService().getAward(awardId);
            HashSet<String> units = new HashSet<String>();
            for (AwardPerson person : award.getProjectPersons()) {
                units.addAll(this.getUnitsForPerson(person, ascendsHierarchy));
            }
            for (String unit : units) {
                if (!StringUtils.isNotBlank((CharSequence)unit)) continue;
                result.addAll(this.unitService.retrieveUnitAdministratorsByUnitNumber(unit));
            }
        }
        return result;
    }

    protected Set<String> getUnitsForPerson(AwardPerson person, boolean ascendsHierarchy) {
        return person.getUnits().stream().map(AwardPersonUnit::getUnitNumber).distinct().flatMap(unitNumber -> {
            if (ascendsHierarchy) {
                return this.unitService.getUnitHierarchyForUnit((String)unitNumber).stream().map(Unit::getUnitNumber);
            }
            return Stream.of(unitNumber);
        }).collect(Collectors.toSet());
    }

    protected boolean shouldAscendHierarchy(Map<String, String> qualifiers) {
        String subunitsString = qualifiers.getOrDefault("subunits", "N");
        return "Y".equals(subunitsString) || "Yes".equals(subunitsString);
    }

    protected AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

