/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestBean;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionBuilder;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class IacucProtocolRequestServiceImpl
implements IacucProtocolRequestService {
    private static final Logger LOG = LogManager.getLogger(IacucProtocolRequestServiceImpl.class);
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private IacucProtocolActionService protocolActionService;
    private KcNotificationService kcNotificationService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionService(IacucProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    public void submitRequest(IacucProtocol protocol, IacucProtocolRequestBean requestBean) throws WorkflowException {
        LOG.info("submitRequest " + requestBean.getProtocolActionTypeCode() + " " + protocol.getProtocolDocument().getDocumentNumber());
        String prevSubmissionStatusCode = protocol.getProtocolSubmission().getSubmissionStatusCode();
        IacucProtocolSubmission submission = this.createProtocolSubmission(protocol, requestBean);
        String submissionTypeCode = submission.getSubmissionTypeCode();
        protocol.setProtocolSubmission(submission);
        IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, submission, requestBean.getProtocolActionTypeCode());
        protocolAction.setComments(requestBean.getReason());
        protocolAction.setProtocol(protocol);
        protocolAction.setPrevProtocolStatusCode(protocol.getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatusCode);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        protocolAction.setCreatedSubmission(true);
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        if (!CollectionUtils.isEmpty(requestBean.getAnswerHeaders())) {
            this.saveQuestionnaire(requestBean, submission.getSubmissionNumber());
            requestBean.setAnswerHeaders(new ArrayList<AnswerHeader>());
        }
        this.cleanUnreferencedQuestionnaire(protocol.getProtocolNumber());
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
    }

    private void saveQuestionnaire(IacucProtocolRequestBean requestBean, Integer submissionNumber) {
        ArrayList<AnswerHeader> saveHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : requestBean.getAnswerHeaders()) {
            if (answerHeader.getId() == null) continue;
            answerHeader.setModuleSubItemKey(submissionNumber.toString());
            answerHeader.setModuleItemKey(answerHeader.getModuleItemKey().substring(0, answerHeader.getModuleItemKey().length() - 1));
            saveHeaders.add(answerHeader);
        }
        if (!saveHeaders.isEmpty()) {
            this.businessObjectService.save(saveHeaders);
        }
    }

    private void cleanUnreferencedQuestionnaire(String protocolNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(MODULE_ITEM_CODE, "7");
        fieldValues.put(MODULE_ITEM_KEY, protocolNumber + "T");
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)answerHeaders)) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected IacucProtocolSubmission createProtocolSubmission(IacucProtocol protocol, IacucProtocolRequestBean requestBean) {
        IacucProtocolSubmissionBuilder submissionBuilder = new IacucProtocolSubmissionBuilder(protocol, requestBean.getSubmissionTypeCode());
        submissionBuilder.setProtocolReviewTypeCode("3");
        submissionBuilder.setSubmissionStatus("101");
        submissionBuilder.setCommittee(requestBean.getCommitteeId());
        submissionBuilder.setActionAttachments(requestBean.getActionAttachments());
        return submissionBuilder.create();
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    public KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }
}

