/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.reviewcomments;

import java.util.List;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewer;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolReviewAttachment;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class IacucReviewCommentsServiceImpl
extends ReviewCommentsServiceImplBase<IacucProtocolReviewAttachment>
implements IacucReviewCommentsService {
    private static final String[] PROTOCOL_SUBMISSION_COMPLETE_STATUSES = new String[]{"213", "200", "210", "212", "201", "206", "209"};

    @Override
    public void saveReviewAttachments(List<IacucProtocolReviewAttachment> reviewAttachments, List<IacucProtocolReviewAttachment> deletedReviewAttachments) {
        for (ProtocolReviewAttachmentBase protocolReviewAttachmentBase : reviewAttachments) {
            boolean doUpdate = true;
            if (!doUpdate) continue;
            protocolReviewAttachmentBase.setPrivateFlag(!protocolReviewAttachmentBase.isProtocolPersonCanView());
            this.businessObjectService.save((PersistableBusinessObject)protocolReviewAttachmentBase);
        }
        if (!deletedReviewAttachments.isEmpty()) {
            this.businessObjectService.delete(deletedReviewAttachments);
        }
    }

    @Override
    protected ProtocolSubmissionBase getSubmission(ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = protocol.getProtocolSubmission();
        if (protocol.getNotifyIrbSubmissionId() != null) {
            for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
                if (!submission.getSubmissionId().equals(protocol.getNotifyIrbSubmissionId())) continue;
                protocolSubmission = submission;
                break;
            }
        }
        return protocolSubmission;
    }

    @Override
    protected Class<IacucProtocolReviewAttachment> getProtocolReviewAttachmentClassHook() {
        return IacucProtocolReviewAttachment.class;
    }

    @Override
    protected String getAdministratorRoleHook() {
        return "IACUC Administrator";
    }

    @Override
    protected Class<? extends ProtocolReviewer> getProtocolReviewClassHook() {
        return IacucProtocolReviewer.class;
    }

    @Override
    protected String getAggregatorRoleNameHook() {
        return "IACUC Protocol Aggregator";
    }

    @Override
    protected String getNamespaceHook() {
        return "KC-IACUC";
    }

    @Override
    protected String getProtocolViewerRoleNameHook() {
        return "IACUC Protocol Viewer";
    }

    @Override
    protected String getDisplayRevNameToActiveCmtMembersHook() {
        return "IACUC_DISPLAY_REVIEWER_NAME_TO_ACTIVE_COMMITTEE_MEMBERS";
    }

    @Override
    protected String getDisplayRevNameToProtocolPersonnelHook() {
        return "IACUC_DISPLAY_REVIEWER_NAME_TO_PROTOCOL_PERSONNEL";
    }

    @Override
    protected String getDisplayRevNameToReviewersHook() {
        return "IACUC_DISPLAY_REVIEWER_NAME_TO_REVIEWERS";
    }

    @Override
    protected String[] getProtocolSubmissionCompleteStatusCodeArrayHook() {
        return PROTOCOL_SUBMISSION_COMPLETE_STATUSES;
    }

    @Override
    protected Class<? extends ProtocolOnlineReviewBase> getProtocolOnlineReviewClassHook() {
        return IacucProtocolOnlineReview.class;
    }

    @Override
    protected Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook() {
        return IacucCommitteeScheduleMinute.class;
    }

    @Override
    protected Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook() {
        return IacucProtocolDocument.class;
    }
}

