/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.committee.print;

import edu.mit.coeus.xml.iacuc.FundingSourceType;
import edu.mit.coeus.xml.iacuc.InvestigatorType;
import edu.mit.coeus.xml.iacuc.PersonType;
import edu.mit.coeus.xml.iacuc.ProtocolMasterDataType;
import edu.mit.coeus.xml.iacuc.ProtocolReviewerType;
import edu.mit.coeus.xml.iacuc.ProtocolSubmissionType;
import edu.mit.coeus.xml.iacuc.ProtocolSummaryType;
import edu.mit.coeus.xml.iacuc.ScheduleDocument;
import edu.mit.coeus.xml.iacuc.ScheduleMasterDataType;
import edu.mit.coeus.xml.iacuc.ScheduleSummaryType;
import edu.mit.coeus.xml.iacuc.ScheduleType;
import edu.mit.coeus.xml.iacuc.SubmissionDetailsType;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleActItemBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeMembershipServiceBase;
import org.kuali.coeus.common.framework.print.stream.xml.PrintBaseXmlStream;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewer;
import org.kuali.kra.iacuc.committee.bo.IacucCommitteeSchedule;
import org.kuali.kra.iacuc.committee.print.service.IacucPrintXmlUtilService;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonRolodex;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionLiteBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;

public class IacucScheduleXmlStream
extends PrintBaseXmlStream<ScheduleDocument> {
    private static final String EXPEDIT_ACTION_TYPE_CODE = "205";
    private static final String EXEMPT_ACTION_TYPE_CODE = "206";
    private static final String FOLLOW_UP_ACTION_CODE = "109";
    private static final Logger LOG = LogManager.getLogger(IacucScheduleXmlStream.class);
    private static final String SCHEDULE = "Schedule";
    private static final String PROTOCOL_SUBMISSIONS = "protocolSubmissions";
    private static final String COMMITTEE_ID_FK = "committeeIdFk";
    private static final String SCHEDULED_DATE = "scheduledDate";
    private static final String PROTOCOL_ID = "protocolId";
    private static final String SUBMISSION_ID_FK = "submissionIdFk";
    private CommitteeMembershipServiceBase committeeMembershipService;
    private IacucPrintXmlUtilService printXmlUtilService;

    @Override
    public Class<ScheduleDocument> type() {
        return ScheduleDocument.class;
    }

    @Override
    public Map<String, ScheduleDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        IacucCommitteeSchedule committeeSchedule = (IacucCommitteeSchedule)printableBusinessObject;
        LinkedHashMap<String, ScheduleDocument> xmlObjectList = new LinkedHashMap<String, ScheduleDocument>();
        ScheduleDocument scheduleDocument = ScheduleDocument.Factory.newInstance();
        scheduleDocument.setSchedule(this.getSchedule(committeeSchedule));
        xmlObjectList.put(SCHEDULE, scheduleDocument);
        return xmlObjectList;
    }

    public ScheduleType getSchedule(IacucCommitteeSchedule committeeSchedule) {
        ScheduleType schedule = ScheduleType.Factory.newInstance();
        this.setScheduleMasterData(committeeSchedule, schedule.addNewScheduleMasterData());
        ScheduleSummaryType prevSchedule = schedule.addNewPreviousSchedule();
        this.setPreviousSchedule(committeeSchedule, prevSchedule.addNewScheduleMasterData());
        ScheduleSummaryType nextScheduleType = schedule.addNewNextSchedule();
        this.setNextSchedule(committeeSchedule, nextScheduleType.addNewScheduleMasterData());
        this.getPrintXmlUtilService().setMinutes(committeeSchedule, schedule);
        this.setAttendance(committeeSchedule, schedule);
        committeeSchedule.refreshReferenceObject(PROTOCOL_SUBMISSIONS);
        committeeSchedule.getLatestProtocolSubmissions().stream().sorted(Comparator.comparing(ProtocolSubmissionLiteBase::getProtocolReviewTypeCode).thenComparing(ProtocolSubmissionLiteBase::getSubmissionTypeCode).thenComparing(ProtocolSubmissionLiteBase::getProtocolNumber)).forEach(protocolSubmission -> {
            ProtocolSubmissionType protocolSubmissionType = schedule.addNewProtocolSubmission();
            SubmissionDetailsType protocolSubmissionDetail = protocolSubmissionType.addNewSubmissionDetails();
            ProtocolSummaryType protocolSummary = protocolSubmissionType.addNewProtocolSummary();
            ProtocolMasterDataType protocolMaster = protocolSummary.addNewProtocolMasterData();
            String followUpAction = null;
            String actionTypeCode = null;
            IacucProtocol protocol = (IacucProtocol)this.getBusinessObjectService().findByPrimaryKey(IacucProtocol.class, Collections.singletonMap(PROTOCOL_ID, protocolSubmission.getProtocolId()));
            List<ProtocolActionBase> protocolActions = protocol.getProtocolActions();
            for (ProtocolActionBase protocolAction : protocolActions) {
                actionTypeCode = protocolAction.getProtocolActionTypeCode();
                if (!actionTypeCode.equals(EXPEDIT_ACTION_TYPE_CODE) && !actionTypeCode.equals(EXEMPT_ACTION_TYPE_CODE)) continue;
                if (protocolAction.getFollowupActionCode() == null || !protocolAction.getFollowupActionCode().equals(FOLLOW_UP_ACTION_CODE)) break;
                followUpAction = protocolAction.getFollowupActionCode();
                break;
            }
            if (!EXPEDIT_ACTION_TYPE_CODE.equals(actionTypeCode) && !EXEMPT_ACTION_TYPE_CODE.equals(actionTypeCode) && followUpAction == null) {
                protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
                protocolMaster.setSequenceNumber(new BigInteger(String.valueOf(protocol.getSequenceNumber())));
                protocolMaster.setProtocolTitle(protocol.getTitle());
                protocolMaster.setProtocolStatusCode(new BigInteger(String.valueOf(protocol.getProtocolStatusCode())));
                protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
                protocolMaster.setProtocolTypeCode(new BigInteger(String.valueOf(protocol.getProtocolTypeCode())));
                protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
                if (protocol.getDescription() != null) {
                    protocolMaster.setProtocolDescription(protocol.getDescription());
                }
                if (protocol.getApprovalDate() != null) {
                    protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getApprovalDate()));
                }
                if (protocol.getExpirationDate() != null) {
                    protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getExpirationDate()));
                }
                if (protocol.getFdaApplicationNumber() != null) {
                    protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
                }
                if (protocol.getReferenceNumber1() != null) {
                    protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
                }
                if (protocol.getReferenceNumber2() != null) {
                    protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
                }
                protocolSubmissionDetail.setProtocolNumber(protocolSubmission.getProtocolNumber());
                if (protocolSubmission.getProtocolSubmissionType() != null) {
                    protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
                }
                if (protocolSubmission.getProtocolReviewTypeCode() != null) {
                    protocolSubmissionDetail.setProtocolReviewTypeCode(new BigInteger(protocolSubmission.getProtocolReviewTypeCode()));
                }
                if (protocolSubmission.getProtocolReviewType() != null) {
                    protocolSubmissionDetail.setProtocolReviewTypeDesc(protocolSubmission.getProtocolReviewType().getDescription());
                }
                if (protocolSubmission.getSubmissionTypeCode() != null) {
                    protocolSubmissionDetail.setSubmissionTypeCode(new BigInteger(protocolSubmission.getSubmissionTypeCode()));
                }
                if (protocolSubmission.getProtocolSubmissionType() != null) {
                    protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
                }
                if (protocolSubmission.getSubmissionNumber() != null) {
                    protocolSubmissionDetail.setSubmissionNumber(new BigInteger(String.valueOf(protocolSubmission.getSubmissionNumber())));
                }
                if (protocolSubmission.getSubmissionStatusCode() != null) {
                    protocolSubmissionDetail.setSubmissionStatusCode(new BigInteger(protocolSubmission.getSubmissionStatusCode()));
                }
                if (protocolSubmission.getSubmissionStatus() != null) {
                    protocolSubmissionDetail.setSubmissionStatusDesc(protocolSubmission.getSubmissionStatus().getDescription());
                }
                if (protocolSubmission.getSubmissionTypeQualifierCode() != null) {
                    protocolSubmissionDetail.setSubmissionTypeQualifierCode(new BigInteger(protocolSubmission.getSubmissionTypeQualifierCode()));
                }
                if (protocolSubmission.getProtocolSubmissionQualifierType() != null) {
                    protocolSubmissionDetail.setSubmissionTypeQualifierDesc(protocolSubmission.getProtocolSubmissionQualifierType().getDescription());
                }
                if (protocolSubmission.getYesVoteCount() != null) {
                    protocolSubmissionDetail.setYesVote(BigInteger.valueOf(protocolSubmission.getYesVoteCount().intValue()));
                } else {
                    protocolSubmissionDetail.setYesVote(BigInteger.ZERO);
                }
                if (protocolSubmission.getNoVoteCount() != null) {
                    protocolSubmissionDetail.setNoVote(BigInteger.valueOf(protocolSubmission.getNoVoteCount().intValue()));
                } else {
                    protocolSubmissionDetail.setNoVote(BigInteger.ZERO);
                }
                if (protocolSubmission.getAbstainerCount() != null) {
                    protocolSubmissionDetail.setAbstainerCount(BigInteger.valueOf(protocolSubmission.getAbstainerCount().intValue()));
                } else {
                    protocolSubmissionDetail.setAbstainerCount(BigInteger.ZERO);
                }
                protocolSubmissionDetail.setVotingComments(protocolSubmission.getVotingComments());
                this.setProtocolSubmissionAction((ProtocolSubmissionLiteBase)protocolSubmission, protocol, protocolSubmissionDetail);
                if (protocolSubmission.getSubmissionDate() != null) {
                    protocolSubmissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((java.util.Date)protocolSubmission.getSubmissionDate()));
                }
                this.setSubmissionCheckListinfo((ProtocolSubmissionLiteBase)protocolSubmission, protocolSubmissionDetail);
                this.setProtocolSubmissionReviewers((ProtocolSubmissionLiteBase)protocolSubmission, protocolSubmissionDetail);
                List<ProtocolPersonBase> protocolPersons = protocol.getProtocolPersons();
                protocolPersons.stream().filter(protocolPerson -> protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")).forEach(protocolPerson -> {
                    InvestigatorType investigator = protocolSummary.addNewInvestigator();
                    this.getPrintXmlUtilService().setPersonRolodexType((ProtocolPersonBase)protocolPerson, investigator.addNewPerson());
                    if (protocolPerson.getProtocolPersonRoleId().equals("PI")) {
                        investigator.setPIFlag(true);
                    }
                });
                List<ProtocolFundingSourceBase> vecFundingSource = protocol.getProtocolFundingSources();
                for (ProtocolFundingSourceBase protocolFundingSourceBean : vecFundingSource) {
                    protocolFundingSourceBean.refreshNonUpdateableReferences();
                    FundingSourceType fundingSource = protocolSummary.addNewFundingSource();
                    String fundingSourceCode = protocolFundingSourceBean.getFundingSourceNumber();
                    int fundingSourceTypeCode = Integer.valueOf(protocolFundingSourceBean.getFundingSourceTypeCode());
                    String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
                    fundingSource.setFundingSourceName(fundingSourceName);
                    if (protocolFundingSourceBean.getFundingSourceType() == null) continue;
                    fundingSource.setTypeOfFundingSource(protocolFundingSourceBean.getFundingSourceType().getDescription());
                }
                this.getPrintXmlUtilService().setProcotolMinutes(committeeSchedule, (ProtocolSubmissionLiteBase)protocolSubmission, protocolSubmissionType);
                this.setOtherActionItems(committeeSchedule, schedule);
            }
        });
        return schedule;
    }

    private void setProtocolSubmissionAction(ProtocolSubmissionLiteBase protocolSubmission, IacucProtocol protocol, SubmissionDetailsType protocolSubmissionDetail) {
        ProtocolActionBase protcolAction = this.findProtocolActionForSubmission(protocolSubmission, protocol);
        if (protcolAction != null) {
            protcolAction.refreshNonUpdateableReferences();
            SubmissionDetailsType.ActionType actionTypeInfo = protocolSubmissionDetail.addNewActionType();
            actionTypeInfo.setActionId(BigInteger.valueOf(protcolAction.getActionId().intValue()));
            if (protcolAction.getProtocolActionTypeCode() != null) {
                actionTypeInfo.setActionTypeCode(new BigInteger(protcolAction.getProtocolActionTypeCode()));
                actionTypeInfo.setActionTypeDescription(protcolAction.getProtocolActionType().getDescription());
            }
            if (protcolAction.getActionDate() != null) {
                actionTypeInfo.setActionDate(this.getDateTimeService().getCalendar((java.util.Date)protcolAction.getActionDate()));
            }
            actionTypeInfo.setActionComments(protcolAction.getComments());
        }
    }

    private void setOtherActionItems(IacucCommitteeSchedule committeeSchedule, ScheduleType schedule) {
        List<CommScheduleActItemBase> otherActions = committeeSchedule.getCommScheduleActItems();
        for (CommScheduleActItemBase otherActionInfoBean : otherActions) {
            otherActionInfoBean.refreshNonUpdateableReferences();
            ScheduleType.OtherBusiness otherBusinessType = schedule.addNewOtherBusiness();
            otherBusinessType.setActionItemNumber(BigInteger.valueOf(otherActionInfoBean.getActionItemNumber().intValue()));
            otherBusinessType.setActionItemDesc(otherActionInfoBean.getItemDescription());
            if (otherActionInfoBean.getScheduleActItemType() == null) continue;
            otherBusinessType.setActionItemCode(new BigInteger(otherActionInfoBean.getScheduleActItemTypeCode()));
            otherBusinessType.setActionItemCodeDesc(otherActionInfoBean.getScheduleActItemType().getDescription());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsor != null) {
                name = sponsor.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unit = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unit != null) {
                name = unit.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void setProtocolSubmissionReviewers(ProtocolSubmissionLiteBase protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        Collection vecReviewers = this.getBusinessObjectService().findMatching(IacucProtocolReviewer.class, Collections.singletonMap(SUBMISSION_ID_FK, protocolSubmission.getSubmissionId()));
        ArrayList<ProtocolReviewerType> protocolReviewerTypeList = new ArrayList<ProtocolReviewerType>();
        for (ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerType protocolReviewerType = ProtocolReviewerType.Factory.newInstance();
            this.setPerson(protocolReviewer, protocolReviewerType);
            protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
            protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
            protocolReviewerTypeList.add(protocolReviewerType);
        }
        protocolSubmissionDetail.setProtocolReviewerArray(protocolReviewerTypeList.toArray(new ProtocolReviewerType[0]));
    }

    private void setPerson(ProtocolReviewer protocolReviewer, ProtocolReviewerType protocolReviewerType) {
        PersonType personType = protocolReviewerType.addNewPerson();
        boolean nonEmployeeFlag = protocolReviewer.getNonEmployeeFlag();
        if (!nonEmployeeFlag) {
            this.getPrintXmlUtilService().setPersonXml(protocolReviewer.getPerson(), personType);
        } else {
            Rolodex rolodex = protocolReviewer.getRolodex();
            ProtocolPersonRolodexBase protocolRolodex = (ProtocolPersonRolodexBase)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolPersonRolodex.class, (Object)rolodex.getRolodexId());
            this.getPrintXmlUtilService().setPersonXml(protocolRolodex, personType);
        }
    }

    private void setSubmissionCheckListinfo(ProtocolSubmissionLiteBase protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        protocolSubmissionDetail.addNewSubmissionChecklistInfo();
    }

    private ProtocolActionBase findProtocolActionForSubmission(ProtocolSubmissionLiteBase protocolSubmission, IacucProtocol protocol) {
        List<ProtocolActionBase> protocolActions = protocol.getProtocolActions();
        for (ProtocolActionBase protocolAction : protocolActions) {
            if (protocolAction.getSubmissionNumber() == null || !protocolAction.getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber())) continue;
            return protocolAction;
        }
        return null;
    }

    private void setAttendance(IacucCommitteeSchedule committeeSchedule, ScheduleType schedule) {
        List<CommitteeScheduleAttendanceBase> attendenceList = committeeSchedule.getCommitteeScheduleAttendances();
        for (CommitteeScheduleAttendanceBase attendanceInfoBean : attendenceList) {
            ScheduleType.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(attendanceInfoBean.getPersonName());
            attendents.setAlternateFlag(attendanceInfoBean.getAlternateFlag());
            attendents.setGuestFlag(attendanceInfoBean.getGuestFlag());
            attendents.setAlternateFor(attendanceInfoBean.getAlternateFor());
            attendents.setPresentFlag(true);
        }
        List<CommitteeMembershipBase> committeeMemberships = committeeSchedule.getParentCommittee().getCommitteeMemberships();
        committeeMemberships.stream().filter(committeeMembership -> !this.getCommitteeMembershipService().isMemberAttendedMeeting((CommitteeMembershipBase)committeeMembership, committeeSchedule.getParentCommittee().getCommitteeId())).forEach(committeeMembership -> {
            ScheduleType.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(committeeMembership.getPersonName());
            attendents.setAlternateFlag(false);
            attendents.setGuestFlag(false);
            attendents.setPresentFlag(false);
        });
    }

    public ScheduleMasterDataType setScheduleMasterData(CommitteeScheduleBase scheduleDetailsBean, ScheduleMasterDataType scheduleMasterDataType) {
        scheduleDetailsBean.refreshNonUpdateableReferences();
        String committeeId = ((CommitteeBase)scheduleDetailsBean.getParentCommittee()).getCommitteeId();
        scheduleMasterDataType.setScheduleId(scheduleDetailsBean.getScheduleId());
        scheduleMasterDataType.setCommitteeId(committeeId);
        scheduleMasterDataType.setCommitteeName(((CommitteeBase)scheduleDetailsBean.getParentCommittee()).getCommitteeName());
        scheduleMasterDataType.setScheduleStatusCode(BigInteger.valueOf(scheduleDetailsBean.getScheduleStatusCode().intValue()));
        scheduleMasterDataType.setScheduleStatusDesc(scheduleDetailsBean.getScheduleStatus().getDescription());
        if (scheduleDetailsBean.getScheduledDate() != null) {
            scheduleMasterDataType.setScheduledDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getScheduledDate()));
        } else {
            scheduleMasterDataType.setScheduledDate(this.getDateTimeService().getCurrentCalendar());
        }
        try {
            if (scheduleDetailsBean.getTime() != null) {
                Date date = this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getTime());
                scheduleMasterDataType.setScheduledTime(this.getDateTimeService().getCalendar((java.util.Date)date));
            }
            scheduleMasterDataType.setPlace(scheduleDetailsBean.getPlace());
            if (scheduleDetailsBean.getProtocolSubDeadline() != null) {
                scheduleMasterDataType.setProtocolSubDeadline(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getProtocolSubDeadline()));
            }
            if (scheduleDetailsBean.getMeetingDate() != null) {
                scheduleMasterDataType.setMeetingDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getMeetingDate()));
            }
            if (scheduleDetailsBean.getStartTime() != null) {
                scheduleMasterDataType.setStartTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getStartTime())));
            }
            if (scheduleDetailsBean.getEndTime() != null) {
                scheduleMasterDataType.setEndTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getEndTime())));
            }
            if (scheduleDetailsBean.getAgendaProdRevDate() != null) {
                scheduleMasterDataType.setAgendaProdRevDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getAgendaProdRevDate()));
            }
        }
        catch (ParseException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        scheduleMasterDataType.setMaxProtocols(new BigInteger(String.valueOf(scheduleDetailsBean.getMaxProtocols())));
        if (scheduleDetailsBean.getComments() != null) {
            scheduleMasterDataType.setComments(scheduleDetailsBean.getComments());
        }
        return scheduleMasterDataType;
    }

    public void setNextSchedule(CommitteeScheduleBase scheduleDetailsBean, ScheduleMasterDataType scheduleMasterData) {
        CommitteeScheduleBase nextSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, true);
        if (nextSchedule != null) {
            this.setScheduleMasterData(nextSchedule, scheduleMasterData);
        }
    }

    public void setPreviousSchedule(CommitteeScheduleBase scheduleDetailsBean, ScheduleMasterDataType scheduleMasterDataType) {
        CommitteeScheduleBase prevSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, false);
        if (prevSchedule != null) {
            this.setScheduleMasterData(prevSchedule, scheduleMasterDataType);
        }
    }

    private CommitteeScheduleBase getNextOrPreviousSchedule(CommitteeScheduleBase scheduleDetailsBean, boolean nextFlag) {
        HashMap<String, String> scheduleParam = new HashMap<String, String>();
        scheduleParam.put(COMMITTEE_ID_FK, ((CommitteeBase)scheduleDetailsBean.getParentCommittee()).getId().toString());
        List schedules = (List)this.getBusinessObjectService().findMatchingOrderBy(IacucCommitteeSchedule.class, scheduleParam, SCHEDULED_DATE, true);
        if (!schedules.isEmpty()) {
            int size = schedules.size();
            for (int i = 0; i < size; ++i) {
                CommitteeScheduleBase schedule = (CommitteeScheduleBase)schedules.get(i);
                if (!schedule.getScheduleId().equals(scheduleDetailsBean.getScheduleId())) continue;
                if (nextFlag && i < size - 1) {
                    return (CommitteeScheduleBase)schedules.get(i + 1);
                }
                if (!nextFlag && i > 0) {
                    return (CommitteeScheduleBase)schedules.get(i - 1);
                }
                return null;
            }
        }
        return null;
    }

    public void setCommitteeMembershipService(CommitteeMembershipServiceBase committeeMembershipService) {
        this.committeeMembershipService = committeeMembershipService;
    }

    public CommitteeMembershipServiceBase getCommitteeMembershipService() {
        return this.committeeMembershipService;
    }

    public IacucPrintXmlUtilService getPrintXmlUtilService() {
        return this.printXmlUtilService;
    }

    public void setPrintXmlUtilService(IacucPrintXmlUtilService printXmlUtilService) {
        this.printXmlUtilService = printXmlUtilService;
    }
}

