/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.iacuc.procedures.IacucProcedure;
import org.kuali.kra.iacuc.procedures.IacucProcedureNavigation;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolProceduresHelper
implements Serializable {
    private static final long serialVersionUID = -2090976351003068814L;
    protected IacucProtocolForm form;
    protected IacucProtocolStudyGroup newIacucProtocolStudyGroup;
    protected IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean;
    protected IacucProcedurePersonResponsible newIacucProcedurePersonResponsible;
    private IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation;
    private List<IacucProcedure> allProcedures;
    protected int MAX_CATEGORY_COLUMNS = 3;
    private IacucProcedureNavigation currentProcedureDetailTab;
    protected IacucProtocolPerson selectedProtocolPerson;
    boolean summaryGroupedBySpecies = false;

    public IacucProtocolProceduresHelper(IacucProtocolForm form) {
        this.setForm(form);
        this.setNewIacucProtocolStudyGroup(new IacucProtocolStudyGroup());
        this.setNewIacucProtocolStudyGroupBean(new IacucProtocolStudyGroupBean());
        this.setNewIacucProcedurePersonResponsible(new IacucProcedurePersonResponsible());
        this.setAllProcedures(new ArrayList<IacucProcedure>());
        this.initializeIncludedProceduresAndCategories();
        this.setCurrentProcedureDetailTab(IacucProcedureNavigation.PROCEDURES);
        this.setNewIacucProtocolStudyGroupLocation(new IacucProtocolStudyGroupLocation());
    }

    public void prepareView() {
        this.initializeIncludedProceduresAndCategories();
    }

    private void initializeIncludedProceduresAndCategories() {
        if (this.getAllProcedures().isEmpty()) {
            this.setAllProcedures(this.getIacucProtocolProcedureService().getAllProcedures());
        }
        if (this.getProtocol().getIacucProtocolStudyGroupBeans().isEmpty()) {
            this.getProtocol().setIacucProtocolStudyGroupBeans(this.getIacucProtocolProcedureService().getRevisedStudyGroupBeans(this.getProtocol(), this.getAllProcedures()));
        }
    }

    protected IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return (IacucProtocolProcedureService)KcServiceLocator.getService("iacucProtocolProcedureService");
    }

    protected IacucProtocol getProtocol() {
        IacucProtocolDocument document = this.form.getIacucProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) Iacuc ProtocolDocument in ProtocolForm");
        }
        return document.getIacucProtocol();
    }

    public IacucProtocolForm getForm() {
        return this.form;
    }

    public void setForm(IacucProtocolForm form) {
        this.form = form;
    }

    public boolean isModifyProtocolProcedures() {
        IacucProtocolTask task = new IacucProtocolTask("modifyIacucProtocolProcedures", (IacucProtocol)this.form.getProtocolDocument().getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    public IacucProtocolStudyGroup getNewIacucProtocolStudyGroup() {
        return this.newIacucProtocolStudyGroup;
    }

    public void setNewIacucProtocolStudyGroup(IacucProtocolStudyGroup newIacucProtocolStudyGroup) {
        this.newIacucProtocolStudyGroup = newIacucProtocolStudyGroup;
    }

    public List<IacucProcedure> getAllProcedures() {
        return this.allProcedures;
    }

    public void setAllProcedures(List<IacucProcedure> allProcedures) {
        this.allProcedures = allProcedures;
    }

    public int getMaxCategoriesInAColumn() {
        return (int)Math.ceil(this.getAllProcedures().size() / this.MAX_CATEGORY_COLUMNS);
    }

    public IacucProtocolStudyGroupBean getNewIacucProtocolStudyGroupBean() {
        return this.newIacucProtocolStudyGroupBean;
    }

    public void setNewIacucProtocolStudyGroupBean(IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean) {
        this.newIacucProtocolStudyGroupBean = newIacucProtocolStudyGroupBean;
    }

    public IacucProcedurePersonResponsible getNewIacucProcedurePersonResponsible() {
        return this.newIacucProcedurePersonResponsible;
    }

    public void setNewIacucProcedurePersonResponsible(IacucProcedurePersonResponsible newIacucProcedurePersonResponsible) {
        this.newIacucProcedurePersonResponsible = newIacucProcedurePersonResponsible;
    }

    public IacucProcedureNavigation[] getProcedureNavigationTabs() {
        return IacucProcedureNavigation.values();
    }

    public IacucProcedureNavigation getCurrentProcedureDetailTab() {
        return this.currentProcedureDetailTab;
    }

    public void setCurrentProcedureDetailTab(IacucProcedureNavigation currentProcedureDetailTab) {
        this.currentProcedureDetailTab = currentProcedureDetailTab;
    }

    public IacucProtocolPerson getSelectedProtocolPerson() {
        return this.selectedProtocolPerson;
    }

    public void setSelectedProtocolPerson(IacucProtocolPerson selectedProtocolPerson) {
        this.selectedProtocolPerson = selectedProtocolPerson;
    }

    public IacucProtocolStudyGroupLocation getNewIacucProtocolStudyGroupLocation() {
        return this.newIacucProtocolStudyGroupLocation;
    }

    public void setNewIacucProtocolStudyGroupLocation(IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation) {
        this.newIacucProtocolStudyGroupLocation = newIacucProtocolStudyGroupLocation;
    }

    public boolean isSummaryGroupedBySpecies() {
        return this.summaryGroupedBySpecies;
    }

    public void setSummaryGroupedBySpecies(boolean summaryGroupedBySpecies) {
        this.summaryGroupedBySpecies = summaryGroupedBySpecies;
    }

    public boolean isProcedureViewedBySpecies() {
        return this.getIacucProtocolProcedureService().isProcedureViewedBySpecies();
    }
}

