/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.KcDocumentBaseAuditRule;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.attachments.InstitutionalProposalAttachment;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalCreditSplitBean;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonAuditRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonSaveRuleEvent;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonSaveRuleImpl;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddAttachmentRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddAttachmentRuleImpl;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRuleImpl;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCfdaRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCfdaRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCfdaRuleImpl;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalFinancialRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalFinancialRuleImpl;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalRuleImpl;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSaveUnrecoveredFandARuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramInformationAuditRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramRuleImpl;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalUnrecoveredFandARuleImpl;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class InstitutionalProposalDocumentRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule,
DocumentAuditRule,
InstitutionalProposalCfdaRule {
    public static final String DOCUMENT_ERROR_PATH = "document";
    public static final String INSTITUTIONAL_PROPOSAL = "institutionalProposal";
    public static final String IP_ERROR_PATH = "institutionalProposal";

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!(document instanceof InstitutionalProposalDocument)) {
            return false;
        }
        boolean retval = this.processUnrecoveredFandABusinessRules(document);
        retval &= this.processSponsorProgramBusinessRule(document);
        retval &= this.processInstitutionalProposalBusinessRules(document);
        retval &= this.processInstitutionalProposalFinancialRules(document);
        retval &= this.processInstitutionalProposalPersonBusinessRules(errorMap, document);
        retval &= this.processKeywordBusinessRule(document);
        retval &= this.processAccountIdBusinessRule(document);
        retval &= this.processCostShareRules(document);
        return retval &= this.processInstitutionalProposalAttachmentsBusinessRules(document);
    }

    private boolean processUnrecoveredFandABusinessRules(Document document) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        int i = 0;
        List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs = institutionalProposalDocument.getInstitutionalProposal().getInstitutionalProposalUnrecoveredFandAs();
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath("institutionalProposal");
        for (InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA : institutionalProposalUnrecoveredFandAs) {
            String errorPath = "institutionalProposalUnrecoveredFandAs[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            InstitutionalProposalSaveUnrecoveredFandARuleEvent event = new InstitutionalProposalSaveUnrecoveredFandARuleEvent(errorPath, institutionalProposalDocument, institutionalProposalUnrecoveredFandA);
            valid &= new InstitutionalProposalUnrecoveredFandARuleImpl().processSaveInstitutionalProposalUnrecoveredFandABusinessRules(event);
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        errorMap.removeFromErrorPath("institutionalProposal");
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return valid;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = new KcDocumentBaseAuditRule().processRunAuditBusinessRules(document);
        retval &= new InstitutionalProposalPersonAuditRule().processRunAuditBusinessRules(document);
        retval &= this.processInstitutionalProposalPersonCreditSplitBusinessRules(document);
        retval &= this.processInstitutionalProposalPersonUnitCreditSplitBusinessRules(document);
        return retval &= new InstitutionalProposalSponsorAndProgramInformationAuditRule().processRunAuditBusinessRules(document);
    }

    private boolean processInstitutionalProposalPersonBusinessRules(MessageMap errorMap, Document document) {
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath("institutionalProposal");
        InstitutionalProposalPersonSaveRuleEvent event = new InstitutionalProposalPersonSaveRuleEvent("Project Persons", "projectPersons", document);
        boolean success = new InstitutionalProposalPersonSaveRuleImpl().processInstitutionalProposalPersonSaveBusinessRules(event);
        errorMap.removeFromErrorPath("institutionalProposal");
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    private boolean processInstitutionalProposalPersonCreditSplitBusinessRules(Document document) {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        return new InstitutionalProposalCreditSplitBean(institutionalProposalDocument).recalculateCreditSplit();
    }

    private boolean processInstitutionalProposalPersonUnitCreditSplitBusinessRules(Document document) {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        return new InstitutionalProposalCreditSplitBean(institutionalProposalDocument).recalculateCreditSplit();
    }

    private boolean processKeywordBusinessRule(Document document) {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        List<InstitutionalProposalScienceKeyword> keywords = institutionalProposalDocument.getInstitutionalProposal().getKeywords();
        for (InstitutionalProposalScienceKeyword keyword : keywords) {
            for (InstitutionalProposalScienceKeyword keyword2 : keywords) {
                if (keyword == keyword2 || !StringUtils.equalsIgnoreCase((CharSequence)keyword.getScienceKeywordCode(), (CharSequence)keyword2.getScienceKeywordCode())) continue;
                GlobalVariables.getMessageMap().putError("document.institutionalProposalList[0].keyword", "error.proposalKeywords.duplicate", new String[0]);
                return false;
            }
        }
        return true;
    }

    private boolean processAccountIdBusinessRule(Document document) {
        boolean retVal = true;
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        InstitutionalProposal institutionalProposal = institutionalProposalDocument.getInstitutionalProposal();
        String ipAccountNumber = institutionalProposal.getCurrentAccountNumber();
        String awardNumber = institutionalProposal.getCurrentAwardNumber();
        if (!StringUtils.isEmpty((CharSequence)awardNumber) && !StringUtils.isEmpty((CharSequence)ipAccountNumber)) {
            Award award;
            String awardAccountNumber;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("awardNumber", awardNumber);
            Collection awardCol = this.getBusinessObjectService().findMatching(Award.class, fieldValues);
            if (!awardCol.isEmpty() && !StringUtils.equalsIgnoreCase((CharSequence)ipAccountNumber, (CharSequence)(awardAccountNumber = (award = (Award)awardCol.toArray()[0]).getAccountNumber()))) {
                GlobalVariables.getMessageMap().putError("document.institutionalProposal.currentAccountNumber", "error.institutionalProposal.accountNumber.invalid", new String[]{ipAccountNumber});
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean processSponsorProgramBusinessRule(Document document) {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        String errorPath = "institutionalSponsorAndProgram";
        InstitutionalProposalSponsorAndProgramRuleEvent event = new InstitutionalProposalSponsorAndProgramRuleEvent(errorPath, institutionalProposalDocument, institutionalProposalDocument.getInstitutionalProposal());
        return new InstitutionalProposalSponsorAndProgramRuleImpl().processInstitutionalProposalSponsorAndProgramRules(event);
    }

    private boolean processInstitutionalProposalFinancialRules(Document document) {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        String errorPath = "institutionalProposalFinancial";
        InstitutionalProposalFinancialRuleEvent event = new InstitutionalProposalFinancialRuleEvent(errorPath, institutionalProposalDocument, institutionalProposalDocument.getInstitutionalProposal());
        return new InstitutionalProposalFinancialRuleImpl().processInstitutionalProposalFinancialRules(event);
    }

    private boolean processInstitutionalProposalBusinessRules(Document document) {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        String errorPath = "institutionalProposal";
        InstitutionalProposalRuleEvent event = new InstitutionalProposalRuleEvent(errorPath, institutionalProposalDocument, institutionalProposalDocument.getInstitutionalProposal());
        return new InstitutionalProposalRuleImpl().processInstitutionalProposalRules(event);
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }

    private boolean processCostShareRules(Document document) {
        boolean valid = true;
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        String errorPath = "institutionalProposal";
        int i = 0;
        List<InstitutionalProposalCostShare> costShares = institutionalProposalDocument.getInstitutionalProposal().getInstitutionalProposalCostShares();
        for (InstitutionalProposalCostShare costShare : costShares) {
            InstitutionalProposalAddCostShareRuleEvent event = new InstitutionalProposalAddCostShareRuleEvent(errorPath, institutionalProposalDocument, costShare);
            event.setFieldName("document.institutionalProposalList[0].institutionalProposalCostShares[" + i + "].sourceAccount");
            valid &= new InstitutionalProposalAddCostShareRuleImpl().processInstitutionalProposalCostShareBusinessRules(event, i);
            ++i;
        }
        return valid;
    }

    private boolean processInstitutionalProposalAttachmentsBusinessRules(Document document) {
        boolean valid = true;
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        List<InstitutionalProposalAttachment> instProposalAttachments = institutionalProposalDocument.getInstitutionalProposal().getInstProposalAttachments();
        int index = 0;
        for (InstitutionalProposalAttachment instProposalAttachment : instProposalAttachments) {
            InstitutionalProposalAddAttachmentRuleEvent event = new InstitutionalProposalAddAttachmentRuleEvent("institutionalProposal", institutionalProposalDocument, instProposalAttachment);
            valid &= new InstitutionalProposalAddAttachmentRuleImpl().processSaveInstitutionalProposalAttachment(event, index);
            ++index;
        }
        return valid;
    }

    @Override
    public boolean processCfdaRules(InstitutionalProposalCfdaRuleEvent institutionalProposalCfdaRuleEvent) {
        return new InstitutionalProposalCfdaRuleImpl().processCfdaRules(institutionalProposalCfdaRuleEvent);
    }
}

