/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.IrbActionsKeyValuesBase;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.document.Document;

public class ProtocolReviewerValuesFinder
extends IrbActionsKeyValuesBase {
    private static final long serialVersionUID = 6339476452241934050L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmission submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        Protocol protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            List<org.kuali.kra.protocol.actions.submit.ProtocolReviewer> reviewers = submission.getProtocolReviewers();
            for (ProtocolReviewer protocolReviewer : reviewers) {
                keyValues.add((KeyValue)new ConcreteKeyValue(protocolReviewer.getProtocolReviewerId().toString(), protocolReviewer.getFullName()));
            }
        }
        return keyValues;
    }

    private ProtocolSubmission getCurrentSubmission(Protocol protocol) {
        List<ProtocolSubmissionBase> protocolSubmissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmission protocolSubmission : protocolSubmissions) {
            if (!StringUtils.equals((CharSequence)protocolSubmission.getSubmissionStatusCode(), (CharSequence)"101") && !StringUtils.equals((CharSequence)protocolSubmission.getSubmissionStatusCode(), (CharSequence)"100")) continue;
            return protocolSubmission;
        }
        return null;
    }

    private Protocol getProtocol() {
        Document document = this.getDocument();
        if (document instanceof ProtocolDocument) {
            return ((ProtocolDocument)document).getProtocol();
        }
        return null;
    }
}

