/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.submit.CheckListService;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.springframework.util.AutoPopulatingList;

public class ProtocolSubmitAction
extends ProtocolActionBean
implements org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction {
    private static final long serialVersionUID = -4712974868607781787L;
    private String submissionTypeCode = "";
    private String protocolReviewTypeCode = "";
    private String submissionQualifierTypeCode = "";
    private String committeeId = "";
    private String scheduleId = "";
    private boolean committeeIdChanged = false;
    private boolean scheduleIdChanged = false;
    private boolean reviewerListAvailable = false;
    private int numberOfReviewers = 0;
    private List<ProtocolReviewerBean> reviewers = new AutoPopulatingList(ProtocolReviewerBean.class);
    private List<ExpeditedReviewCheckListItem> expeditedReviewCheckList = null;
    private List<ExemptStudiesCheckListItem> exemptStudiesCheckList = null;
    private String newCommitteeId = "";
    private String newScheduleId = "";
    private int checkListItemDescriptionIndex = 0;
    private String selectedProtocolReviewTypeCode = null;
    private boolean javascriptEnabled = true;

    public ProtocolSubmitAction() {
    }

    public ProtocolSubmitAction(ActionHelper actionHelper) {
        super(actionHelper);
    }

    @Override
    public void prepareView() {
        if (this.expeditedReviewCheckList == null) {
            this.expeditedReviewCheckList = this.getCheckListService().getExpeditedReviewCheckList();
            this.exemptStudiesCheckList = this.getCheckListService().getExemptStudiesCheckList();
        }
        if (!this.getJavascriptEnabled()) {
            if (!(StringUtils.isBlank((CharSequence)this.committeeId) || this.committeeIdChanged || StringUtils.isBlank((CharSequence)this.scheduleId))) {
                if (this.scheduleIdChanged) {
                    this.reviewers.clear();
                    this.buildReviewers();
                }
            } else {
                this.reviewers.clear();
                this.reviewerListAvailable = false;
            }
        } else {
            this.reviewers.subList(this.numberOfReviewers, this.reviewers.size()).clear();
        }
    }

    private void buildReviewers() {
        this.reviewerListAvailable = true;
        List<CommitteeMembershipBase> members = this.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(this.committeeId, this.scheduleId));
        for (CommitteeMembershipBase member : members) {
            ProtocolReviewerBean reviewer = new ProtocolReviewerBean((CommitteeMembership)member);
            this.reviewers.add(reviewer);
        }
    }

    @Override
    public void setNumberOfReviewers(int numberOfReviewers) {
        this.numberOfReviewers = numberOfReviewers;
    }

    @Override
    public CommitteeService getCommitteeService() {
        return KcServiceLocator.getService(CommitteeService.class);
    }

    @Override
    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    @Override
    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    @Override
    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    @Override
    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    @Override
    public String getSubmissionQualifierTypeCode() {
        return this.submissionQualifierTypeCode;
    }

    @Override
    public void setSubmissionQualifierTypeCode(String submissionQualifierTypeCode) {
        this.submissionQualifierTypeCode = submissionQualifierTypeCode;
    }

    @Override
    public String getCommitteeId() {
        return this.committeeId;
    }

    @Override
    public void setCommitteeId(String committeeId) {
        this.committeeIdChanged = true;
        if (StringUtils.equals((CharSequence)this.committeeId, (CharSequence)committeeId)) {
            this.committeeIdChanged = false;
        }
        this.committeeId = committeeId;
        this.newCommitteeId = committeeId;
    }

    @Override
    public void setNewCommitteeId(String id) {
        this.newCommitteeId = id;
    }

    @Override
    public String getNewCommitteeId() {
        return this.newCommitteeId;
    }

    @Override
    public String getScheduleId() {
        return this.scheduleId;
    }

    @Override
    public void setScheduleId(String scheduleId) {
        this.scheduleIdChanged = true;
        if (StringUtils.equals((CharSequence)this.scheduleId, (CharSequence)scheduleId)) {
            this.scheduleIdChanged = false;
        }
        this.scheduleId = scheduleId;
        this.newScheduleId = scheduleId;
    }

    @Override
    public String getNewScheduleId() {
        return this.newScheduleId;
    }

    @Override
    public boolean isReviewerListAvailable() {
        return this.reviewerListAvailable;
    }

    @Override
    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    @Override
    public ProtocolReviewerBean getReviewer(int i) {
        return this.reviewers.get(i);
    }

    @Override
    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add(this.reviewers.get(i));
        }
        return leftReviewers;
    }

    @Override
    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add(this.reviewers.get(i));
        }
        return rightReviewers;
    }

    @Override
    public void setReviewers(List<ProtocolReviewerBeanBase> reviewerBeans) {
        this.reviewers = reviewerBeans;
    }

    public void setExpeditedReviewCheckList(List<ExpeditedReviewCheckListItem> checkList) {
        this.expeditedReviewCheckList = checkList;
    }

    public List<ExpeditedReviewCheckListItem> getExpeditedReviewCheckList() {
        return this.expeditedReviewCheckList;
    }

    public void setExemptStudiesCheckList(List<ExemptStudiesCheckListItem> checkList) {
        this.exemptStudiesCheckList = checkList;
    }

    public List<ExemptStudiesCheckListItem> getExemptStudiesCheckList() {
        return this.exemptStudiesCheckList;
    }

    public void setCheckListItemDescriptionInfo(String protocolReviewTypeCode, int index) {
        this.selectedProtocolReviewTypeCode = protocolReviewTypeCode;
        this.checkListItemDescriptionIndex = index;
    }

    public String getCheckListItemDescription() {
        if ("2".equals(this.selectedProtocolReviewTypeCode)) {
            return this.getExpeditedReviewCheckList().get(this.checkListItemDescriptionIndex).getDescription();
        }
        if ("3".equals(this.selectedProtocolReviewTypeCode)) {
            return this.getExemptStudiesCheckList().get(this.checkListItemDescriptionIndex).getDescription();
        }
        return "";
    }

    private CheckListService getCheckListService() {
        return KcServiceLocator.getService(CheckListService.class);
    }

    @Override
    public boolean getJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    @Override
    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
    }

    public boolean isExpeditedProtocolReviewType() {
        boolean retVal = false;
        if ("2".equals(this.getProtocolReviewTypeCode())) {
            retVal = true;
        }
        return retVal;
    }
}

