/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.correspondence;

import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolCorrespondenceAuthorizationServiceImplBase
implements ProtocolCorrespondenceAuthorizationService {
    private static final String VIEW_PROTOCOL_CORRESPONDENCE_TASK_NAME = "viewProtocolCorrespondence";
    private static final String MODIFY_PROTOCOL_CORRESPONDENCE_TASK_NAME = "modifyProtocolCorrespondence";
    private static final String CREATE_PROTOCOL_CORRESPONDENCE_TASK_NAME = "createProtocolCorrespondence";
    protected TaskAuthorizationService taskAuthorizationService;

    protected boolean hasPermission(String taskName, ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewProtocolTaskInstanceHook(taskName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        if (this.taskAuthorizationService == null) {
            this.taskAuthorizationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        }
        return this.taskAuthorizationService;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected abstract ProtocolTaskBase getNewProtocolTaskInstanceHook(String var1, ProtocolBase var2);

    @Override
    public boolean isAllowedToViewProtocolCorrespondence(ProtocolBase protocol) {
        return this.hasPermission(VIEW_PROTOCOL_CORRESPONDENCE_TASK_NAME, protocol) || this.isAllowedToUpdateProtocolCorrespondence(protocol);
    }

    @Override
    public boolean isAllowedToUpdateProtocolCorrespondence(ProtocolBase protocol) {
        return this.hasPermission(MODIFY_PROTOCOL_CORRESPONDENCE_TASK_NAME, protocol) || this.isAllowedToRegenerateProtocolCorrespondence(protocol);
    }

    @Override
    public boolean isAllowedToRegenerateProtocolCorrespondence(ProtocolBase protocol) {
        return this.hasPermission(CREATE_PROTOCOL_CORRESPONDENCE_TASK_NAME, protocol);
    }
}

