/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.editable.PersonEditable;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.personnel.ProtocolAffiliationTypeBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public abstract class ProtocolPersonBase
extends ProtocolAssociateBase
implements PersonEditable,
AbstractPersonRoleAware {
    private static final long serialVersionUID = -1140730616386093202L;
    private Integer protocolPersonId;
    private String personId;
    private String personName;
    private String protocolPersonRoleId;
    private Integer rolodexId;
    private Integer affiliationTypeCode;
    private String comments;
    private ProtocolAffiliationTypeBase affiliationType;
    private ProtocolPersonRoleBase protocolPersonRole;
    private ProtocolPersonRolodexBase rolodex;
    private boolean delete;
    private boolean trained;
    private List<ProtocolUnitBase> protocolUnits = new ArrayList<ProtocolUnitBase>();
    private List<ProtocolAttachmentPersonnelBase> attachmentPersonnels = new ArrayList<ProtocolAttachmentPersonnelBase>();
    private int selectedUnit;
    private String previousPersonRoleId;
    private transient KcPersonService kcPersonService;
    private transient KcPerson kcPerson;
    private String socialSecurityNumber;
    private String lastName;
    private String firstName;
    private String middleName;
    private String fullName;
    private String priorName;
    private String userName;
    private String emailAddress;
    private Date dateOfBirth;
    private Integer age;
    private Integer ageByFiscalYear;
    private String gender;
    private String race;
    private String educationLevel;
    private String degree;
    private String major;
    private Boolean handicappedFlag;
    private String handicapType;
    private Boolean veteranFlag;
    private String veteranType;
    private String visaCode;
    private String visaType;
    private Date visaRenewalDate;
    private Boolean hasVisa;
    private String officeLocation;
    private String officePhone;
    private String secondaryOfficeLocation;
    private String secondaryOfficePhone;
    private String school;
    private String yearGraduated;
    private String directoryDepartment;
    private String saluation;
    private String countryOfCitizenship;
    private String primaryTitle;
    private String directoryTitle;
    private String homeUnit;
    private Boolean facultyFlag;
    private Boolean graduateStudentStaffFlag;
    private Boolean researchStaffFlag;
    private Boolean serviceStaffFlag;
    private Boolean supportStaffFlag;
    private Boolean otherAcademicGroupFlag;
    private Boolean medicalStaffFlag;
    private Boolean vacationAccrualFlag;
    private Boolean onSabbaticalFlag;
    private String idProvided;
    private String idVerified;
    private String addressLine1;
    private String addressLine2;
    private String addressLine3;
    private String city;
    private String county;
    private String state;
    private String postalCode;
    private String countryCode;
    private String faxNumber;
    private String pagerNumber;
    private String mobilePhoneNumber;
    private String eraCommonsUserName;
    @Transient
    private Integer citizenshipTypeCode;
    private transient boolean affiliationTypeCodeChanged = false;
    private transient GlobalVariableService globalVariableService;
    private transient PermissionService permissionService;

    public Integer getProtocolPersonId() {
        return this.protocolPersonId;
    }

    public void setProtocolPersonId(Integer protocolPersonId) {
        this.protocolPersonId = protocolPersonId;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getProtocolPersonRoleId() {
        return this.protocolPersonRoleId;
    }

    public void setProtocolPersonRoleId(String protocolPersonRoleId) {
        this.setPreviousPersonRoleId(this.protocolPersonRoleId);
        this.protocolPersonRoleId = protocolPersonRoleId;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    @Override
    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public Integer getAffiliationTypeCode() {
        return this.affiliationTypeCode;
    }

    public void setAffiliationTypeCode(Integer newAffiliationTypeCode) {
        boolean changed = true;
        if (Objects.equals(this.affiliationTypeCode, newAffiliationTypeCode)) {
            changed = false;
        }
        this.affiliationTypeCode = newAffiliationTypeCode;
        if (changed) {
            this.refreshReferenceObject("affiliationType");
            this.setAffiliationTypeCodeChanged(true);
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public ProtocolAffiliationTypeBase getAffiliationType() {
        if (this.affiliationTypeCode != null && this.affiliationType == null) {
            this.refreshReferenceObject("affiliationType");
        }
        return this.affiliationType;
    }

    public void setAffiliationType(ProtocolAffiliationTypeBase affiliationType) {
        this.affiliationType = affiliationType;
    }

    public ProtocolPersonRoleBase getProtocolPersonRole() {
        return this.protocolPersonRole;
    }

    public void setProtocolPersonRoles(ProtocolPersonRoleBase protocolPersonRole) {
        this.protocolPersonRole = protocolPersonRole;
    }

    @Override
    public KcPerson getPerson() {
        if (this.kcPerson == null && this.personId != null) {
            this.kcPerson = this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        return this.kcPerson;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public ProtocolPersonRolodexBase getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(ProtocolPersonRolodexBase rolodex) {
        this.rolodex = rolodex;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isTrained() {
        return this.trained;
    }

    public boolean isUnitRequired() {
        return this.getProtocolPersonRole().isUnitDetailsRequired();
    }

    public void setTrained(boolean trained) {
        this.trained = trained;
    }

    public List<ProtocolUnitBase> getProtocolUnits() {
        return this.protocolUnits;
    }

    public void setProtocolUnits(List<ProtocolUnitBase> protocolUnits) {
        this.protocolUnits = protocolUnits;
    }

    public void addProtocolUnit(ProtocolUnitBase protocolUnit) {
        this.getProtocolUnits().add(protocolUnit);
    }

    public ProtocolUnitBase getProtocolUnit(int index) {
        return this.getProtocolUnits().get(index);
    }

    public int getSelectedUnit() {
        return this.selectedUnit;
    }

    public void setSelectedUnit(int selectedUnit) {
        this.selectedUnit = selectedUnit;
    }

    public void resetAllProtocolLeadUnits() {
        for (ProtocolUnitBase protocolUnit : this.getProtocolUnits()) {
            protocolUnit.setLeadUnitFlag(false);
        }
    }

    public String getPersonKey() {
        return this.getPersonId() == null ? this.getRolodexId().toString() : this.getPersonId();
    }

    public String getPersonUniqueKey() {
        return this.getPersonId() == null ? this.getRolodexId().toString() : this.getPersonId();
    }

    public String getPreviousPersonRoleId() {
        return this.previousPersonRoleId;
    }

    public void setPreviousPersonRoleId(String previousPersonRoleId) {
        this.previousPersonRoleId = previousPersonRoleId;
    }

    public boolean isNonEmployee() {
        return this.rolodexId != null && StringUtils.isNotBlank((CharSequence)this.rolodexId.toString());
    }

    public String getGenericId() {
        return this.isNonEmployee() ? this.rolodexId.toString() : this.personId;
    }

    public ProtocolUnitBase getLeadUnit() {
        ProtocolUnitBase leadUnit = null;
        for (ProtocolUnitBase unit : this.getProtocolUnits()) {
            if (!unit.getLeadUnitFlag()) continue;
            leadUnit = unit;
            break;
        }
        return leadUnit;
    }

    public List<ProtocolAttachmentPersonnelBase> getAttachmentPersonnels() {
        if (this.attachmentPersonnels == null) {
            this.attachmentPersonnels = new ArrayList<ProtocolAttachmentPersonnelBase>();
        }
        return this.attachmentPersonnels;
    }

    public void setAttachmentPersonnels(List<ProtocolAttachmentPersonnelBase> attachmentPersonnels) {
        this.attachmentPersonnels = attachmentPersonnels;
    }

    @Override
    public void postInitHook(ProtocolBase protocol) {
        for (ProtocolAttachmentPersonnelBase attachment : this.attachmentPersonnels) {
            attachment.init(this);
        }
        for (ProtocolUnitBase unit : this.protocolUnits) {
            unit.init(this);
        }
    }

    @Override
    public void resetPersistenceState() {
        this.setProtocolPersonId(null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.affiliationTypeCode == null ? 0 : this.affiliationTypeCode.hashCode());
        result = 31 * result + (this.delete ? 1231 : 1237);
        result = 31 * result + (this.personId == null ? 0 : this.personId.hashCode());
        result = 31 * result + (this.personName == null ? 0 : this.personName.hashCode());
        result = 31 * result + (this.previousPersonRoleId == null ? 0 : this.previousPersonRoleId.hashCode());
        result = 31 * result + (this.protocolPersonId == null ? 0 : this.protocolPersonId.hashCode());
        result = 31 * result + (this.protocolPersonRoleId == null ? 0 : this.protocolPersonRoleId.hashCode());
        result = 31 * result + (this.protocolUnits == null ? 0 : this.protocolUnits.hashCode());
        result = 31 * result + (this.rolodexId == null ? 0 : this.rolodexId.hashCode());
        result = 31 * result + this.selectedUnit;
        result = 31 * result + (this.trained ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolPersonBase other = (ProtocolPersonBase)obj;
        if (this.affiliationTypeCode == null ? other.affiliationTypeCode != null : !this.affiliationTypeCode.equals(other.affiliationTypeCode)) {
            return false;
        }
        if (this.delete != other.delete) {
            return false;
        }
        if (this.personId == null ? other.personId != null : !this.personId.equals(other.personId)) {
            return false;
        }
        if (this.personName == null ? other.personName != null : !this.personName.equals(other.personName)) {
            return false;
        }
        if (this.previousPersonRoleId == null ? other.previousPersonRoleId != null : !this.previousPersonRoleId.equals(other.previousPersonRoleId)) {
            return false;
        }
        if (this.protocolPersonId == null ? other.protocolPersonId != null : !this.protocolPersonId.equals(other.protocolPersonId)) {
            return false;
        }
        if (this.protocolPersonRoleId == null ? other.protocolPersonRoleId != null : !this.protocolPersonRoleId.equals(other.protocolPersonRoleId)) {
            return false;
        }
        if (this.protocolUnits == null ? other.protocolUnits != null : !this.protocolUnits.equals(other.protocolUnits)) {
            return false;
        }
        if (this.rolodexId == null ? other.rolodexId != null : !this.rolodexId.equals(other.rolodexId)) {
            return false;
        }
        if (this.selectedUnit != other.selectedUnit) {
            return false;
        }
        return this.trained == other.trained;
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return StringUtils.equals((CharSequence)this.protocolPersonRoleId, (CharSequence)"PI");
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @Override
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPriorName() {
        return this.priorName;
    }

    @Override
    public void setPriorName(String priorName) {
        this.priorName = priorName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Override
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Integer getAge() {
        return this.age;
    }

    @Override
    public void setAge(Integer age) {
        this.age = age;
    }

    public Integer getAgeByFiscalYear() {
        return this.ageByFiscalYear;
    }

    @Override
    public void setAgeByFiscalYear(Integer ageByFiscalYear) {
        this.ageByFiscalYear = ageByFiscalYear;
    }

    public String getGender() {
        return this.gender;
    }

    @Override
    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getRace() {
        return this.race;
    }

    @Override
    public void setRace(String race) {
        this.race = race;
    }

    public String getEducationLevel() {
        return this.educationLevel;
    }

    @Override
    public void setEducationLevel(String educationLevel) {
        this.educationLevel = educationLevel;
    }

    public String getDegree() {
        return this.degree;
    }

    @Override
    public void setDegree(String degree) {
        this.degree = degree;
    }

    public String getMajor() {
        return this.major;
    }

    @Override
    public void setMajor(String major) {
        this.major = major;
    }

    public Boolean getHandicappedFlag() {
        return this.handicappedFlag;
    }

    @Override
    public void setHandicappedFlag(Boolean handicappedFlag) {
        this.handicappedFlag = handicappedFlag;
    }

    public String getHandicapType() {
        return this.handicapType;
    }

    @Override
    public void setHandicapType(String handicapType) {
        this.handicapType = handicapType;
    }

    public Boolean getVeteranFlag() {
        return this.veteranFlag;
    }

    @Override
    public void setVeteranFlag(Boolean veteranFlag) {
        this.veteranFlag = veteranFlag;
    }

    public String getVeteranType() {
        return this.veteranType;
    }

    @Override
    public void setVeteranType(String veteranType) {
        this.veteranType = veteranType;
    }

    public String getVisaCode() {
        return this.visaCode;
    }

    @Override
    public void setVisaCode(String visaCode) {
        this.visaCode = visaCode;
    }

    public String getVisaType() {
        return this.visaType;
    }

    @Override
    public void setVisaType(String visaType) {
        this.visaType = visaType;
    }

    public Date getVisaRenewalDate() {
        return this.visaRenewalDate;
    }

    @Override
    public void setVisaRenewalDate(Date visaRenewalDate) {
        this.visaRenewalDate = visaRenewalDate;
    }

    public Boolean getHasVisa() {
        return this.hasVisa;
    }

    @Override
    public void setHasVisa(Boolean hasVisa) {
        this.hasVisa = hasVisa;
    }

    public String getOfficeLocation() {
        return this.officeLocation;
    }

    @Override
    public void setOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
    }

    public String getOfficePhone() {
        return this.officePhone;
    }

    @Override
    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone;
    }

    public String getSecondaryOfficeLocation() {
        return this.secondaryOfficeLocation;
    }

    @Override
    public void setSecondaryOfficeLocation(String secondaryOfficeLocation) {
        this.secondaryOfficeLocation = secondaryOfficeLocation;
    }

    public String getSecondaryOfficePhone() {
        return this.secondaryOfficePhone;
    }

    @Override
    public void setSecondaryOfficePhone(String secondaryOfficePhone) {
        this.secondaryOfficePhone = secondaryOfficePhone;
    }

    public String getSchool() {
        return this.school;
    }

    @Override
    public void setSchool(String school) {
        this.school = school;
    }

    public String getYearGraduated() {
        return this.yearGraduated;
    }

    @Override
    public void setYearGraduated(String yearGraduated) {
        this.yearGraduated = yearGraduated;
    }

    public String getDirectoryDepartment() {
        return this.directoryDepartment;
    }

    @Override
    public void setDirectoryDepartment(String directoryDepartment) {
        this.directoryDepartment = directoryDepartment;
    }

    public String getSaluation() {
        return this.saluation;
    }

    @Override
    public void setSaluation(String saluation) {
        this.saluation = saluation;
    }

    public String getCountryOfCitizenship() {
        return this.countryOfCitizenship;
    }

    @Override
    public void setCountryOfCitizenship(String countryOfCitizenship) {
        this.countryOfCitizenship = countryOfCitizenship;
    }

    public String getPrimaryTitle() {
        return this.primaryTitle;
    }

    @Override
    public void setPrimaryTitle(String primaryTitle) {
        this.primaryTitle = primaryTitle;
    }

    public String getDirectoryTitle() {
        return this.directoryTitle;
    }

    @Override
    public void setDirectoryTitle(String directoryTitle) {
        this.directoryTitle = directoryTitle;
    }

    public String getHomeUnit() {
        return this.homeUnit;
    }

    @Override
    public void setHomeUnit(String homeUnit) {
        this.homeUnit = homeUnit;
    }

    public Boolean getFacultyFlag() {
        return this.facultyFlag;
    }

    @Override
    public void setFacultyFlag(Boolean facultyFlag) {
        this.facultyFlag = facultyFlag;
    }

    public Boolean getGraduateStudentStaffFlag() {
        return this.graduateStudentStaffFlag;
    }

    @Override
    public void setGraduateStudentStaffFlag(Boolean graduateStudentStaffFlag) {
        this.graduateStudentStaffFlag = graduateStudentStaffFlag;
    }

    public Boolean getResearchStaffFlag() {
        return this.researchStaffFlag;
    }

    @Override
    public void setResearchStaffFlag(Boolean researchStaffFlag) {
        this.researchStaffFlag = researchStaffFlag;
    }

    public Boolean getServiceStaffFlag() {
        return this.serviceStaffFlag;
    }

    @Override
    public void setServiceStaffFlag(Boolean serviceStaffFlag) {
        this.serviceStaffFlag = serviceStaffFlag;
    }

    public Boolean getSupportStaffFlag() {
        return this.supportStaffFlag;
    }

    @Override
    public void setSupportStaffFlag(Boolean supportStaffFlag) {
        this.supportStaffFlag = supportStaffFlag;
    }

    public Boolean getOtherAcademicGroupFlag() {
        return this.otherAcademicGroupFlag;
    }

    @Override
    public void setOtherAcademicGroupFlag(Boolean otherAcademicGroupFlag) {
        this.otherAcademicGroupFlag = otherAcademicGroupFlag;
    }

    public Boolean getMedicalStaffFlag() {
        return this.medicalStaffFlag;
    }

    @Override
    public void setMedicalStaffFlag(Boolean medicalStaffFlag) {
        this.medicalStaffFlag = medicalStaffFlag;
    }

    public Boolean getVacationAccrualFlag() {
        return this.vacationAccrualFlag;
    }

    @Override
    public void setVacationAccrualFlag(Boolean vacationAccrualFlag) {
        this.vacationAccrualFlag = vacationAccrualFlag;
    }

    public Boolean getOnSabbaticalFlag() {
        return this.onSabbaticalFlag;
    }

    @Override
    public void setOnSabbaticalFlag(Boolean onSabbaticalFlag) {
        this.onSabbaticalFlag = onSabbaticalFlag;
    }

    public String getIdProvided() {
        return this.idProvided;
    }

    @Override
    public void setIdProvided(String idProvided) {
        this.idProvided = idProvided;
    }

    public String getIdVerified() {
        return this.idVerified;
    }

    @Override
    public void setIdVerified(String idVerified) {
        this.idVerified = idVerified;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Override
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Override
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    @Override
    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return this.county;
    }

    @Override
    public void setCounty(String county) {
        this.county = county;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountryCode() {
        return this.countryCode != null ? this.countryCode.trim() : null;
    }

    @Override
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    @Override
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public String getPagerNumber() {
        return this.pagerNumber;
    }

    @Override
    public void setPagerNumber(String pagerNumber) {
        this.pagerNumber = pagerNumber;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    @Override
    public void setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    public String getEraCommonsUserName() {
        return this.eraCommonsUserName;
    }

    @Override
    public void setEraCommonsUserName(String eraCommonsUserName) {
        this.eraCommonsUserName = eraCommonsUserName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public ProtocolBase getParent() {
        return this.getProtocol();
    }

    @Override
    public String getRoleCode() {
        return this.getProtocolPersonRoleId();
    }

    public void setAffiliationTypeCodeChanged(boolean affiliationTypeCodeChanged) {
        this.affiliationTypeCodeChanged = affiliationTypeCodeChanged;
    }

    public boolean isAffiliationTypeCodeChanged() {
        return this.affiliationTypeCodeChanged;
    }

    public Integer getCitizenshipTypeCode() {
        return this.citizenshipTypeCode;
    }

    @Override
    public void setCitizenshipTypeCode(Integer citizenshipTypeCode) {
        this.citizenshipTypeCode = citizenshipTypeCode;
    }

    protected abstract String getModuleNamespace();

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public boolean getCanViewDisclosureDisposition() {
        String genericId;
        String currentUser = this.getGlobalVariableService().getUserSession().getPerson().getPrincipalId();
        return currentUser.equalsIgnoreCase(genericId = this.getGenericId()) || this.getPermissionService().hasPermission(currentUser, "KC-SYS", "View COI Disclosure Disposition");
    }
}

