/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.reference;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.protocol.protocol.reference.AddProtocolReferenceEventBase;
import org.kuali.kra.protocol.protocol.reference.AddProtocolReferenceRule;

public abstract class ProtocolReferenceRuleBase
extends KcTransactionalDocumentRuleBase
implements AddProtocolReferenceRule {
    @Override
    public boolean processAddProtocolReferenceBusinessRules(AddProtocolReferenceEventBase addProtocolReferenceEvent) {
        boolean rulePassed = true;
        if (null == addProtocolReferenceEvent.getProtocolReferenceBean().getProtocolReferenceTypeCode()) {
            rulePassed = false;
            this.reportError("newProtocolReferenceBean.protocolReferenceTypeCode", "error.required.for.protocolReference.protocolReferenceTypeCode", "Type");
        }
        if (StringUtils.isBlank((CharSequence)addProtocolReferenceEvent.getProtocolReferenceBean().getReferenceKey())) {
            rulePassed = false;
            this.reportError("newProtocolReferenceBean.referenceKey", "error.required.for.protocolReference.protocolReferenceKey", "Other Identifier");
        }
        if (!this.validateDate(addProtocolReferenceEvent.getProtocolReferenceBean().getApplicationDate())) {
            rulePassed = false;
            this.reportError("newProtocolReferenceBean.applicationDate", "error.protocolReferences.date", "Application Date");
        }
        if (!this.validateDate(addProtocolReferenceEvent.getProtocolReferenceBean().getApprovalDate())) {
            rulePassed = false;
            this.reportError("newProtocolReferenceBean.approvalDate", "error.protocolReferences.date", "Approval Date");
        }
        return rulePassed;
    }

    private boolean validateDate(String stringDate) {
        try {
            if (!StringUtils.isBlank((CharSequence)stringDate)) {
                Date date = new Date(DateFormat.getDateInstance(3).parse(stringDate).getTime());
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

