/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.kuali.rice.core.framework.util.ApplicationThreadLocal;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.web.form.UifFormManager;

public final class GlobalVariables {
    private static ThreadLocal<LinkedList<GlobalVariables>> GLOBAL_VARIABLES_STACK = new ApplicationThreadLocal<LinkedList<GlobalVariables>>(){

        protected LinkedList<GlobalVariables> initialValue() {
            LinkedList<GlobalVariables> globalVariablesStack = new LinkedList<GlobalVariables>();
            globalVariablesStack.add(new GlobalVariables());
            return globalVariablesStack;
        }
    };
    private UserSession userSession = null;
    private String hideSessionFromTestsMessage = null;
    private MessageMap messageMap = new MessageMap();
    private Map<String, Object> requestCache = new HashMap<String, Object>();
    private UifFormManager uifFormManager = null;
    private static ThreadLocal<HashMap<String, AuditCluster>> auditErrorMaps = new ApplicationThreadLocal<HashMap<String, AuditCluster>>(){

        protected HashMap<String, AuditCluster> initialValue() {
            return new HashMap<String, AuditCluster>();
        }
    };

    public static GlobalVariables getCurrentGlobalVariables() {
        return GLOBAL_VARIABLES_STACK.get().getLast();
    }

    public static void injectGlobalVariables(GlobalVariables globalVariables) {
        GLOBAL_VARIABLES_STACK.get().add(globalVariables);
    }

    public static GlobalVariables popGlobalVariables() {
        return GLOBAL_VARIABLES_STACK.get().removeLast();
    }

    static GlobalVariables pushGlobalVariables() {
        GlobalVariables vars = new GlobalVariables();
        GLOBAL_VARIABLES_STACK.get().add(vars);
        return vars;
    }

    static void reset() {
        LinkedList<GlobalVariables> stack = GLOBAL_VARIABLES_STACK.get();
        stack.clear();
        stack.add(new GlobalVariables());
    }

    private GlobalVariables() {
    }

    public static UserSession getUserSession() {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        String message = vars.hideSessionFromTestsMessage;
        if (message != null) {
            throw new RuntimeException(message);
        }
        return vars.userSession;
    }

    public static void setHideSessionFromTestsMessage(String message) {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        vars.hideSessionFromTestsMessage = message;
    }

    public static void setUserSession(UserSession userSession) {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        vars.userSession = userSession;
    }

    public static MessageMap getMessageMap() {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        return vars.messageMap;
    }

    public static void mergeErrorMap(MessageMap messageMap) {
        GlobalVariables.getMessageMap().getErrorMessages().putAll(messageMap.getErrorMessages());
        GlobalVariables.getMessageMap().getWarningMessages().putAll(messageMap.getWarningMessages());
        GlobalVariables.getMessageMap().getInfoMessages().putAll(messageMap.getInfoMessages());
    }

    public static void setMessageMap(MessageMap messageMap) {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        vars.messageMap = messageMap;
    }

    public static Object getRequestCache(String cacheName) {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        return vars.requestCache.get(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRequestCache(String cacheName, Object cacheObject) {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        Map<String, Object> map = vars.requestCache;
        synchronized (map) {
            vars.requestCache.put(cacheName, cacheObject);
        }
    }

    public static UifFormManager getUifFormManager() {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        return vars.uifFormManager;
    }

    public static void setUifFormManager(UifFormManager uifFormManager) {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        vars.uifFormManager = uifFormManager;
    }

    public static Map<String, AuditCluster> getAuditErrorMap() {
        return auditErrorMaps.get();
    }

    public static void setAuditErrorMap(HashMap<String, AuditCluster> errorMap) {
        auditErrorMaps.set(errorMap);
    }

    public static void clear() {
        GlobalVariables vars = GlobalVariables.getCurrentGlobalVariables();
        vars.messageMap = new MessageMap();
        vars.requestCache = new HashMap<String, Object>();
        auditErrorMaps.set(new HashMap());
    }

    public static <T> T doInNewGlobalVariables(Callable<T> callable) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(null, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doInNewGlobalVariables(UserSession userSession, Callable<T> callable) throws Exception {
        try {
            GlobalVariables vars = GlobalVariables.pushGlobalVariables();
            if (userSession != null) {
                vars.userSession = userSession;
            }
            T t = callable.call();
            return t;
        }
        finally {
            GlobalVariables.popGlobalVariables();
        }
    }
}

