/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;

public class KrmsNaturalLanguageTemplateLoader {
    private RuleManagementService ruleManagementService = null;

    public RuleManagementService getRuleManagementService() {
        return this.ruleManagementService;
    }

    public void setRuleManagementService(RuleManagementService ruleManagementService) {
        this.ruleManagementService = ruleManagementService;
    }

    public void loadNaturalLanguageTemplate(String id, String languageCode, String naturalLanguageUsageId, String typeId, String template, String componentId, String componentBuilderClass) {
        NaturalLanguageTemplate.Builder bldr = NaturalLanguageTemplate.Builder.create((String)languageCode, (String)naturalLanguageUsageId, (String)template, (String)typeId);
        bldr.setId(id);
        bldr.setActive(true);
        NaturalLanguageTemplate existing = this.findExisting(bldr);
        if (existing == null) {
            this.getRuleManagementService().createNaturalLanguageTemplate(bldr.build());
        } else {
            bldr.setVersionNumber(existing.getVersionNumber());
            this.getRuleManagementService().createNaturalLanguageTemplate(bldr.build());
        }
    }

    private NaturalLanguageTemplate findExisting(NaturalLanguageTemplate.Builder bldr) {
        if (bldr.getId() != null) {
            try {
                return this.getRuleManagementService().getNaturalLanguageTemplate(bldr.getId());
            }
            catch (RiceIllegalArgumentException ex) {
                return null;
            }
        }
        return this.getRuleManagementService().findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(bldr.getLanguageCode(), bldr.getTypeId(), bldr.getNaturalLanguageUsageId());
    }

    public void load() {
        this.loadNaturalLanguageTemplate("10000-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10000", "Course Requirements", "", "");
        this.loadNaturalLanguageTemplate("10001-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10001", "Program Requirements", "", "");
        this.loadNaturalLanguageTemplate("10078-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10078", "Course Offering Requirements", "", "");
        this.loadNaturalLanguageTemplate("10002-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10002", "Enrollment Eligibility", "", "");
        this.loadNaturalLanguageTemplate("10003-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10003", "Credit Constraints", "", "");
        this.loadNaturalLanguageTemplate("10004-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10004", "Schedule Eligibility", "", "");
        this.loadNaturalLanguageTemplate("10005-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10005", "Anti-requisite", "", "");
        this.loadNaturalLanguageTemplate("10006-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10006", "Co-requisite", "", "");
        this.loadNaturalLanguageTemplate("10008-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10008", "Recommended Preparation", "", "");
        this.loadNaturalLanguageTemplate("10009-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10009", "Student Eligiblity", "", "");
        this.loadNaturalLanguageTemplate("10010-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10010", "Student Eligibility and Prerequisites", "", "");
        this.loadNaturalLanguageTemplate("10011-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10011", "Repeatable for Credit", "", "");
        this.loadNaturalLanguageTemplate("10012-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10012", "Restrictions on Credit", "", "");
        this.loadNaturalLanguageTemplate("10013-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10013", "Completion Requirements", "", "");
        this.loadNaturalLanguageTemplate("10014-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10014", "Entrance Requirements", "", "");
        this.loadNaturalLanguageTemplate("10015-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10015", "Satisfactory Progress", "", "");
        this.loadNaturalLanguageTemplate("10016-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10016", "Schedule Eligibility", "", "");
        this.loadNaturalLanguageTemplate("10021", "en", "KS-KRMS-NL-USAGE-1002", "10019", "Must have successfully completed a minimum of 2 courses from (MATH140,MATH111,STAT100)", "", "");
        this.loadNaturalLanguageTemplate("10100-10002-en", "en", "KS-KRMS-NL-USAGE-1002", "10100", "NumberOfCompletedCourses", "", "");
        this.loadNaturalLanguageTemplate("10101-10002-en", "en", "KS-KRMS-NL-USAGE-1002", "10101", "less than or equal to", "", "");
        this.loadNaturalLanguageTemplate("10102-10002-en", "en", "KS-KRMS-NL-USAGE-1002", "10102", "1", "", "");
        this.loadNaturalLanguageTemplate("10104-10002-en", "en", "KS-KRMS-NL-USAGE-1002", "10104", "A 32 digit UUID or sequence number", "", "");
        this.loadNaturalLanguageTemplate("10090", "en", "KS-KRMS-NL-USAGE-1004", "10019", "Must have successfully completed a minimum of <n> courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10100-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10100", "A term that resolves into the number of courses that a student has completed from a specified set of courses", "", "");
        this.loadNaturalLanguageTemplate("10101-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10101", "Less than or equal to comparison operator", "", "");
        this.loadNaturalLanguageTemplate("10102-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10102", "A constant numeric value N", "", "");
        this.loadNaturalLanguageTemplate("10104-10004-en", "en", "KS-KRMS-NL-USAGE-1004", "10104", "The ID of a course set", "", "");
        this.loadNaturalLanguageTemplate("10375", "en", "KS-KRMS-NL-USAGE-1000", "KS-KRMS-NL-USAGE-1019", "#if($intValue == 1 && $courseCluSet.getCluList().size() == 1)Must have successfully completed $courseCluSet.getCluSetAsCode()#{else}Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") from $courseCluSet.getCluSetAsCode()#end", "", "");
        this.loadNaturalLanguageTemplate("10100-10000-en", "en", "KS-KRMS-NL-USAGE-1000", "10100", "NumberOfCompletedCourses", "", "");
        this.loadNaturalLanguageTemplate("10101-10000-en", "en", "KS-KRMS-NL-USAGE-1000", "10101", "<=", "", "");
        this.loadNaturalLanguageTemplate("10102-10000-en", "en", "KS-KRMS-NL-USAGE-1000", "10102", "1", "KRMS-NumberOfCourses-ConstantValue", "");
        this.loadNaturalLanguageTemplate("10104-10000-en", "en", "KS-KRMS-NL-USAGE-1000", "10104", "CourseSetId", "KRMS-MultiCourse-Section", "org.kuali.student.enrollment.class1.krms.builder.MultiCourseComponentBuilder");
        this.loadNaturalLanguageTemplate("10336", "en", "KS-KRMS-NL-USAGE-1003", "10019", "#if($intValue == 1 && $courseCluSet.getCluList().size() == 1)Must have successfully completed#{else}Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") from#end", "", "");
        this.loadNaturalLanguageTemplate("10000", "en", "KS-KRMS-NL-USAGE-1002", "10056", "Student cannot add Activity Offering with Draft of Cancelled", "", "");
        this.loadNaturalLanguageTemplate("10001", "en", "KS-KRMS-NL-USAGE-1002", "10057", "May not repeat MATH140", "", "");
        this.loadNaturalLanguageTemplate("10002", "en", "KS-KRMS-NL-USAGE-1002", "10058", "May not repeat any of (MATH140, MATH241)", "", "");
        this.loadNaturalLanguageTemplate("10003", "en", "KS-KRMS-NL-USAGE-1002", "10034", "Permission of instructor required", "", "");
        this.loadNaturalLanguageTemplate("10004", "en", "KS-KRMS-NL-USAGE-1002", "10031", "Free Form Text", "", "");
        this.loadNaturalLanguageTemplate("10006", "en", "KS-KRMS-NL-USAGE-1002", "10035", "Student cannot drop course without permission of Music Dept", "", "");
        this.loadNaturalLanguageTemplate("10007", "en", "KS-KRMS-NL-USAGE-1002", "10042", "If student is Athlete AND upon drop total credit hours would be less than 12 credit hours, prevent drop", "", "");
        this.loadNaturalLanguageTemplate("10008", "en", "KS-KRMS-NL-USAGE-1002", "10043", "If upon drop, total credit hours would be less than 12 credit hours, prevent course drop", "", "");
        this.loadNaturalLanguageTemplate("10009", "en", "KS-KRMS-NL-USAGE-1002", "10044", "Course has more than 10 minutes overlap with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10010", "en", "KS-KRMS-NL-USAGE-1002", "10045", "Course has less than 5 minutes between start time or end time with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10011", "en", "KS-KRMS-NL-USAGE-1002", "10046", "Student in Music Performance can enrol in a maximum of 3 courses for the term", "", "");
        this.loadNaturalLanguageTemplate("10012", "en", "KS-KRMS-NL-USAGE-1002", "10047", "Student in Music Performance can enrol in a maximum of 12 credits for the term", "", "");
        this.loadNaturalLanguageTemplate("10015", "en", "KS-KRMS-NL-USAGE-1002", "10059", "Student is in an existing seat pool for the course with an available seat", "", "");
        this.loadNaturalLanguageTemplate("10016", "en", "KS-KRMS-NL-USAGE-1002", "10017", "Must have successfully completed MATH140", "", "");
        this.loadNaturalLanguageTemplate("10017", "en", "KS-KRMS-NL-USAGE-1002", "10060", "Must have successfully completed MATH140 as of <term>", "", "");
        this.loadNaturalLanguageTemplate("10018", "en", "KS-KRMS-NL-USAGE-1002", "10061", "Must have successfully completed MATH140 prior to <term>", "", "");
        this.loadNaturalLanguageTemplate("10019", "en", "KS-KRMS-NL-USAGE-1002", "10062", "Must have successfully completed MATH140 between <term1> and <term2>", "", "");
        this.loadNaturalLanguageTemplate("10022", "en", "KS-KRMS-NL-USAGE-1002", "10018", "Must have successfully completed all courses from (MATH140,STAT100)", "", "");
        this.loadNaturalLanguageTemplate("10023", "en", "KS-KRMS-NL-USAGE-1002", "10054", "Must have successfully completed a minimum of 3 credits from MATH140", "", "");
        this.loadNaturalLanguageTemplate("10024", "en", "KS-KRMS-NL-USAGE-1002", "10055", "Must have successfully completed a minimum of 3 credits from courses in the Music Dept", "", "");
        this.loadNaturalLanguageTemplate("10025", "en", "KS-KRMS-NL-USAGE-1002", "10040", "Must have earned a minimum cumulative GPA of 3.12", "", "");
        this.loadNaturalLanguageTemplate("10026", "en", "KS-KRMS-NL-USAGE-1002", "10041", "Must have earned a minimum Cumulative GPA of 3.12 in Fall 2012", "", "");
        this.loadNaturalLanguageTemplate("10027", "en", "KS-KRMS-NL-USAGE-1002", "10025", "Must have earned a minimum GPA of 2.5  in (MATH140,MATH111)", "", "");
        this.loadNaturalLanguageTemplate("10028", "en", "KS-KRMS-NL-USAGE-1002", "10027", "Must have earned a minimum grade of Letter B in (MATH140,MATH111)", "", "");
        this.loadNaturalLanguageTemplate("10029", "en", "KS-KRMS-NL-USAGE-1002", "10028", "Must successfully complete a minimum of 2 courses  from (MATH140,MATH111,STAT100) with a minimum grade of Letter C", "", "");
        this.loadNaturalLanguageTemplate("10030", "en", "KS-KRMS-NL-USAGE-1002", "10026", "Must not have earned a grade of Letter D or higher in (MATH140,MATH111)", "", "");
        this.loadNaturalLanguageTemplate("10031", "en", "KS-KRMS-NL-USAGE-1002", "10038", "Must have achieved a minimum score of <score> on <tests>", "", "");
        this.loadNaturalLanguageTemplate("10032", "en", "KS-KRMS-NL-USAGE-1002", "10037", "Must have achieved a score no higher than <score> on <tests>", "", "");
        this.loadNaturalLanguageTemplate("10033", "en", "KS-KRMS-NL-USAGE-1002", "10032", "Must not have successfully completed MATH111", "", "");
        this.loadNaturalLanguageTemplate("10034", "en", "KS-KRMS-NL-USAGE-1002", "10020", "Must not have successfully completed any courses from MATH140", "", "");
        this.loadNaturalLanguageTemplate("10035", "en", "KS-KRMS-NL-USAGE-1002", "10022", "Must not have successfully completed any credits from (MATH111,MATH140)", "", "");
        this.loadNaturalLanguageTemplate("10036", "en", "KS-KRMS-NL-USAGE-1002", "10021", "Must successfully complete no more than 4 credits from (MATH111,MATH140)", "", "");
        this.loadNaturalLanguageTemplate("10037", "en", "KS-KRMS-NL-USAGE-1002", "10053", "Must have successfully completed no more than 2 courses from (MATH111,MATH140)", "", "");
        this.loadNaturalLanguageTemplate("10038", "en", "KS-KRMS-NL-USAGE-1002", "10030", "Must be concurrently enrolled in MATH140", "", "");
        this.loadNaturalLanguageTemplate("10039", "en", "KS-KRMS-NL-USAGE-1002", "10024", "Must be concurrently enrolled in a minimum of 2 courses from (MATH111,MATH140)", "", "");
        this.loadNaturalLanguageTemplate("10040", "en", "KS-KRMS-NL-USAGE-1002", "10023", "Must be concurrently enrolled in all courses from (MATH111,MATH140)", "", "");
        this.loadNaturalLanguageTemplate("10041", "en", "KS-KRMS-NL-USAGE-1002", "10039", "Must have earned a minimum of 6 total credits", "", "");
        this.loadNaturalLanguageTemplate("10042", "en", "KS-KRMS-NL-USAGE-1002", "10029", "May be repeater for a maximum of 8 credits", "", "");
        this.loadNaturalLanguageTemplate("10043", "en", "KS-KRMS-NL-USAGE-1002", "10050", "Students admitted to South Campus may take no more than 3 courses at North Campus in 1 Year", "", "");
        this.loadNaturalLanguageTemplate("10044", "en", "KS-KRMS-NL-USAGE-1002", "10051", "Students admitted to North Campus may take no more than 8 credits at South Campus in 1 Year", "", "");
        this.loadNaturalLanguageTemplate("10045", "en", "KS-KRMS-NL-USAGE-1002", "10052", "Must have been admitted to the Sociology Program", "", "");
        this.loadNaturalLanguageTemplate("10046", "en", "KS-KRMS-NL-USAGE-1002", "10033", "Must be admitted to any Program offered at the course campus location", "", "");
        this.loadNaturalLanguageTemplate("10047", "en", "KS-KRMS-NL-USAGE-1002", "10036", "Must not have been admitted to the Sociology Program", "", "");
        this.loadNaturalLanguageTemplate("10048", "en", "KS-KRMS-NL-USAGE-1002", "10064", "Must not have been admitted to the Sociology Program with a class standing of <Class Standing>", "", "");
        this.loadNaturalLanguageTemplate("10049", "en", "KS-KRMS-NL-USAGE-1002", "10065", "Must have been admitted to a Program offered by Music Dept", "", "");
        this.loadNaturalLanguageTemplate("10050", "en", "KS-KRMS-NL-USAGE-1002", "10066", "Student must be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10051", "en", "KS-KRMS-NL-USAGE-1002", "10067", "Student must be in a class standing of <class standing> or greater", "", "");
        this.loadNaturalLanguageTemplate("10052", "en", "KS-KRMS-NL-USAGE-1002", "10068", "Student must be in a class standing of <class standing> or less", "", "");
        this.loadNaturalLanguageTemplate("10053", "en", "KS-KRMS-NL-USAGE-1002", "10069", "Must not be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10055", "en", "KS-KRMS-NL-USAGE-1002", "10071", "Must be concurrently enrolled in (MATH111,MATH140)", "", "");
        this.loadNaturalLanguageTemplate("10056", "en", "KS-KRMS-NL-USAGE-1002", "10072", "May not repeat MATH111 if repeated 2 times", "", "");
        this.loadNaturalLanguageTemplate("10057", "en", "KS-KRMS-NL-USAGE-1002", "10074", "Must have achieved a score between <score> and <score> on <test>", "", "");
        this.loadNaturalLanguageTemplate("10058", "en", "KS-KRMS-NL-USAGE-1002", "10075", "Must have achieved a score of <score> on <test>", "", "");
        this.loadNaturalLanguageTemplate("10059", "en", "KS-KRMS-NL-USAGE-1004", "10002", "Enrollment Eligibility", "", "");
        this.loadNaturalLanguageTemplate("10060", "en", "KS-KRMS-NL-USAGE-1004", "10003", "Credit Constraints", "", "");
        this.loadNaturalLanguageTemplate("10061", "en", "KS-KRMS-NL-USAGE-1004", "10005", "Antirequisite", "", "");
        this.loadNaturalLanguageTemplate("10062", "en", "KS-KRMS-NL-USAGE-1004", "10006", "Corequisite", "", "");
        this.loadNaturalLanguageTemplate("10064", "en", "KS-KRMS-NL-USAGE-1004", "10009", "Student Eligibility", "", "");
        this.loadNaturalLanguageTemplate("10065", "en", "KS-KRMS-NL-USAGE-1004", "10008", "Recommended Preparation", "", "");
        this.loadNaturalLanguageTemplate("10066", "en", "KS-KRMS-NL-USAGE-1004", "10010", "Student Eligibility & Prerequisite", "", "");
        this.loadNaturalLanguageTemplate("10067", "en", "KS-KRMS-NL-USAGE-1004", "10011", "Repeatable for Credit", "", "");
        this.loadNaturalLanguageTemplate("10068", "en", "KS-KRMS-NL-USAGE-1004", "10012", "Restricted for Credit", "", "");
        this.loadNaturalLanguageTemplate("10069", "en", "KS-KRMS-NL-USAGE-1004", "10056", "Student cannot add Activity Offering with <Activity Offering State>  of <state>", "", "");
        this.loadNaturalLanguageTemplate("10070", "en", "KS-KRMS-NL-USAGE-1004", "10057", "May not repeat <course>", "", "");
        this.loadNaturalLanguageTemplate("10071", "en", "KS-KRMS-NL-USAGE-1004", "10058", "May not repeat any of  <courses>", "", "");
        this.loadNaturalLanguageTemplate("10072", "en", "KS-KRMS-NL-USAGE-1004", "10034", "Permission of instructor required", "", "");
        this.loadNaturalLanguageTemplate("10073", "en", "KS-KRMS-NL-USAGE-1004", "10031", "Free Form Text", "", "");
        this.loadNaturalLanguageTemplate("10075", "en", "KS-KRMS-NL-USAGE-1004", "10035", "Student cannot drop course without permission of <administering org>", "", "");
        this.loadNaturalLanguageTemplate("10076", "en", "KS-KRMS-NL-USAGE-1004", "10042", "If student is <attribute> AND upon drop total credit hours would be less than <min credit hours>, prevent drop", "", "");
        this.loadNaturalLanguageTemplate("10077", "en", "KS-KRMS-NL-USAGE-1004", "10043", "If upon drop, total credit hours would be less than <min credit hours>, prevent course drop", "", "");
        this.loadNaturalLanguageTemplate("10078", "en", "KS-KRMS-NL-USAGE-1004", "10044", "Course has more than <n> minutes overlap with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10079", "en", "KS-KRMS-NL-USAGE-1004", "10045", "Course has less than <n> minutes between start time or end time with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10080", "en", "KS-KRMS-NL-USAGE-1004", "10046", "Student in <Program> can enrol in a maximum of <n> courses for the term", "", "");
        this.loadNaturalLanguageTemplate("10081", "en", "KS-KRMS-NL-USAGE-1004", "10047", "Student in <Program> can enrol in a maximum of <n> credits for the term", "", "");
        this.loadNaturalLanguageTemplate("10084", "en", "KS-KRMS-NL-USAGE-1004", "10059", "Student is in an existing seat pool for the course with an available seat", "", "");
        this.loadNaturalLanguageTemplate("10085", "en", "KS-KRMS-NL-USAGE-1004", "10017", "Must have successfully completed <course>", "", "");
        this.loadNaturalLanguageTemplate("10086", "en", "KS-KRMS-NL-USAGE-1004", "10060", "Must have successfully completed <course> as of <term>", "", "");
        this.loadNaturalLanguageTemplate("10087", "en", "KS-KRMS-NL-USAGE-1004", "10061", "Must have successfully completed <course> prior to <term>", "", "");
        this.loadNaturalLanguageTemplate("10088", "en", "KS-KRMS-NL-USAGE-1004", "10062", "Must have successfully completed <course> between <term1> and <term2>", "", "");
        this.loadNaturalLanguageTemplate("10091", "en", "KS-KRMS-NL-USAGE-1004", "10018", "Must have successfully completed all courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10092", "en", "KS-KRMS-NL-USAGE-1004", "10054", "Must have successfully completed a minimum of <n> credits from <course>", "", "");
        this.loadNaturalLanguageTemplate("10093", "en", "KS-KRMS-NL-USAGE-1004", "10055", "Must have successfully completed a minimum of <n> credits from courses in the <org>", "", "");
        this.loadNaturalLanguageTemplate("10094", "en", "KS-KRMS-NL-USAGE-1004", "10040", "Must have earned a minimum cumulative GPA of <GPA>", "", "");
        this.loadNaturalLanguageTemplate("10095", "en", "KS-KRMS-NL-USAGE-1004", "10041", "Must have earned a minimum Cumulative GPA of <GPA> in <duration>", "", "");
        this.loadNaturalLanguageTemplate("10096", "en", "KS-KRMS-NL-USAGE-1004", "10025", "Must have earned a minimum GPA of <GPA>  in <courses>", "", "");
        this.loadNaturalLanguageTemplate("10097", "en", "KS-KRMS-NL-USAGE-1004", "10027", "Must have earned a minimum grade of <gradeType> <grade> in  <courses>", "", "");
        this.loadNaturalLanguageTemplate("10098", "en", "KS-KRMS-NL-USAGE-1004", "10028", "Must successfully complete a minimum of <n> courses  from <courses> with a minimum grade of <gradeType> <grade>", "", "");
        this.loadNaturalLanguageTemplate("10099", "en", "KS-KRMS-NL-USAGE-1004", "10026", "Must not have earned a grade of <gradeType> <grade> or higher in <courses>", "", "");
        this.loadNaturalLanguageTemplate("10100", "en", "KS-KRMS-NL-USAGE-1004", "10038", "Must have achieved a minimum score of <score> on <tests>", "", "");
        this.loadNaturalLanguageTemplate("10101", "en", "KS-KRMS-NL-USAGE-1004", "10037", "Must have achieved a score no higher than <score> on <tests>", "", "");
        this.loadNaturalLanguageTemplate("10102", "en", "KS-KRMS-NL-USAGE-1004", "10032", "Must not have successfully completed <course>", "", "");
        this.loadNaturalLanguageTemplate("10103", "en", "KS-KRMS-NL-USAGE-1004", "10020", "Must not have successfully completed any courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10104", "en", "KS-KRMS-NL-USAGE-1004", "10022", "Must not have successfully completed any credits from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10105", "en", "KS-KRMS-NL-USAGE-1004", "10021", "Must successfully complete no more than  <n> credits from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10106", "en", "KS-KRMS-NL-USAGE-1004", "10053", "Must have successfully completed no more than <n> courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10107", "en", "KS-KRMS-NL-USAGE-1004", "10030", "Must be concurrently enrolled in <course>", "", "");
        this.loadNaturalLanguageTemplate("10108", "en", "KS-KRMS-NL-USAGE-1004", "10024", "Must be concurrently enrolled in a minimum of <n> courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10109", "en", "KS-KRMS-NL-USAGE-1004", "10023", "Must be concurrently enrolled in all courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10110", "en", "KS-KRMS-NL-USAGE-1004", "10039", "Must have earned a minimum of <n> total credits", "", "");
        this.loadNaturalLanguageTemplate("10111", "en", "KS-KRMS-NL-USAGE-1004", "10029", "May be repeater for a maximum of <n> credits", "", "");
        this.loadNaturalLanguageTemplate("10112", "en", "KS-KRMS-NL-USAGE-1004", "10050", "Students admitted to <campus> may take no more than <n> courses at <campus> in <duration> <durationType>", "", "");
        this.loadNaturalLanguageTemplate("10113", "en", "KS-KRMS-NL-USAGE-1004", "10051", "Students admitted to <campus> may take no more than <n  credits> at <campus> in <duration> <durationType>", "", "");
        this.loadNaturalLanguageTemplate("10114", "en", "KS-KRMS-NL-USAGE-1004", "10052", "Must have been admitted to the <Program> Program", "", "");
        this.loadNaturalLanguageTemplate("10115", "en", "KS-KRMS-NL-USAGE-1004", "10033", "Must be admitted to any Program offered at the course campus location", "", "");
        this.loadNaturalLanguageTemplate("10116", "en", "KS-KRMS-NL-USAGE-1004", "10036", "Must not have been admitted to the <Program> Program", "", "");
        this.loadNaturalLanguageTemplate("10117", "en", "KS-KRMS-NL-USAGE-1004", "10064", "Must not have been admitted to the <Program> Program with a class standing of <Class Standing>", "", "");
        this.loadNaturalLanguageTemplate("10118", "en", "KS-KRMS-NL-USAGE-1004", "10065", "Must have been admitted to a Program offered by <Org>", "", "");
        this.loadNaturalLanguageTemplate("10119", "en", "KS-KRMS-NL-USAGE-1004", "10066", "Student must be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10120", "en", "KS-KRMS-NL-USAGE-1004", "10067", "Student must be in a class standing of <class standing> or greater", "", "");
        this.loadNaturalLanguageTemplate("10121", "en", "KS-KRMS-NL-USAGE-1004", "10068", "Student must be in a class standing of <class standing> or less", "", "");
        this.loadNaturalLanguageTemplate("10122", "en", "KS-KRMS-NL-USAGE-1004", "10069", "Must not be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10124", "en", "KS-KRMS-NL-USAGE-1004", "10071", "Must be concurrently enrolled in <courses>", "", "");
        this.loadNaturalLanguageTemplate("10125", "en", "KS-KRMS-NL-USAGE-1004", "10072", "May not repeat <course> if repeated <n> times", "", "");
        this.loadNaturalLanguageTemplate("10126", "en", "KS-KRMS-NL-USAGE-1004", "10074", "Must have achieved a score between <score> and <score> on <test>", "", "");
        this.loadNaturalLanguageTemplate("10127", "en", "KS-KRMS-NL-USAGE-1004", "10075", "Must have achieved a score of <score> on <test>", "", "");
        this.loadNaturalLanguageTemplate("10128", "en", "KS-KRMS-NL-USAGE-1000", "10035", "Permission of $org.getLongName() required", "", "");
        this.loadNaturalLanguageTemplate("10129", "en", "KS-KRMS-NL-USAGE-1000", "10034", "Permission of instructor required", "", "");
        this.loadNaturalLanguageTemplate("10130", "en", "KS-KRMS-NL-USAGE-1000", "10038", "Must have achieved a minimum score of $fields.get('kuali.reqComponent.field.type.test.score') on $testCluSet.getCluSetAsLongName()", "", "");
        this.loadNaturalLanguageTemplate("10131", "en", "KS-KRMS-NL-USAGE-1000", "10037", "Must have achieved a score no higher than $fields.get('kuali.reqComponent.field.type.test.score') on $testCluSet.getCluSetAsLongName()", "", "");
        this.loadNaturalLanguageTemplate("10132", "en", "KS-KRMS-NL-USAGE-1000", "10028", "Must successfully complete a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") with a minimum grade of #if($gradeType.getId().equals(\"kuali.result.scale.grade.letter\") || $gradeType.getId().equals(\"kuali.result.scale.grade.percentage\"))$gradeType.getName().toLowerCase() #{end}$grade from $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10133", "en", "KS-KRMS-NL-USAGE-1000", "10018", "#if($courseCluSet.getCluList().size() == 1)Must have successfully completed $courseCluSet.getCluSetAsCode()#{else}Must have successfully completed all courses from $courseCluSet.getCluSetAsCode()#end", "", "");
        this.loadNaturalLanguageTemplate("10169", "en", "KS-KRMS-NL-USAGE-1000", "10033", "Must be admitted to any program offered at the course campus location", "", "");
        this.loadNaturalLanguageTemplate("10180", "en", "KS-KRMS-NL-USAGE-1000", "10036", "Must not have been admitted to the $NLHelper.getCluOrCluSetAsLongNames($programClu,$programCluSet) program", "", "");
        this.loadNaturalLanguageTemplate("10181", "en", "KS-KRMS-NL-USAGE-1000", "10029", "May be repeated for a maximum of $intValue credits", "", "");
        this.loadNaturalLanguageTemplate("10182", "en", "KS-KRMS-NL-USAGE-1000", "10055", "Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"credit\") from courses in the $org.getLongName()", "", "");
        this.loadNaturalLanguageTemplate("10183", "en", "KS-KRMS-NL-USAGE-1000", "10052", "Must have been admitted to the $NLHelper.getCluOrCluSetAsLongNames($programClu,$programCluSet) program", "", "");
        this.loadNaturalLanguageTemplate("10184", "en", "KS-KRMS-NL-USAGE-1000", "10017", "Must have successfully completed $courseClu.getOfficialIdentifier().getCode()", "", "");
        this.loadNaturalLanguageTemplate("10185", "en", "KS-KRMS-NL-USAGE-1000", "10030", "Must be concurrently enrolled in $courseClu.getOfficialIdentifier().getCode()", "", "");
        this.loadNaturalLanguageTemplate("10186", "en", "KS-KRMS-NL-USAGE-1000", "10032", "Must not have successfully completed $courseClu.getOfficialIdentifier().getCode()", "", "");
        this.loadNaturalLanguageTemplate("10187", "en", "KS-KRMS-NL-USAGE-1000", "10053", "#if($intValue == 1 && $courseCluSet.getCluList().size() == 1)Must have successfully completed $courseCluSet.getCluSetAsCode()#{else}Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") from $courseCluSet.getCluSetAsCode()#end", "", "");
        this.loadNaturalLanguageTemplate("10193", "en", "KS-KRMS-NL-USAGE-1001", "10039", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Minimum Number of Credits>", "", "");
        this.loadNaturalLanguageTemplate("10194", "en", "KS-KRMS-NL-USAGE-1001", "10047", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Maximum Number of Credits>", "", "");
        this.loadNaturalLanguageTemplate("10197", "en", "KS-KRMS-NL-USAGE-1001", "10020", "<reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10203", "en", "KS-KRMS-NL-USAGE-1001", "10053", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Number of Courses> from <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10204", "en", "KS-KRMS-NL-USAGE-1001", "10040", "<reqCompFieldType=kuali.reqComponent.field.type.gpa;reqCompFieldLabel=GPA>", "", "");
        this.loadNaturalLanguageTemplate("10205", "en", "KS-KRMS-NL-USAGE-1001", "10041", "<reqCompFieldType=kuali.reqComponent.field.type.durationType.id;reqCompFieldLabel=Duration Type> <reqCompFieldType=kuali.reqComponent.field.type.gpa;reqCompFieldLabel=GPA>", "", "");
        this.loadNaturalLanguageTemplate("10206", "en", "KS-KRMS-NL-USAGE-1001", "10018", "<reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10208", "en", "KS-KRMS-NL-USAGE-1001", "10024", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Number of Courses> from <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10209", "en", "KS-KRMS-NL-USAGE-1001", "10021", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Credits> from <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10210", "en", "KS-KRMS-NL-USAGE-1001", "10022", "<reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10212", "en", "KS-KRMS-NL-USAGE-1001", "10025", "<reqCompFieldType=kuali.reqComponent.field.type.gpa;reqCompFieldLabel=GPA> from <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10213", "en", "KS-KRMS-NL-USAGE-1001", "10023", "<reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10214", "en", "KS-KRMS-NL-USAGE-1001", "10027", "<reqCompFieldType=kuali.reqComponent.field.type.gradeType.id;reqCompFieldLabel=Grade Type> of <reqCompFieldType=kuali.reqComponent.field.type.grade.id;reqCompFieldLabel=Grade> in <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10215", "en", "KS-KRMS-NL-USAGE-1001", "10026", "<reqCompFieldType=kuali.reqComponent.field.type.gradeType.id;reqCompFieldLabel=Grade Type> of <reqCompFieldType=kuali.reqComponent.field.type.grade.id;reqCompFieldLabel=Grade> in <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses>", "", "");
        this.loadNaturalLanguageTemplate("10216", "en", "KS-KRMS-NL-USAGE-1001", "10035", "<reqCompFieldType=kuali.reqComponent.field.type.org.id;reqCompFieldLabel=Organization>", "", "");
        this.loadNaturalLanguageTemplate("10217", "en", "KS-KRMS-NL-USAGE-1001", "10034", "<reqCompFieldType=kuali.reqComponent.field.type.person.id;reqCompFieldLabel=Instructor>", "", "");
        this.loadNaturalLanguageTemplate("10218", "en", "KS-KRMS-NL-USAGE-1001", "10038", "<reqCompFieldType=kuali.reqComponent.field.type.test.score;reqCompFieldLabel=Test Score> from <reqCompFieldType=kuali.reqComponent.field.type.test.cluSet.id;reqCompFieldLabel=Tests>", "", "");
        this.loadNaturalLanguageTemplate("10219", "en", "KS-KRMS-NL-USAGE-1001", "10037", "<reqCompFieldType=kuali.reqComponent.field.type.test.score;reqCompFieldLabel=Test Score> from <reqCompFieldType=kuali.reqComponent.field.type.test.cluSet.id;reqCompFieldLabel=Tests>", "", "");
        this.loadNaturalLanguageTemplate("10220", "en", "KS-KRMS-NL-USAGE-1001", "10028", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Number of Courses> from <reqCompFieldType=kuali.reqComponent.field.type.course.cluSet.id;reqCompFieldLabel=Courses> with <reqCompFieldType=kuali.reqComponent.field.type.gradeType.id;reqCompFieldLabel=Grade Type> of <reqCompFieldType=kuali.reqComponent.field.type.grade.id;reqCompFieldLabel=Grade>", "", "");
        this.loadNaturalLanguageTemplate("10224", "en", "KS-KRMS-NL-USAGE-1001", "10036", "<reqCompFieldType=kuali.reqComponent.field.type.program.cluSet.id;reqCompFieldLabel=Program(s)>", "", "");
        this.loadNaturalLanguageTemplate("10225", "en", "KS-KRMS-NL-USAGE-1001", "10029", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Credits>", "", "");
        this.loadNaturalLanguageTemplate("10226", "en", "KS-KRMS-NL-USAGE-1001", "10055", "<reqCompFieldType=kuali.reqComponent.field.type.value.positive.integer;reqCompFieldLabel=Credits> from courses in <reqCompFieldType=kuali.reqComponent.field.type.org.id;reqCompFieldLabel=Department>", "", "");
        this.loadNaturalLanguageTemplate("10227", "en", "KS-KRMS-NL-USAGE-1001", "10052", "<reqCompFieldType=kuali.reqComponent.field.type.program.cluSet.id;reqCompFieldLabel=Program(s)>", "", "");
        this.loadNaturalLanguageTemplate("10228", "en", "KS-KRMS-NL-USAGE-1001", "10017", "<reqCompFieldType=kuali.reqComponent.field.type.course.clu.id;reqCompFieldLabel=Course>", "", "");
        this.loadNaturalLanguageTemplate("10229", "en", "KS-KRMS-NL-USAGE-1000", "10020", "#if($courseCluSet.getCluList().size() == 1)Must not have successfully completed $courseCluSet.getCluSetAsCode()#{else}Must not have successfully completed any courses from $courseCluSet.getCluSetAsCode()#end", "", "");
        this.loadNaturalLanguageTemplate("10235", "en", "KS-KRMS-NL-USAGE-1000", "10039", "Must have earned a minimum of $intValue total $NLHelper.getProperGrammar($intValue, \"credit\")", "", "");
        this.loadNaturalLanguageTemplate("10236", "en", "KS-KRMS-NL-USAGE-1000", "10047", "Must not have earned more than $intValue $NLHelper.getProperGrammar($intValue, \"credit\")", "", "");
        this.loadNaturalLanguageTemplate("10239", "en", "KS-KRMS-NL-USAGE-1003", "10020", "#if($courseCluSet.getCluList().size() == 1)Must not have successfully completed#{else}Must not have successfully completed any courses from#end", "", "");
        this.loadNaturalLanguageTemplate("10246", "en", "KS-KRMS-NL-USAGE-1000", "10040", "Must have earned a minimum cumulative GPA of $gpa", "", "");
        this.loadNaturalLanguageTemplate("10247", "en", "KS-KRMS-NL-USAGE-1000", "10041", "Must have earned a minimum $durationType.getName().toLowerCase() GPA of $gpa", "", "");
        this.loadNaturalLanguageTemplate("10248", "en", "KS-KRMS-NL-USAGE-1003", "10018", "#if($courseCluSet.getCluList().size() == 1)Must have successfully completed#{else}Must have successfully completed all courses from#end", "", "");
        this.loadNaturalLanguageTemplate("10249", "en", "KS-KRMS-NL-USAGE-1003", "10053", "#if($intValue == 1 && $courseCluSet.getCluList().size() == 1)Must have successfully completed#{else}Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") from#end", "", "");
        this.loadNaturalLanguageTemplate("10250", "en", "KS-KRMS-NL-USAGE-1003", "10024", "Must be concurrently enrolled in a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") from", "", "");
        this.loadNaturalLanguageTemplate("10251", "en", "KS-KRMS-NL-USAGE-1003", "10021", "Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"credit\") from", "", "");
        this.loadNaturalLanguageTemplate("10252", "en", "KS-KRMS-NL-USAGE-1003", "10022", "Must not have successfully completed any credits from", "", "");
        this.loadNaturalLanguageTemplate("10254", "en", "KS-KRMS-NL-USAGE-1003", "10025", "Must have earned a minimum GPA of $gpa in", "", "");
        this.loadNaturalLanguageTemplate("10255", "en", "KS-KRMS-NL-USAGE-1003", "10023", "#if($courseCluSet.getCluList().size() == 1)Must be concurrently enrolled in#{else}Must be concurrently enrolled in all courses from#end", "", "");
        this.loadNaturalLanguageTemplate("10261", "en", "KS-KRMS-NL-USAGE-1003", "10039", "Must have earned a minimum of $intValue total $NLHelper.getProperGrammar($intValue, \"credit\")", "", "");
        this.loadNaturalLanguageTemplate("10262", "en", "KS-KRMS-NL-USAGE-1003", "10047", "Must not have earned more than $intValue $NLHelper.getProperGrammar($intValue, \"credit\")", "", "");
        this.loadNaturalLanguageTemplate("10271", "en", "KS-KRMS-NL-USAGE-1003", "10040", "Must have earned a minimum cumulative GPA of $gpa", "", "");
        this.loadNaturalLanguageTemplate("10272", "en", "KS-KRMS-NL-USAGE-1003", "10041", "Must have earned a minimum $durationType.getName().toLowerCase() GPA of $gpa", "", "");
        this.loadNaturalLanguageTemplate("10273", "en", "KS-KRMS-NL-USAGE-1003", "10027", "Must have earned a minimum grade of #if($gradeType.getId().equals(\"kuali.result.scale.grade.letter\") || $gradeType.getId().equals(\"kuali.result.scale.grade.percentage\"))$gradeType.getName().toLowerCase() #{end}$grade in", "", "");
        this.loadNaturalLanguageTemplate("10274", "en", "KS-KRMS-NL-USAGE-1003", "10026", "Must not have earned a maximum grade of #if($gradeType.getId().equals(\"kuali.result.scale.grade.letter\") || $gradeType.getId().equals(\"kuali.result.scale.grade.percentage\"))$gradeType.getName().toLowerCase() #{end}$grade or higher in", "", "");
        this.loadNaturalLanguageTemplate("10275", "en", "KS-KRMS-NL-USAGE-1003", "10035", "Permission of $org.getLongName() required", "", "");
        this.loadNaturalLanguageTemplate("10276", "en", "KS-KRMS-NL-USAGE-1003", "10034", "Permission of instructor required", "", "");
        this.loadNaturalLanguageTemplate("10277", "en", "KS-KRMS-NL-USAGE-1003", "10038", "Must have achieved a minimum score of $fields.get('kuali.reqComponent.field.type.test.score') on $testCluSet.getCluSetAsLongName()", "", "");
        this.loadNaturalLanguageTemplate("10278", "en", "KS-KRMS-NL-USAGE-1003", "10037", "Must have achieved a score no higher than $fields.get('kuali.reqComponent.field.type.test.score') on $testCluSet.getCluSetAsLongName()", "", "");
        this.loadNaturalLanguageTemplate("10279", "en", "KS-KRMS-NL-USAGE-1003", "10028", "Must successfully complete a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") with a minimum grade of #if($gradeType.getId().equals(\"kuali.result.scale.grade.letter\") || $gradeType.getId().equals(\"kuali.result.scale.grade.percentage\"))$gradeType.getName().toLowerCase() #{end}$grade from", "", "");
        this.loadNaturalLanguageTemplate("10282", "en", "KS-KRMS-NL-USAGE-1003", "10033", "Must be admitted to any program offered at the course campus location", "", "");
        this.loadNaturalLanguageTemplate("10283", "en", "KS-KRMS-NL-USAGE-1003", "10036", "Must not have been admitted to the $NLHelper.getCluOrCluSetAsLongNames($programClu,$programCluSet) program", "", "");
        this.loadNaturalLanguageTemplate("10284", "en", "KS-KRMS-NL-USAGE-1003", "10029", "May be repeated for a maximum of $intValue credits", "", "");
        this.loadNaturalLanguageTemplate("10285", "en", "KS-KRMS-NL-USAGE-1003", "10055", "Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"credit\") from courses in the $org.getLongName()", "", "");
        this.loadNaturalLanguageTemplate("10286", "en", "KS-KRMS-NL-USAGE-1003", "10052", "Must have been admitted to the $NLHelper.getCluOrCluSetAsLongNames($programClu,$programCluSet) program", "", "");
        this.loadNaturalLanguageTemplate("10287", "en", "KS-KRMS-NL-USAGE-1003", "10017", "Must have successfully completed $courseClu.getOfficialIdentifier().getCode()", "", "");
        this.loadNaturalLanguageTemplate("10288", "en", "KS-KRMS-NL-USAGE-1003", "10030", "Must be concurrently enrolled in $courseClu.getOfficialIdentifier().getCode()", "", "");
        this.loadNaturalLanguageTemplate("10289", "en", "KS-KRMS-NL-USAGE-1003", "10032", "Must not have successfully completed $courseClu.getOfficialIdentifier().getCode()", "", "");
        this.loadNaturalLanguageTemplate("10290", "en", "KS-KRMS-NL-USAGE-1000", "10027", "Must have earned a minimum grade of #if($gradeType.getId().equals(\"kuali.result.scale.grade.letter\") || $gradeType.getId().equals(\"kuali.result.scale.grade.percentage\"))$gradeType.getName().toLowerCase() #{end}$grade in $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10291", "en", "KS-KRMS-NL-USAGE-1000", "10026", "Must not have earned a maximum grade of #if($gradeType.getId().equals(\"kuali.result.scale.grade.letter\") || $gradeType.getId().equals(\"kuali.result.scale.grade.percentage\"))$gradeType.getName().toLowerCase() #{end}$grade or higher in $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10292", "en", "KS-KRMS-NL-USAGE-1001", "10030", "<reqCompFieldType=kuali.reqComponent.field.type.course.clu.id;reqCompFieldLabel=Course>", "", "");
        this.loadNaturalLanguageTemplate("10293", "en", "KS-KRMS-NL-USAGE-1001", "10032", "<reqCompFieldType=kuali.reqComponent.field.type.course.clu.id;reqCompFieldLabel=Course>", "", "");
        this.loadNaturalLanguageTemplate("10294", "en", "KS-KRMS-NL-USAGE-1000", "10024", "Must be concurrently enrolled in a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"course\") from $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10304", "en", "KS-KRMS-NL-USAGE-1001", "10031", "<reqCompFieldType=kuali.reqComponent.field.type.value.freeform.text;reqCompFieldLabel=Text>", "", "");
        this.loadNaturalLanguageTemplate("10318", "en", "KS-KRMS-NL-USAGE-1003", "10031", "$freeText", "", "");
        this.loadNaturalLanguageTemplate("10325", "en", "KS-KRMS-NL-USAGE-1000", "10031", "$freeText", "", "");
        this.loadNaturalLanguageTemplate("10330", "en", "KS-KRMS-NL-USAGE-1000", "10021", "Must have successfully completed a minimum of $intValue $NLHelper.getProperGrammar($intValue, \"credit\") from $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10331", "en", "KS-KRMS-NL-USAGE-1000", "10022", "Must not have successfully completed any credits from $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10333", "en", "KS-KRMS-NL-USAGE-1000", "10025", "Must have earned a minimum GPA of $gpa in $courseCluSet.getCluSetAsCode()", "", "");
        this.loadNaturalLanguageTemplate("10334", "en", "KS-KRMS-NL-USAGE-1000", "10023", "#if($courseCluSet.getCluList().size() == 1)Must be concurrently enrolled in $courseCluSet.getCluSetAsCode()#{else}Must be concurrently enrolled in all courses from $courseCluSet.getCluSetAsCode()#end", "", "");
        this.loadNaturalLanguageTemplate("10335", "en", "KS-KRMS-NL-USAGE-1003", "10065", "Must have been admitted to a Program offered by <Org>", "", "");
        this.loadNaturalLanguageTemplate("10337", "en", "KS-KRMS-NL-USAGE-1003", "10074", "Must have achieved a score between <score> and <score> on <test>", "", "");
        this.loadNaturalLanguageTemplate("10338", "en", "KS-KRMS-NL-USAGE-1003", "10064", "Must not have been admitted to the <Program> Program with a class standing of <Class Standing>", "", "");
        this.loadNaturalLanguageTemplate("10339", "en", "KS-KRMS-NL-USAGE-1003", "10057", "May not repeat <course> if repeated <n> times ", "", "");
        this.loadNaturalLanguageTemplate("10340", "en", "KS-KRMS-NL-USAGE-1003", "10075", "Must have achieved a score between <score> and <score> on <test> ", "", "");
        this.loadNaturalLanguageTemplate("10341", "en", "KS-KRMS-NL-USAGE-1003", "10067", "Student must be in a class standing of <class standing> or greater ", "", "");
        this.loadNaturalLanguageTemplate("10342", "en", "KS-KRMS-NL-USAGE-1003", "10046", "Student in <Program> can enrol in a maximum of <n> courses for the term", "", "");
        this.loadNaturalLanguageTemplate("10343", "en", "KS-KRMS-NL-USAGE-1003", "10062", "Must have successfully completed <course> between <term1> and <term2>", "", "");
        this.loadNaturalLanguageTemplate("10344", "en", "KS-KRMS-NL-USAGE-1003", "10056", "Student cannot add Activity Offering with <Activity Offering State>  of <state> ", "", "");
        this.loadNaturalLanguageTemplate("10345", "en", "KS-KRMS-NL-USAGE-1003", "10069", "Must not be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10347", "en", "KS-KRMS-NL-USAGE-1003", "10058", "May not repeat any of  <courses>", "", "");
        this.loadNaturalLanguageTemplate("10348", "en", "KS-KRMS-NL-USAGE-1003", "10044", "Course has more than <n> minutes overlap with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10349", "en", "KS-KRMS-NL-USAGE-1003", "10060", "Must have successfully completed <course> as of <term>", "", "");
        this.loadNaturalLanguageTemplate("10350", "en", "KS-KRMS-NL-USAGE-1003", "10054", "Must have successfully completed a minimum of <n> credits from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10351", "en", "KS-KRMS-NL-USAGE-1003", "10071", "Must be concurrently enrolled in all courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10352", "en", "KS-KRMS-NL-USAGE-1003", "10051", "Students admitted to <campus> may take no more than <n  credits> at <campus> in <duration> <durationType>", "", "");
        this.loadNaturalLanguageTemplate("10353", "en", "KS-KRMS-NL-USAGE-1003", "10050", "Students admitted to <campus> may take no more than <n> courses at <campus> in <duration> <durationType>", "", "");
        this.loadNaturalLanguageTemplate("10354", "en", "KS-KRMS-NL-USAGE-1003", "10043", "If student is <attribute> AND upon drop total credit hours would be less than <min credit hours>, prevent drop ", "", "");
        this.loadNaturalLanguageTemplate("10356", "en", "KS-KRMS-NL-USAGE-1003", "10072", "May not repeat <course> if repeated <n> times ", "", "");
        this.loadNaturalLanguageTemplate("10357", "en", "KS-KRMS-NL-USAGE-1003", "10061", "Must have successfully completed <course> prior to <term>", "", "");
        this.loadNaturalLanguageTemplate("10358", "en", "KS-KRMS-NL-USAGE-1003", "10068", "Student must be in a class standing of <class standing> or less ", "", "");
        this.loadNaturalLanguageTemplate("10359", "en", "KS-KRMS-NL-USAGE-1003", "10045", "Course has less than <n> minutes between start time or end time with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10360", "en", "KS-KRMS-NL-USAGE-1003", "10066", "Student must be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10362", "en", "KS-KRMS-NL-USAGE-1003", "10059", "Student is in an existing seat pool for the course with an available seat", "", "");
        this.loadNaturalLanguageTemplate("10363", "en", "KS-KRMS-NL-USAGE-1003", "10042", "If student is <attribute> AND upon drop total credit hours would be less than <min credit hours>, prevent drop ", "", "");
        this.loadNaturalLanguageTemplate("10364", "en", "KS-KRMS-NL-USAGE-1000", "10077", "Must meet 1 of the following", "", "");
        this.loadNaturalLanguageTemplate("10365", "en", "KS-KRMS-NL-USAGE-1001", "10077", "Must meet 1 of the following", "", "");
        this.loadNaturalLanguageTemplate("10366", "en", "KS-KRMS-NL-USAGE-1002", "10077", "Must meet 1 of the following", "", "");
        this.loadNaturalLanguageTemplate("10367", "en", "KS-KRMS-NL-USAGE-1003", "10077", "Must meet 1 of the following", "", "");
        this.loadNaturalLanguageTemplate("10368", "en", "KS-KRMS-NL-USAGE-1005", "10077", "Must meet 1 of the following", "", "");
        this.loadNaturalLanguageTemplate("10369", "en", "KS-KRMS-NL-USAGE-1000", "10076", "Must meet all of the following", "", "");
        this.loadNaturalLanguageTemplate("10370", "en", "KS-KRMS-NL-USAGE-1001", "10076", "Must meet all of the following", "", "");
        this.loadNaturalLanguageTemplate("10371", "en", "KS-KRMS-NL-USAGE-1002", "10076", "Must meet all of the following", "", "");
        this.loadNaturalLanguageTemplate("10372", "en", "KS-KRMS-NL-USAGE-1003", "10076", "Must meet all of the following", "", "");
        this.loadNaturalLanguageTemplate("10373", "en", "KS-KRMS-NL-USAGE-1005", "10076", "Must meet all of the following", "", "");
        this.loadNaturalLanguageTemplate("10374", "en", "KS-KRMS-NL-USAGE-1000", "10065", "Must have been admitted to a Program offered by <Org>", "", "");
        this.loadNaturalLanguageTemplate("10376", "en", "KS-KRMS-NL-USAGE-1000", "10074", "Must have achieved a score between <score> and <score> on <test>", "", "");
        this.loadNaturalLanguageTemplate("10377", "en", "KS-KRMS-NL-USAGE-1000", "10064", "Must not have been admitted to the <Program> Program with a class standing of <Class Standing>", "", "");
        this.loadNaturalLanguageTemplate("10378", "en", "KS-KRMS-NL-USAGE-1000", "10057", "May not repeat <course> if repeated <n> times ", "", "");
        this.loadNaturalLanguageTemplate("10379", "en", "KS-KRMS-NL-USAGE-1000", "10075", "Must have achieved a score between <score> and <score> on <test> ", "", "");
        this.loadNaturalLanguageTemplate("10380", "en", "KS-KRMS-NL-USAGE-1000", "10067", "Student must be in a class standing of <class standing> or greater ", "", "");
        this.loadNaturalLanguageTemplate("10381", "en", "KS-KRMS-NL-USAGE-1000", "10046", "Student in <Program> can enrol in a maximum of <n> courses for the term", "", "");
        this.loadNaturalLanguageTemplate("10382", "en", "KS-KRMS-NL-USAGE-1000", "10062", "Must have successfully completed <course> between <term1> and <term2>", "", "");
        this.loadNaturalLanguageTemplate("10383", "en", "KS-KRMS-NL-USAGE-1000", "10056", "Student cannot add Activity Offering with <Activity Offering State>  of <state> ", "", "");
        this.loadNaturalLanguageTemplate("10384", "en", "KS-KRMS-NL-USAGE-1000", "10069", "Must not be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10386", "en", "KS-KRMS-NL-USAGE-1000", "10058", "May not repeat any of  <courses>", "", "");
        this.loadNaturalLanguageTemplate("10387", "en", "KS-KRMS-NL-USAGE-1000", "10044", "Course has more than <n> minutes overlap with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10388", "en", "KS-KRMS-NL-USAGE-1000", "10060", "Must have successfully completed <course> as of <term>", "", "");
        this.loadNaturalLanguageTemplate("10389", "en", "KS-KRMS-NL-USAGE-1000", "10054", "Must have successfully completed a minimum of <n> credits from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10390", "en", "KS-KRMS-NL-USAGE-1000", "10071", "Must be concurrently enrolled in all courses from <courses>", "", "");
        this.loadNaturalLanguageTemplate("10391", "en", "KS-KRMS-NL-USAGE-1000", "10051", "Students admitted to <campus> may take no more than <n  credits> at <campus> in <duration> <durationType>", "", "");
        this.loadNaturalLanguageTemplate("10392", "en", "KS-KRMS-NL-USAGE-1000", "10050", "Students admitted to <campus> may take no more than <n> courses at <campus> in <duration> <durationType>", "", "");
        this.loadNaturalLanguageTemplate("10393", "en", "KS-KRMS-NL-USAGE-1000", "10043", "If student is <attribute> AND upon drop total credit hours would be less than <min credit hours>, prevent drop ", "", "");
        this.loadNaturalLanguageTemplate("10395", "en", "KS-KRMS-NL-USAGE-1000", "10072", "May not repeat <course> if repeated <n> times ", "", "");
        this.loadNaturalLanguageTemplate("10396", "en", "KS-KRMS-NL-USAGE-1000", "10061", "Must have successfully completed <course> prior to <term>", "", "");
        this.loadNaturalLanguageTemplate("10397", "en", "KS-KRMS-NL-USAGE-1000", "10068", "Student must be in a class standing of <class standing> or less ", "", "");
        this.loadNaturalLanguageTemplate("10398", "en", "KS-KRMS-NL-USAGE-1000", "10045", "Course has less than <n> minutes between start time or end time with already enrolled course", "", "");
        this.loadNaturalLanguageTemplate("10399", "en", "KS-KRMS-NL-USAGE-1000", "10066", "Student must be in a class standing of <class standing>", "", "");
        this.loadNaturalLanguageTemplate("10401", "en", "KS-KRMS-NL-USAGE-1000", "10059", "Student is in an existing seat pool for the course with an available seat", "", "");
        this.loadNaturalLanguageTemplate("10402", "en", "KS-KRMS-NL-USAGE-1000", "10042", "If student is <attribute> AND upon drop total credit hours would be less than <min credit hours>, prevent drop ", "", "");
        this.loadNaturalLanguageTemplate("10403", "en", "KS-KRMS-NL-USAGE-1006", "10010", "Add conditions that will restrict student enrollment, addressing restrictions to majors, locations, credit level requirements, etc. or Add courses, with or without grade requirements, which a student must have completed in order to enroll.", "", "");
        this.loadNaturalLanguageTemplate("10404", "en", "KS-KRMS-NL-USAGE-1006", "10006", "Add conditions that will restrict student enrollment, addressing restrictions to majors, locations, credit level requirements, etc. or Add courses, with or without grade requirements, which a student must have completed in order to enroll. (TL: Why is this the same definition as above? It should at least specify that the restriction is based on concurrent enrolment, not completion.)", "", "");
        this.loadNaturalLanguageTemplate("10405", "en", "KS-KRMS-NL-USAGE-1006", "10008", "The courses and/or preparation added here will not prevent students from registering, but will be printed in the catalog.", "", "");
        this.loadNaturalLanguageTemplate("10406", "en", "KS-KRMS-NL-USAGE-1006", "10005", "Add courses that, if completed, would prevent a student from enrolling in this course.", "", "");
        this.loadNaturalLanguageTemplate("10407", "en", "KS-KRMS-NL-USAGE-1006", "10012", "Enrollment in or completion of another course that will restrict the credits to be awarded.", "", "");
        this.loadNaturalLanguageTemplate("10408", "en", "KS-KRMS-NL-USAGE-1006", "10011", "Course repeatable for credit.", "", "");
    }
}

