/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.cache;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.kuali.rice.core.api.cache.CacheManagerRegistry;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.core.api.util.tree.Tree;
import org.kuali.rice.core.impl.services.CoreImplServiceLocator;
import org.kuali.rice.core.web.cache.CacheAdminForm;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/core/admin/cache"})
public class CacheAdminController
extends UifControllerBase {
    private CacheManagerRegistry registry;

    public synchronized CacheManagerRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = CoreImplServiceLocator.getCacheManagerRegistry();
        }
        return this.registry;
    }

    protected CacheAdminForm createInitialForm() {
        return new CacheAdminForm();
    }

    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(UifFormBase form) {
        Tree cacheTree = new Tree();
        Node root = new Node((Object)"Root", (Object)"Root");
        ArrayList cms = new ArrayList(this.getRegistry().getCacheManagers());
        Collections.sort(cms, new ByName());
        for (CacheManager cm : cms) {
            String name = this.getRegistry().getCacheManagerName(cm);
            Node cmNode = new Node((Object)name, (Object)name);
            ArrayList names = new ArrayList(cm.getCacheNames());
            Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String cn;
                String cacheSize = this.getCacheSize(name, cn = (String)iterator.next());
                Node cNode = new Node((Object)cn, (Object)(cn + (String)(cacheSize != null ? " - " + cacheSize : "")));
                cmNode.addChild(cNode);
            }
            root.addChild(cmNode);
        }
        cacheTree.setRootElement(root);
        ((CacheAdminForm)form).setCacheTree((Tree<String, String>)cacheTree);
        return super.start(form);
    }

    @RequestMapping(params={"methodToCall=flush"}, method={RequestMethod.POST})
    public ModelAndView flush(UifFormBase form) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean isAuthorized = KimApiServiceLocator.getPermissionService().isAuthorized(user.getPrincipalId(), "KR-SYS", "Use Cache Adminstration Screen", Collections.singletonMap("principalId", user.getPrincipalId()));
        if (isAuthorized) {
            for (String name : ((CacheAdminForm)form).getFlush()) {
                List<Integer> path = CacheAdminController.path(CacheAdminController.removePrefix(name));
                Tree<String, String> tree = ((CacheAdminForm)form).getCacheTree();
                Integer cmIdx = path.get(0);
                Node cmNode = (Node)tree.getRootElement().getChildren().get(cmIdx);
                String cmName = (String)cmNode.getData();
                CacheManager cm = this.getRegistry().getCacheManager(cmName);
                if (path.size() == 1) {
                    CacheAdminController.flushAllCaches(cm);
                    GlobalVariables.getMessageMap().putInfoForSectionId("mainGroup_div", "flush.all.cachemanager", new String[]{cmName});
                    continue;
                }
                Integer cIdx = path.get(1);
                Node cNode = (Node)cmNode.getChildren().get(cIdx);
                String cName = (String)cNode.getData();
                CacheAdminController.flushSpecificCache(cm, cName);
                GlobalVariables.getMessageMap().putInfoForSectionId("mainGroup_div", "flush.single.cachemanager", new String[]{cName, cmName});
            }
        } else {
            GlobalVariables.getMessageMap().putError("flush", "error.authorization.general", new String[]{user.getPrincipalName(), "flush", "cachemanager"});
        }
        return super.start(form);
    }

    private static void flushSpecificCache(CacheManager cm, String cache) {
        for (String s : cm.getCacheNames()) {
            if (!cache.equals(s)) continue;
            cm.getCache(s).clear();
            return;
        }
    }

    private static void flushAllCaches(CacheManager cm) {
        for (String s : cm.getCacheNames()) {
            cm.getCache(s).clear();
        }
    }

    private static String removePrefix(String s) {
        StringBuilder sbn = new StringBuilder(s);
        sbn.delete(0, sbn.indexOf("_") + 1);
        return sbn.toString();
    }

    private static List<Integer> path(String s) {
        String[] path = s.split("_parent_");
        ArrayList<Integer> pathIdx = new ArrayList<Integer>();
        for (int i = path.length - 2; i >= 0; --i) {
            pathIdx.add(Integer.valueOf(path[i].substring(5)));
        }
        return Collections.unmodifiableList(pathIdx);
    }

    private String getCacheSize(String cacheManagerName, String cacheName) {
        Object nativeCache = this.getRegistry().getCacheManager(cacheManagerName).getCache(cacheName).getNativeCache();
        try {
            Object intSize;
            Class<?> ehcache = Class.forName("net.sf.ehcache.Cache");
            if (ehcache.isInstance(nativeCache) && (intSize = ehcache.getDeclaredMethod("getSize", new Class[0]).invoke(nativeCache, new Object[0])) != null) {
                return intSize.toString();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private final class ByName
    implements Comparator<CacheManager> {
        private ByName() {
        }

        @Override
        public int compare(CacheManager o1, CacheManager o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(CacheAdminController.this.getRegistry().getCacheManagerName(o1), CacheAdminController.this.getRegistry().getCacheManagerName(o2));
        }
    }
}

