/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.jsptag;

import java.io.IOException;
import java.util.Vector;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.joda.time.contrib.jsptag.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JodaTagLibraryValidator
extends TagLibraryValidator {
    private static final String SET_DATETIMEZONE = "setDateTimeZone";
    private static final String PARSE_DATETIME = "parseDateTime";
    private static final String JSP_TEXT = "jsp:text";
    private static final String VALUE = "value";
    private static final String VAR = "var";
    private static final String SCOPE = "scope";
    private static final String PAGE_SCOPE = "page";
    private static final String REQUEST_SCOPE = "request";
    private static final String SESSION_SCOPE = "session";
    private static final String APPLICATION_SCOPE = "application";
    private final String JSP = "http://java.sun.com/JSP/Page";
    private String uri;
    private String prefix;
    private Vector messageVector;
    private String lastElementId;

    public JodaTagLibraryValidator() {
        this.init();
    }

    private void init() {
        this.messageVector = null;
        this.prefix = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    public synchronized ValidationMessage[] validate(String string, String string2, PageData pageData) {
        try {
            this.uri = string2;
            this.messageVector = new Vector();
            this.prefix = string;
            Handler handler = new Handler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(pageData.getInputStream(), (DefaultHandler)handler);
            if (this.messageVector.size() == 0) {
                return null;
            }
            return JodaTagLibraryValidator.vmFromVector(this.messageVector);
        }
        catch (SAXException sAXException) {
            return JodaTagLibraryValidator.vmFromString(sAXException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return JodaTagLibraryValidator.vmFromString(parserConfigurationException.toString());
        }
        catch (IOException iOException) {
            return JodaTagLibraryValidator.vmFromString(iOException.toString());
        }
    }

    private boolean isTag(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return false;
        }
        if (string.length() > string3.length()) {
            return string.startsWith(string3) && string2.equals(string4);
        }
        return string3.startsWith(string) && string2.equals(string4);
    }

    private boolean isJodaTag(String string, String string2, String string3) {
        return this.isTag(string, string2, this.uri, string3);
    }

    private boolean hasAttribute(Attributes attributes, String string) {
        return attributes.getValue(string) != null;
    }

    private void fail(String string) {
        this.messageVector.add(new ValidationMessage(this.lastElementId, string));
    }

    protected boolean hasNoInvalidScope(Attributes attributes) {
        String string = attributes.getValue(SCOPE);
        return string == null || string.equals(PAGE_SCOPE) || string.equals(REQUEST_SCOPE) || string.equals(SESSION_SCOPE) || string.equals(APPLICATION_SCOPE);
    }

    protected boolean hasEmptyVar(Attributes attributes) {
        return "".equals(attributes.getValue(VAR));
    }

    protected boolean hasDanglingScope(Attributes attributes) {
        return attributes.getValue(SCOPE) != null && attributes.getValue(VAR) == null;
    }

    protected String getLocalPart(String string) {
        int n = string.indexOf(":");
        return n == -1 ? string : string.substring(n + 1);
    }

    private static ValidationMessage[] vmFromString(String string) {
        return new ValidationMessage[]{new ValidationMessage(null, string)};
    }

    private static ValidationMessage[] vmFromVector(Vector vector) {
        ValidationMessage[] validationMessageArray = new ValidationMessage[vector.size()];
        for (int i = 0; i < validationMessageArray.length; ++i) {
            validationMessageArray[i] = (ValidationMessage)vector.get(i);
        }
        return validationMessageArray;
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string2 == null) {
                string2 = JodaTagLibraryValidator.this.getLocalPart(string3);
            }
            if (string3.equals(JodaTagLibraryValidator.JSP_TEXT)) {
                return;
            }
            if (this.bodyIllegal) {
                JodaTagLibraryValidator.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (string3.startsWith(JodaTagLibraryValidator.this.prefix + ":") && !JodaTagLibraryValidator.this.hasNoInvalidScope(attributes)) {
                JodaTagLibraryValidator.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", JodaTagLibraryValidator.SCOPE, string3, attributes.getValue(JodaTagLibraryValidator.SCOPE)));
            }
            if (string3.startsWith(JodaTagLibraryValidator.this.prefix + ":") && JodaTagLibraryValidator.this.hasEmptyVar(attributes)) {
                JodaTagLibraryValidator.this.fail(Resources.getMessage("TLV_EMPTY_VAR", string3));
            }
            if (string3.startsWith(JodaTagLibraryValidator.this.prefix + ":") && !JodaTagLibraryValidator.this.isJodaTag(string, string2, JodaTagLibraryValidator.SET_DATETIMEZONE) && JodaTagLibraryValidator.this.hasDanglingScope(attributes)) {
                JodaTagLibraryValidator.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", string3));
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JodaTagLibraryValidator.this.isJodaTag(string, string2, JodaTagLibraryValidator.PARSE_DATETIME)) {
                if (JodaTagLibraryValidator.this.hasAttribute(attributes, JodaTagLibraryValidator.VALUE)) {
                    this.bodyIllegal = true;
                } else {
                    this.bodyNecessary = true;
                }
            }
            this.lastElementName = string3;
            JodaTagLibraryValidator.this.lastElementId = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        public void characters(char[] cArray, int n, int n2) {
            this.bodyNecessary = false;
            String string = new String(cArray, n, n2).trim();
            if (string.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JodaTagLibraryValidator.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals(JodaTagLibraryValidator.JSP_TEXT)) {
                return;
            }
            if (this.bodyNecessary) {
                JodaTagLibraryValidator.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            --this.depth;
        }
    }
}

