/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class AdHocAction
extends ActionTakenEvent {
    private static final String NO_ACTION_TAKEN_CODE = null;
    private String actionRequested;
    private String nodeName;
    private Integer priority;
    private String responsibilityDesc;
    private Boolean forceAction;
    private Recipient recipient;
    private String annotation;
    private String requestLabel;

    public AdHocAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super(NO_ACTION_TAKEN_CODE, routeHeader, principal);
    }

    public AdHocAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, String actionRequested, String nodeName, Integer priority, Recipient recipient, String responsibilityDesc, Boolean forceAction, String requestLabel) {
        super(NO_ACTION_TAKEN_CODE, routeHeader, principal, annotation);
        this.actionRequested = actionRequested;
        this.nodeName = nodeName;
        this.priority = priority;
        this.responsibilityDesc = responsibilityDesc;
        this.forceAction = forceAction;
        this.recipient = recipient;
        this.annotation = annotation;
        this.requestLabel = requestLabel;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        String errorMessage = this.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        List<RouteNodeInstance> targetNodes = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(this.getDocumentId());
        String error = this.adhocRouteAction(targetNodes, false);
        if (!StringUtils.isEmpty((String)error)) {
            throw new InvalidActionTakenException(error);
        }
    }

    @Override
    public String validateActionRules() {
        List<RouteNodeInstance> targetNodes = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(this.getDocumentId());
        return this.validateActionRulesInternal(targetNodes);
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    private String validateActionRulesInternal(List<RouteNodeInstance> targetNodes) {
        if (this.recipient != null) {
            if (this.recipient instanceof KimPrincipalRecipient) {
                KimPrincipalRecipient principalRecipient = (KimPrincipalRecipient)this.recipient;
                if (!KEWServiceLocator.getDocumentTypePermissionService().canReceiveAdHocRequest(principalRecipient.getPrincipalId(), this.getRouteHeader(), this.actionRequested)) {
                    return "The principal '" + principalRecipient.getPrincipal().getPrincipalName() + "' does not have permission to recieve ad hoc requests on DocumentType '" + this.getRouteHeader().getDocumentType().getName() + "'";
                }
            } else if (this.recipient instanceof KimGroupRecipient) {
                Group group = ((KimGroupRecipient)this.recipient).getGroup();
                if (!KEWServiceLocator.getDocumentTypePermissionService().canGroupReceiveAdHocRequest(group.getId(), this.getRouteHeader(), this.actionRequested)) {
                    return "The group '" + group.getName() + "' does not have permission to recieve ad hoc requests on DocumentType '" + this.getRouteHeader().getDocumentType().getName() + "'";
                }
            } else {
                return "Invalid Recipient type encountered: " + this.recipient.getClass();
            }
        }
        return this.adhocRouteAction(targetNodes, true);
    }

    private String adhocRouteAction(List<RouteNodeInstance> targetNodes, boolean forValidationOnly) {
        boolean requestCreated = false;
        for (RouteNodeInstance routeNode : targetNodes) {
            if (this.nodeName != null && !routeNode.getName().equals(this.nodeName)) continue;
            String message = this.createAdHocRequest(routeNode, forValidationOnly);
            if (StringUtils.isNotBlank((String)message)) {
                return message;
            }
            requestCreated = true;
            if (this.nodeName != null) continue;
            break;
        }
        if (!requestCreated && targetNodes.isEmpty()) {
            String message = this.createAdHocRequest(null, forValidationOnly);
            if (StringUtils.isNotBlank((String)message)) {
                return message;
            }
            requestCreated = true;
        }
        if (!requestCreated) {
            return "Didn't create request.  The node name " + this.nodeName + " given is probably invalid ";
        }
        return "";
    }

    private String createAdHocRequest(RouteNodeInstance routeNode, boolean forValidationOnly) {
        ActionRequestValue adhocRequest = new ActionRequestValue();
        if (!forValidationOnly) {
            ActionRequestFactory arFactory = new ActionRequestFactory(this.routeHeader, routeNode);
            adhocRequest = arFactory.createActionRequest(this.actionRequested, this.recipient, this.responsibilityDesc, this.forceAction, this.annotation);
            adhocRequest.setResponsibilityId("-1");
            adhocRequest.setRequestLabel(this.requestLabel);
            if (this.priority != null) {
                adhocRequest.setPriority(this.priority);
            }
        } else {
            adhocRequest.setActionRequested(this.actionRequested);
        }
        if (adhocRequest.isApproveOrCompleteRequest() && !this.routeHeader.isEnroute() && !this.routeHeader.isStateInitiated() && !this.routeHeader.isStateSaved()) {
            return "Cannot AdHoc a Complete or Approve request when document is in state '" + this.routeHeader.getDocRouteStatusLabel() + "'.";
        }
        if (!forValidationOnly) {
            if (this.routeHeader.isDisaproved() || this.routeHeader.isCanceled() || this.routeHeader.isFinal() || this.routeHeader.isProcessed()) {
                this.getActionRequestService().activateRequest(adhocRequest);
            } else {
                KEWServiceLocator.getActionRequestService().saveActionRequest(adhocRequest);
            }
        }
        return "";
    }
}

