/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.rule.attribute;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.framework.rule.attribute.WorkflowRuleAttributeFields;
import org.kuali.rice.kew.framework.rule.attribute.WorkflowRuleAttributeHandlerService;
import org.kuali.rice.kew.rule.RoleAttribute;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.WorkflowRuleSearchAttribute;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Row;

public class WorkflowRuleAttributeHandlerServiceImpl
implements WorkflowRuleAttributeHandlerService {
    private ExtensionRepositoryService extensionRepositoryService;

    public WorkflowRuleAttributeFields getRuleFields(Map<String, String> parameters, ExtensionDefinition extensionDefinition, boolean required) throws RiceIllegalArgumentException {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        WorkflowRuleAttribute attribute = this.loadAttribute(extensionDefinition);
        attribute.setRequired(required);
        List<RemotableAttributeError> errors = attribute.validateRuleData(parameters);
        List fields = FieldUtils.convertRowsToAttributeFields(attribute.getRuleRows());
        List<RuleExtensionValue> ruleExtensionValues = attribute.getRuleExtensionValues();
        HashMap<String, String> ruleExtensionValuesMap = new HashMap<String, String>();
        for (RuleExtensionValue ruleExtensionValue : ruleExtensionValues) {
            ruleExtensionValuesMap.put(ruleExtensionValue.getKey(), ruleExtensionValue.getValue());
        }
        return WorkflowRuleAttributeFields.create(errors, (List)fields, ruleExtensionValuesMap);
    }

    public WorkflowRuleAttributeFields getSearchFields(Map<String, String> parameters, ExtensionDefinition extensionDefinition, boolean required) throws RiceIllegalArgumentException {
        List<Row> searchRows;
        List<RemotableAttributeError> errors;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        WorkflowRuleAttribute attribute = this.loadAttribute(extensionDefinition);
        attribute.setRequired(required);
        if (attribute instanceof WorkflowRuleSearchAttribute) {
            errors = ((WorkflowRuleSearchAttribute)attribute).validateSearchData(parameters);
            searchRows = ((WorkflowRuleSearchAttribute)attribute).getSearchRows();
        } else {
            errors = attribute.validateRuleData(parameters);
            searchRows = attribute.getRuleRows();
        }
        List fields = FieldUtils.convertRowsToAttributeFields(searchRows);
        List<RuleExtensionValue> ruleExtensionValues = attribute.getRuleExtensionValues();
        HashMap<String, String> ruleExtensionValuesMap = new HashMap<String, String>();
        for (RuleExtensionValue ruleExtensionValue : ruleExtensionValues) {
            ruleExtensionValuesMap.put(ruleExtensionValue.getKey(), ruleExtensionValue.getValue());
        }
        return WorkflowRuleAttributeFields.create(errors, (List)fields, ruleExtensionValuesMap);
    }

    public WorkflowRuleAttributeFields getRoutingDataFields(Map<String, String> parameters, ExtensionDefinition extensionDefinition, boolean required) throws RiceIllegalArgumentException {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        WorkflowRuleAttribute attribute = this.loadAttribute(extensionDefinition);
        attribute.setRequired(required);
        List<RemotableAttributeError> allErrors = attribute.validateRoutingData(parameters);
        List<RemotableAttributeError> ruleDataErrors = attribute.validateRuleData(parameters);
        for (RemotableAttributeError error : ruleDataErrors) {
            allErrors.add(error);
        }
        List fields = FieldUtils.convertRowsToAttributeFields(attribute.getRoutingDataRows());
        List<RuleExtensionValue> ruleExtensionValues = attribute.getRuleExtensionValues();
        HashMap<String, String> ruleExtensionValuesMap = new HashMap<String, String>();
        for (RuleExtensionValue ruleExtensionValue : ruleExtensionValues) {
            ruleExtensionValuesMap.put(ruleExtensionValue.getKey(), ruleExtensionValue.getValue());
        }
        return WorkflowRuleAttributeFields.create(allErrors, (List)fields, ruleExtensionValuesMap);
    }

    public List<RoleName> getRoleNames(ExtensionDefinition extensionDefinition) {
        RoleAttribute roleAttribute;
        List<RoleName> roleNames;
        WorkflowRuleAttribute attribute = this.loadAttribute(extensionDefinition);
        if (attribute instanceof RoleAttribute && CollectionUtils.isNotEmpty(roleNames = (roleAttribute = (RoleAttribute)attribute).getRoleNames())) {
            return ModelObjectUtils.createImmutableCopy(roleNames);
        }
        return Collections.emptyList();
    }

    private WorkflowRuleAttribute loadAttribute(ExtensionDefinition extensionDefinition) {
        if (extensionDefinition == null) {
            throw new RiceIllegalArgumentException("extensionDefinition was null or blank");
        }
        Object attribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
        if (attribute == null) {
            throw new RiceIllegalArgumentException("Failed to load WorkflowRuleAttribute for: " + extensionDefinition);
        }
        if (!WorkflowRuleAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new RiceIllegalArgumentException("Failed to locate a WorkflowRuleAttribute with the given name: " + extensionDefinition.getName());
        }
        if (attribute instanceof XmlConfiguredAttribute) {
            ((XmlConfiguredAttribute)attribute).setExtensionDefinition(extensionDefinition);
        }
        return (WorkflowRuleAttribute)attribute;
    }

    protected ExtensionRepositoryService getExtensionRepositoryService() {
        return this.extensionRepositoryService;
    }

    public void setExtensionRepositoryService(ExtensionRepositoryService extensionRepositoryService) {
        this.extensionRepositoryService = extensionRepositoryService;
    }
}

