/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.schemaspy.ui.DbConfigTableModel;

public class DirectoryCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private final DbConfigTableModel model;
    private final JTextField dirField;
    private final JPanel editor;
    private File selectedDir;
    private int selectedRow;
    private int selectedColumn;

    public DirectoryCellEditor(final DbConfigTableModel dbConfigTableModel, File file) {
        this.model = dbConfigTableModel;
        this.dirField = new JTextField();
        this.dirField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                dbConfigTableModel.setValueAt(new File(DirectoryCellEditor.this.dirField.getText()), DirectoryCellEditor.this.selectedRow, DirectoryCellEditor.this.selectedColumn);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                dbConfigTableModel.setValueAt(new File(DirectoryCellEditor.this.dirField.getText()), DirectoryCellEditor.this.selectedRow, DirectoryCellEditor.this.selectedColumn);
            }
        });
        this.dirField.setBorder(null);
        final JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileSelectionMode(1);
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(12, 12));
        jButton.setMinimumSize(jButton.getPreferredSize());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFileChooser.setCurrentDirectory(new File(DirectoryCellEditor.this.dirField.getText()));
                if (jFileChooser.showOpenDialog((JButton)actionEvent.getSource()) == 0) {
                    DirectoryCellEditor.this.dirField.setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        });
        this.editor = new JPanel();
        this.editor.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.editor.add((Component)this.dirField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.editor.add((Component)jButton, gridBagConstraints);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.selectedRow = n;
        this.selectedColumn = n2;
        this.selectedDir = (File)object;
        this.dirField.setText(this.selectedDir == null ? null : this.selectedDir.toString());
        this.editor.setToolTipText(this.model.getDescription(n));
        return this.editor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return this.model.getValueAt(this.selectedRow, this.selectedColumn);
    }
}

