/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectImpl;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistentFieldFactory {
    private static Logger log = LoggerFactory.getLogger(PersistentFieldFactory.class);
    private static final Class DEFAULT_PERSISTENT_FIELD_IMPL = PersistentFieldDirectImpl.class;
    private static final Class[] METHOD_PARAMETER_TYPES = new Class[]{Class.class, String.class};

    public static PersistentField createPersistentField(Class clazz, String string) {
        return PersistentFieldFactory.createPersistentField(null, clazz, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PersistentField createPersistentField(String string, Class clazz, String string2) {
        try {
            Object[] objectArray;
            if (string == null) {
                objectArray = PersistentFieldFactory.class;
                // MONITORENTER : org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory.class
                string = PersistentFieldFactory.getDefaultPersistentFieldClassName();
                // MONITOREXIT : objectArray
            }
            objectArray = new Object[]{clazz, string2};
            return (PersistentField)ClassHelper.newInstance(string, METHOD_PARAMETER_TYPES, objectArray);
        }
        catch (Exception exception) {
            throw new MetadataException("Error creating PersistentField: " + clazz.getName() + ", " + string2, exception);
        }
    }

    private static String getDefaultPersistentFieldClassName() {
        try {
            PersistenceBrokerConfiguration persistenceBrokerConfiguration = (PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null));
            Class clazz = persistenceBrokerConfiguration.getPersistentFieldClass();
            return clazz.getName();
        }
        catch (ConfigurationException configurationException) {
            log.error("Cannot look-up PersistentField class, use default implementation instead", (Throwable)((Object)configurationException));
            return DEFAULT_PERSISTENT_FIELD_IMPL.getName();
        }
    }
}

