/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryFactory;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.GUID;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.ImplementationImpl;
import org.apache.ojb.odmg.NamedRootsMap;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TxUtil;
import org.apache.ojb.odmg.locking.LockManager;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.DatabaseClosedException;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction,
MaterializationListener,
Configurable,
CollectionProxyListener,
TransactionExt {
    private Logger log = LoggerFactory.getLogger(TransactionImpl.class);
    private boolean impliciteWriteLocks;
    private boolean implicitLocking;
    private boolean ordering;
    private String txGUID;
    protected PersistenceBrokerInternal broker = null;
    private ArrayList registrationList = new ArrayList();
    private ImplementationImpl implementation;
    private NamedRootsMap namedRootsMap;
    private int txStatus = 6;
    protected ObjectEnvelopeTable objectEnvelopeTable = null;
    private DatabaseImpl curDB;
    private ArrayList registeredIndirectionHandlers = new ArrayList();
    private ArrayList registeredCollectionProxies = new ArrayList();
    private ArrayList unmaterializedLocks = new ArrayList();
    private HashMap runtimeCascadeDeleteMap = new HashMap();

    public TransactionImpl(ImplementationImpl implementationImpl) {
        this.implementation = implementationImpl;
        this.impliciteWriteLocks = implementationImpl.isImpliciteWriteLocks();
        this.implicitLocking = implementationImpl.isImplicitLocking();
        this.ordering = implementationImpl.isOrdering();
        this.txGUID = new GUID().toString();
        this.curDB = implementationImpl.getCurrentDatabase();
        this.namedRootsMap = new NamedRootsMap(this);
    }

    public ImplementationImpl getImplementation() {
        return this.implementation;
    }

    public NamedRootsMap getNamedRootsMap() {
        return this.namedRootsMap;
    }

    public DatabaseImpl getAssociatedDatabase() {
        return this.curDB;
    }

    protected int getStatus() {
        return this.txStatus;
    }

    protected void setStatus(int n) {
        this.txStatus = n;
    }

    private void checkForDB() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            this.log.error("Transaction without a associated open Database.");
            throw new TransactionAbortedExceptionOJB("No open database found. Open the database before handling transactions");
        }
    }

    @Override
    public boolean isOpen() {
        return this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() == 2 || this.getStatus() == 7 || this.getStatus() == 8;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new TransactionNotInProgressException("Transaction was not open, call tx.begin() before perform action, current status is: " + TxUtil.getStatusString(this.getStatus()));
        }
    }

    @Override
    public void join() {
        this.checkOpen();
        this.implementation.getTxManager().deregisterTx(this);
        this.implementation.getTxManager().registerTx(this);
    }

    @Override
    public void lock(Object object, int n) throws LockNotGrantedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock object was called on tx " + this + ", object is " + object.toString());
        }
        this.checkOpen();
        RuntimeObject runtimeObject = new RuntimeObject(object, this);
        this.lockAndRegister(runtimeObject, n, this.isImplicitLocking(), this.getRegistrationList());
    }

    public ArrayList getRegistrationList() {
        this.clearRegistrationList();
        return this.registrationList;
    }

    public void clearRegistrationList() {
        this.registrationList.clear();
    }

    public void lockAndRegister(RuntimeObject runtimeObject, int n, List list) {
        this.lockAndRegister(runtimeObject, n, this.isImplicitLocking(), list);
    }

    public synchronized void lockAndRegister(RuntimeObject runtimeObject, int n, boolean bl, List list) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock and register called for " + runtimeObject.getIdentity());
        }
        if (!list.contains(runtimeObject.getIdentity())) {
            if (bl) {
                list.add(runtimeObject.getIdentity());
                this.lockAndRegisterReferences(runtimeObject.getCld(), runtimeObject.getObjMaterialized(), n, list);
            }
            try {
                if (!runtimeObject.isNew()) {
                    this.doSingleLock(runtimeObject.getCld(), runtimeObject.getObj(), runtimeObject.getIdentity(), n);
                }
                this.doSingleRegister(runtimeObject, n);
            }
            catch (Throwable throwable) {
                this.implementation.getLockManager().releaseLock(this, runtimeObject.getIdentity(), runtimeObject.getObj());
                if (throwable instanceof LockNotGrantedException) {
                    throw (LockNotGrantedException)throwable;
                }
                this.log.error("Unexpected failure while locking", throwable);
                throw new LockNotGrantedException("Locking failed for " + runtimeObject.getIdentity() + ", nested exception is: [" + throwable.getClass().getName() + ": " + throwable.getMessage() + "]");
            }
            if (bl) {
                this.lockAndRegisterCollections(runtimeObject.getCld(), runtimeObject.getObjMaterialized(), n, list);
            }
        }
    }

    void doSingleLock(ClassDescriptor classDescriptor, Object object, Identity identity, int n) throws LockNotGrantedException {
        LockManager lockManager = this.implementation.getLockManager();
        if (classDescriptor.isAcceptLocks()) {
            if (n == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do READ lock on object: " + identity);
                }
                if (!lockManager.readLock(this, identity, object)) {
                    throw new LockNotGrantedException("Can not lock for READ: " + identity);
                }
            } else if (n == 4) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do WRITE lock on object: " + identity);
                }
                if (!lockManager.writeLock(this, identity, object)) {
                    throw new LockNotGrantedException("Can not lock for WRITE: " + identity);
                }
            } else if (n == 2) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do UPGRADE lock on object: " + identity);
                }
                if (!lockManager.upgradeLock(this, identity, object)) {
                    throw new LockNotGrantedException("Can not lock for UPGRADE: " + identity);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Class '" + classDescriptor.getClassNameOfObject() + "' doesn't accept locks" + " (accept-locks=false) when implicite locked, so OJB skip this object: " + identity);
        }
    }

    @Override
    public void leave() {
        this.checkOpen();
        this.implementation.getTxManager().deregisterTx(this);
    }

    protected synchronized void doWriteObjects(boolean bl) throws TransactionAbortedException, LockNotGrantedException {
        if (!this.getBroker().isInTransaction()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("call beginTransaction() on PB instance");
            }
            this.broker.beginTransaction();
        }
        this.performTransactionAwareBeforeCommit();
        this.objectEnvelopeTable.writeObjects(bl);
        this.namedRootsMap.performDeletion();
        this.namedRootsMap.performInsert();
        this.namedRootsMap.afterWriteCleanup();
    }

    protected synchronized void doAbort() {
        this.performTransactionAwareBeforeRollback();
        this.objectEnvelopeTable.rollback();
        this.performTransactionAwareAfterRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doClose() {
        try {
            Object object;
            LockManager lockManager = this.getImplementation().getLockManager();
            Enumeration enumeration = this.objectEnvelopeTable.elements();
            while (enumeration.hasMoreElements()) {
                object = (ObjectEnvelope)enumeration.nextElement();
                lockManager.releaseLock(this, ((ObjectEnvelope)object).getIdentity(), ((ObjectEnvelope)object).getObject());
            }
            object = this.unmaterializedLocks.iterator();
            while (object.hasNext()) {
                lockManager.releaseLock(this, object.next());
            }
            this.unRegisterFromAllIndirectionHandlers();
            this.unRegisterFromAllCollectionProxies();
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.implementation.getTxManager().deregisterTx(this);
            this.refresh();
        }
    }

    protected void refresh() {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refresh this transaction for reuse: " + this);
            }
            try {
                this.objectEnvelopeTable.refresh();
            }
            catch (Exception exception) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("error closing object envelope table : " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.cleanupBroker();
        this.broker = null;
        this.clearRegistrationList();
        this.unmaterializedLocks.clear();
        this.txStatus = 6;
    }

    @Override
    public void checkpoint() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checkpoint was called, commit changes hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doWriteObjects(true);
            if (this.hasBroker() && this.broker.isInTransaction()) {
                this.broker.commitTransaction();
            }
        }
        catch (Throwable throwable) {
            this.log.error("Checkpoint call failed, do abort transaction", throwable);
            this.txStatus = 1;
            this.abort();
            if (!(throwable instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't tx.checkpoint() objects: " + throwable.getMessage(), throwable);
            }
            throw (ODMGRuntimeException)throwable;
        }
    }

    @Override
    public void flush() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush was called - write changes to database, do not commit, hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doWriteObjects(true);
        }
        catch (Throwable throwable) {
            this.log.error("Calling method 'tx.flush()' failed", throwable);
            this.txStatus = 1;
            this.abort();
            if (!(throwable instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't tx.flush() objects: " + throwable.getMessage(), throwable);
            }
            throw (ODMGRuntimeException)throwable;
        }
    }

    @Override
    public void markDelete(Object object) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.get(object, false);
        objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDelete());
    }

    public void deletePersistent(RuntimeObject runtimeObject) {
        Object object;
        if (runtimeObject.isProxy()) {
            object = runtimeObject.getHandler().getRealSubject();
            runtimeObject = new RuntimeObject(object, runtimeObject.getIdentity(), this, false);
        }
        this.lockAndRegister(runtimeObject, 4, this.getRegistrationList());
        object = this.objectEnvelopeTable.getByIdentity(runtimeObject.getIdentity());
        ((ObjectEnvelope)object).refreshObjectIfNeeded(runtimeObject.getObj());
        ((ObjectEnvelope)object).setModificationState(((ObjectEnvelope)object).getModificationState().markDelete());
    }

    @Override
    public void markDirty(Object object) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.get(object, false);
        objectEnvelope.refreshObjectIfNeeded(object);
        objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
    }

    void markDirty(RuntimeObject runtimeObject) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.get(runtimeObject.getIdentity(), runtimeObject.getObj(), runtimeObject.isNew());
        objectEnvelope.refreshObjectIfNeeded(runtimeObject.getObj());
        objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
    }

    void markPersistent(RuntimeObject runtimeObject) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.getByIdentity(runtimeObject.getIdentity());
        if (objectEnvelope == null) {
            objectEnvelope = this.objectEnvelopeTable.get(runtimeObject.getIdentity(), runtimeObject.getObj(), runtimeObject.isNew());
        }
        if (objectEnvelope.needsDelete()) {
            objectEnvelope.setModificationState(objectEnvelope.getModificationState().markNew());
        } else {
            objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
        }
        objectEnvelope.refreshObjectIfNeeded(runtimeObject.getObj());
    }

    void makePersistent(RuntimeObject runtimeObject) {
        try {
            this.lockAndRegister(runtimeObject, 4, this.getRegistrationList());
            this.markPersistent(runtimeObject);
        }
        catch (org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            this.log.error("Can't persist object: " + runtimeObject.getIdentity(), (Throwable)((Object)classNotPersistenceCapableException));
            throw new ClassNotPersistenceCapableException(classNotPersistenceCapableException.getMessage());
        }
    }

    @Override
    public boolean isDeleted(Identity identity) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.getByIdentity(identity);
        return objectEnvelope != null && objectEnvelope.needsDelete();
    }

    @Override
    public boolean tryLock(Object object, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Try to lock object was called on tx " + this);
        }
        this.checkOpen();
        try {
            this.lock(object, n);
            return true;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            return false;
        }
    }

    @Override
    public void commit() {
        this.checkOpen();
        try {
            this.prepareCommit();
            this.checkForCommit();
            this.txStatus = 8;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit transaction " + this);
            }
            if (this.hasBroker()) {
                this.getBroker().commitTransaction();
            }
            this.performTransactionAwareAfterCommit();
            this.doClose();
            this.txStatus = 3;
        }
        catch (Exception exception) {
            this.log.error("Error while commit objects, do abort tx " + this + ", " + exception.getMessage(), exception);
            this.txStatus = 1;
            this.abort();
            if (!(exception instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't commit objects: " + exception.getMessage(), exception);
            }
            throw (ODMGRuntimeException)exception;
        }
    }

    protected void checkForCommit() {
        if (this.txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("Illegal tx-status: tx is already markedRollback");
        }
        if (this.txStatus != 2) {
            throw new IllegalStateException("Illegal tx-status: Do prepare commit before commit");
        }
    }

    protected void prepareCommit() throws TransactionAbortedException, LockNotGrantedException {
        if (this.txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("Prepare Transaction: tx already marked for rollback");
        }
        if (this.txStatus != 0) {
            throw new IllegalStateException("Prepare Transaction: tx status is not 'active', status is " + TxUtil.getStatusString(this.txStatus));
        }
        try {
            this.txStatus = 7;
            this.doWriteObjects(false);
            this.txStatus = 2;
        }
        catch (RuntimeException runtimeException) {
            this.log.error("Could not prepare for commit", runtimeException);
            this.txStatus = 1;
            throw runtimeException;
        }
    }

    @Override
    public void abort() {
        if (this.txStatus == 6 || this.txStatus == 5 || this.txStatus == 4) {
            this.log.info("Nothing to abort, tx is not active - status is " + TxUtil.getStatusString(this.txStatus));
            return;
        }
        if (this.txStatus != 0 && this.txStatus != 2 && this.txStatus != 1) {
            throw new IllegalStateException("Illegal state for abort call, state was '" + TxUtil.getStatusString(this.txStatus) + "'");
        }
        if (this.log.isEnabledFor(2)) {
            this.log.info("Abort transaction was called on tx " + this);
        }
        try {
            try {
                this.doAbort();
            }
            catch (Exception exception) {
                this.log.error("Error while abort transaction, will be skipped", exception);
            }
            this.implementation.getTxManager().abortExternalTx(this);
            try {
                if (this.hasBroker() && this.getBroker().isInTransaction()) {
                    this.getBroker().abortTransaction();
                }
            }
            catch (Exception exception) {
                this.log.error("Error while do abort used broker instance, will be skipped", exception);
            }
        }
        finally {
            this.txStatus = 4;
            this.doClose();
        }
    }

    @Override
    public synchronized void begin() {
        this.checkForBegin();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Begin transaction was called on tx " + this);
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.implementation.getTxManager().registerTx(this);
        this.txStatus = 0;
    }

    protected void checkForBegin() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to begin the Tx.");
        }
        if (this.isOpen()) {
            this.log.error("Transaction is already open");
            throw new TransactionInProgressException("Impossible to call begin on already opened tx");
        }
    }

    public String getGUID() {
        return this.txGUID;
    }

    public Object getObjectByIdentity(Identity identity) throws PersistenceBrokerException {
        this.checkOpen();
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.getByIdentity(identity);
        if (objectEnvelope != null) {
            return objectEnvelope.needsDelete() ? null : objectEnvelope.getObject();
        }
        return this.getBroker().getObjectByIdentity(identity);
    }

    void doSingleRegister(RuntimeObject runtimeObject, int n) throws LockNotGrantedException, PersistenceBrokerException {
        Serializable serializable;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Register object " + runtimeObject.getIdentity());
        }
        Object object = runtimeObject.getObj();
        if (runtimeObject.isProxy()) {
            serializable = runtimeObject.getHandler();
            if (serializable == null) {
                throw new OJBRuntimeException("Unexpected error, expect an proxy object as indicated: " + runtimeObject);
            }
            if (serializable.alreadyMaterialized()) {
                object = serializable.getRealSubject();
            } else {
                this.registerToIndirectionHandler((IndirectionHandler)serializable);
                this.registerUnmaterializedLocks(runtimeObject.getObj());
                object = null;
            }
        }
        if (object != null) {
            serializable = this.objectEnvelopeTable.getByIdentity(runtimeObject.getIdentity());
            if (serializable == null) {
                serializable = this.objectEnvelopeTable.get(runtimeObject.getIdentity(), object, runtimeObject.isNew());
            } else {
                ((ObjectEnvelope)serializable).refreshObjectIfNeeded(object);
            }
            if (n == 4) {
                ((ObjectEnvelope)serializable).setWriteLocked(true);
            }
        }
    }

    private void lockAndRegisterReferences(ClassDescriptor classDescriptor, Object object, int n, List list) throws LockNotGrantedException {
        if (this.implicitLocking) {
            for (ObjectReferenceDescriptor objectReferenceDescriptor : classDescriptor.getObjectReferenceDescriptors(true)) {
                boolean bl;
                RuntimeObject runtimeObject;
                Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
                if (object2 == null || this.registrationList.contains((runtimeObject = (bl = ProxyHelper.isProxy(object2)) ? new RuntimeObject(object2, this, false) : new RuntimeObject(object2, this)).getIdentity())) continue;
                this.lockAndRegister(runtimeObject, n, list);
            }
        }
    }

    private void lockAndRegisterCollections(ClassDescriptor classDescriptor, Object object, int n, List list) throws LockNotGrantedException {
        if (this.implicitLocking) {
            for (CollectionDescriptor collectionDescriptor : classDescriptor.getCollectionDescriptors(true)) {
                Object object2;
                Object object3 = collectionDescriptor.getPersistentField().get(object);
                if (object3 == null) continue;
                CollectionProxy collectionProxy = ProxyHelper.getCollectionProxy(object3);
                if (collectionProxy != null && !collectionProxy.isLoaded()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("adding self as listener to collection proxy");
                    }
                    collectionProxy.addListener(this);
                    this.registeredCollectionProxies.add(collectionProxy);
                    continue;
                }
                Iterator iterator = BrokerHelper.getCollectionIterator(object3);
                Object object4 = null;
                try {
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        RuntimeObject runtimeObject = new RuntimeObject(object4, this);
                        if (runtimeObject.isProxy()) {
                            object2 = ProxyHelper.getIndirectionHandler(object4);
                            if (!object2.alreadyMaterialized()) {
                                this.registerToIndirectionHandler((IndirectionHandler)object2);
                                continue;
                            }
                            object4 = object2.getRealSubject();
                        }
                        if (this.registrationList.contains(runtimeObject.getIdentity())) continue;
                        this.lockAndRegister(runtimeObject, n, list);
                    }
                }
                catch (LockNotGrantedException lockNotGrantedException) {
                    object2 = SystemUtils.LINE_SEPARATOR;
                    this.log.error("Lock not granted, while lock collection references[" + (String)object2 + "current reference descriptor:" + (String)object2 + collectionDescriptor.toXML() + (String)object2 + "object to lock: " + object4 + (String)object2 + "main object class: " + object.getClass().getName() + (String)object2 + "]", lockNotGrantedException);
                    throw lockNotGrantedException;
                }
            }
        }
    }

    @Override
    public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
    }

    @Override
    public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        try {
            Identity identity = indirectionHandler.getIdentity();
            if (this.log.isDebugEnabled()) {
                this.log.debug("deferred registration: " + identity);
            }
            if (!this.isOpen()) {
                this.log.error("Proxy object materialization outside of a running tx, obj=" + identity);
                try {
                    throw new Exception("Proxy object materialization outside of a running tx, obj=" + identity);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ClassDescriptor classDescriptor = this.getBroker().getClassDescriptor(object.getClass());
            RuntimeObject runtimeObject = new RuntimeObject(object, identity, classDescriptor, false, false);
            this.lockAndRegister(runtimeObject, 1, this.isImplicitLocking(), this.getRegistrationList());
        }
        catch (Throwable throwable) {
            this.log.error("Register materialized object with this tx failed", throwable);
            throw new LockNotGrantedException(throwable.getMessage());
        }
        this.unregisterFromIndirectionHandler(indirectionHandler);
    }

    protected synchronized void unRegisterFromAllIndirectionHandlers() {
        for (int i = this.registeredIndirectionHandlers.size() - 1; i >= 0; --i) {
            this.unregisterFromIndirectionHandler((IndirectionHandler)this.registeredIndirectionHandlers.get(i));
        }
    }

    protected synchronized void unRegisterFromAllCollectionProxies() {
        for (int i = this.registeredCollectionProxies.size() - 1; i >= 0; --i) {
            this.unregisterFromCollectionProxy((CollectionProxy)this.registeredCollectionProxies.get(i));
        }
    }

    protected synchronized void unregisterFromCollectionProxy(CollectionProxy collectionProxy) {
        collectionProxy.removeListener(this);
        this.registeredCollectionProxies.remove(collectionProxy);
    }

    protected synchronized void unregisterFromIndirectionHandler(IndirectionHandler indirectionHandler) {
        indirectionHandler.removeListener(this);
        this.registeredIndirectionHandlers.remove(indirectionHandler);
    }

    protected synchronized void registerToIndirectionHandler(IndirectionHandler indirectionHandler) {
        indirectionHandler.addListener(this);
        this.registeredIndirectionHandlers.add(indirectionHandler);
    }

    protected void registerUnmaterializedLocks(Object object) {
        this.unmaterializedLocks.add(object);
    }

    public PersistenceBrokerInternal getBrokerInternal() {
        if (this.broker == null || this.broker.isClosed()) {
            this.checkOpen();
            try {
                this.checkForDB();
                this.broker = PersistenceBrokerFactoryFactory.instance().createPersistenceBroker(this.curDB.getPBKey());
            }
            catch (PBFactoryException pBFactoryException) {
                this.log.error("Cannot obtain PersistenceBroker from PersistenceBrokerFactory, found PBKey was " + this.curDB.getPBKey(), (Throwable)((Object)pBFactoryException));
                throw new PersistenceBrokerException((Throwable)((Object)pBFactoryException));
            }
        }
        return this.broker;
    }

    @Override
    public PersistenceBroker getBroker() {
        return this.getBrokerInternal();
    }

    protected boolean hasBroker() {
        return this.broker != null && !this.broker.isClosed();
    }

    protected void cleanupBroker() {
        if (this.hasBroker()) {
            try {
                if (this.broker.isInTransaction()) {
                    this.broker.abortTransaction();
                }
            }
            finally {
                this.broker.close();
                this.broker = null;
            }
        }
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
    }

    @Override
    public synchronized void setImplicitLocking(boolean bl) {
        this.implicitLocking = bl;
    }

    @Override
    public boolean isImplicitLocking() {
        return this.implicitLocking;
    }

    @Override
    public void beforeLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
    }

    @Override
    public void afterLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("loading a proxied collection a collection: " + collectionProxyDefaultImpl);
        }
        Collection collection = collectionProxyDefaultImpl.getData();
        for (Object e : collection) {
            if (!this.isOpen()) {
                this.log.error("Collection proxy materialization outside of a running tx, obj=" + e);
                try {
                    throw new Exception("Collection proxy materialization outside of a running tx, obj=" + e);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            Identity identity = this.getBroker().serviceIdentity().buildIdentity(e);
            ClassDescriptor classDescriptor = this.getBroker().getClassDescriptor(ProxyHelper.getRealClass(e));
            RuntimeObject runtimeObject = new RuntimeObject(e, identity, classDescriptor, false, ProxyHelper.isProxy(e));
            this.lockAndRegister(runtimeObject, 1, this.isImplicitLocking(), this.getRegistrationList());
        }
        this.unregisterFromCollectionProxy(collectionProxyDefaultImpl);
    }

    protected void performTransactionAwareBeforeCommit() {
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            ((ObjectEnvelope)enumeration.nextElement()).beforeCommit();
        }
    }

    protected void performTransactionAwareAfterCommit() {
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        try {
            while (enumeration.hasMoreElements()) {
                ((ObjectEnvelope)enumeration.nextElement()).afterCommit();
            }
        }
        catch (Exception exception) {
            this.log.error("Unexpected error while perform 'TransactionAware#afterCommit()' listener after commit of objects, after commit you can't rollback - exception will be skipped.", exception);
        }
    }

    protected void performTransactionAwareBeforeRollback() {
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((ObjectEnvelope)enumeration.nextElement()).beforeAbort();
            }
            catch (Exception exception) {
                this.log.error("Unexpected error while perform 'TransactionAware#beforeAbort()' listener before rollback of objects - exception will be skipped to complete rollback.", exception);
            }
        }
    }

    protected void performTransactionAwareAfterRollback() {
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        try {
            while (enumeration.hasMoreElements()) {
                ((ObjectEnvelope)enumeration.nextElement()).afterAbort();
            }
        }
        catch (Exception exception) {
            this.log.error("Unexpected error while perform 'TransactionAware#afterAbort()' listener after rollback of objects - exception will be skipped.", exception);
        }
    }

    protected boolean isTransient(ClassDescriptor classDescriptor, Object object, Identity identity) {
        boolean bl;
        boolean bl2 = bl = identity != null && identity.isTransient();
        if (!bl) {
            PersistenceBroker persistenceBroker = this.getBroker();
            if (classDescriptor == null) {
                classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
            }
            if (!(bl = persistenceBroker.serviceBrokerHelper().hasNullPKField(classDescriptor, object))) {
                ObjectEnvelope objectEnvelope;
                if (identity == null) {
                    identity = persistenceBroker.serviceIdentity().buildIdentity(classDescriptor, object);
                }
                bl = (objectEnvelope = this.objectEnvelopeTable.getByIdentity(identity)) != null ? objectEnvelope.needsInsert() : persistenceBroker.serviceObjectCache().lookup(identity) == null && !persistenceBroker.serviceBrokerHelper().doesExist(classDescriptor, identity, object);
            }
        }
        return bl;
    }

    @Override
    public void setCascadingDelete(Class clazz, String string, boolean bl) {
        ClassDescriptor classDescriptor = this.getBroker().getClassDescriptor(clazz);
        ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string);
        if (objectReferenceDescriptor == null) {
            objectReferenceDescriptor = classDescriptor.getCollectionDescriptorByName(string);
        }
        if (objectReferenceDescriptor == null) {
            throw new CascadeSettingException("Invalid reference field name '" + string + "', can't find 1:1, 1:n or m:n relation with that name in " + clazz);
        }
        this.runtimeCascadeDeleteMap.put(objectReferenceDescriptor, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setCascadingDelete(Class clazz, boolean bl) {
        ClassDescriptor classDescriptor = this.getBroker().getClassDescriptor(clazz);
        Vector vector = classDescriptor.getExtentClasses();
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setCascadingDelete(classDescriptor, bl2);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Class clazz2 = (Class)vector.get(i);
                ClassDescriptor classDescriptor2 = this.getBroker().getClassDescriptor(clazz2);
                this.setCascadingDelete(classDescriptor2, bl2);
            }
        }
    }

    private void setCascadingDelete(ClassDescriptor classDescriptor, Boolean bl) {
        List list = classDescriptor.getObjectReferenceDescriptors(true);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            this.runtimeCascadeDeleteMap.put(e, bl);
        }
        List list2 = classDescriptor.getCollectionDescriptors(true);
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            this.runtimeCascadeDeleteMap.put(e, bl);
        }
    }

    protected boolean cascadeDeleteFor(ObjectReferenceDescriptor objectReferenceDescriptor) {
        Boolean bl = (Boolean)this.runtimeCascadeDeleteMap.get(objectReferenceDescriptor);
        boolean bl2 = bl == null ? objectReferenceDescriptor.getCascadingDelete() == 23 : bl;
        return bl2;
    }

    int getImpliciteLockType(int n) {
        return n == 4 && this.impliciteWriteLocks ? 4 : 1;
    }

    @Override
    public boolean isOrdering() {
        return this.ordering;
    }

    @Override
    public void setOrdering(boolean bl) {
        this.ordering = bl;
    }

    static class CascadeSettingException
    extends OJBRuntimeException {
        public CascadeSettingException() {
        }

        public CascadeSettingException(String string) {
            super(string);
        }

        public CascadeSettingException(Throwable throwable) {
            super(throwable);
        }

        public CascadeSettingException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

