/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.support;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.PomModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MinimalPomParser
extends DefaultHandler {
    private int depth;
    private PomModel.InternalModel model = new PomModel.InternalModel();
    private StringBuilder characters;
    private String pomGroupId;
    private String pomArtifactId;
    private String pomVersion;
    private String currentGroupId;
    private String currentArtifactId;
    private String currentVersion;
    private String currentScope;

    private MinimalPomParser() {
    }

    public static PomModel parse(String path, InputStream is) {
        MinimalPomParser handler = new MinimalPomParser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse File '" + path + "'", e);
        }
        return handler.getPomModel();
    }

    public PomModel getPomModel() {
        return this.model;
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if ("groupId".equals(qname) || "artifactId".equals(qname) || "version".equals(qname) || "scope".equals(qname)) {
            this.characters = new StringBuilder();
        }
        ++this.depth;
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if ("project".equals(qname)) {
            AFReleaseId parentReleaseId = this.model.getParentReleaseId();
            this.model.setReleaseId(new AFReleaseIdImpl(this.pomGroupId != null ? this.pomGroupId : parentReleaseId.getGroupId(), this.pomArtifactId, this.pomVersion != null ? this.pomVersion : parentReleaseId.getVersion()));
        } else if ("parent".equals(qname)) {
            if (this.currentGroupId != null && this.currentArtifactId != null && this.currentVersion != null) {
                this.model.setParentReleaseId(new AFReleaseIdImpl(this.currentGroupId, this.currentArtifactId, this.currentVersion));
            }
            this.currentGroupId = null;
            this.currentArtifactId = null;
            this.currentVersion = null;
        } else if ("dependency".equals(qname)) {
            if (this.currentGroupId != null && this.currentArtifactId != null && this.currentVersion != null) {
                this.model.addDependency(new AFReleaseIdImpl(this.currentGroupId, this.currentArtifactId, this.currentVersion), this.currentScope != null ? this.currentScope : "");
            }
            this.currentGroupId = null;
            this.currentArtifactId = null;
            this.currentVersion = null;
            this.currentScope = null;
        } else {
            String text;
            String string = text = this.characters != null ? this.characters.toString() : null;
            if (text != null) {
                if ("groupId".equals(qname)) {
                    if (this.depth == 2) {
                        this.pomGroupId = text;
                    } else {
                        this.currentGroupId = text;
                    }
                } else if ("artifactId".equals(qname)) {
                    if (this.depth == 2) {
                        this.pomArtifactId = text;
                    } else {
                        this.currentArtifactId = text;
                    }
                } else if ("version".equals(qname)) {
                    if (this.depth == 2) {
                        this.pomVersion = text;
                    } else {
                        this.currentVersion = text;
                    }
                } else if ("scope".equals(qname)) {
                    this.currentScope = text;
                }
            }
        }
        this.characters = null;
        --this.depth;
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        if (this.characters != null) {
            this.characters.append(chars, start, len);
        }
    }
}

